/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for cook/match.c
 */

#ifndef MATCH_H
#define MATCH_H

#include <main.h>
#include <word.h>

#define MATCH_CHAR '%'

typedef struct match_ty match_ty;
struct match_ty
{
	string_ty	*fill[11];
	match_ty	*next;
};

match_ty *match _((string_ty *, string_ty *));
string_ty *reconstruct _((string_ty *, match_ty *));
void match_push _((match_ty *));
match_ty *match_pop _((void));
match_ty *match_top _((void));
void match_free _((match_ty *));
match_ty *wl_match _((wlist *, string_ty *));
void wl_reconstruct _((wlist *, wlist *, match_ty *));

#endif /* MATCH_H */
