/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1991, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for cook/expr.c
 */

#ifndef EXPR_H
#define EXPR_H

#include <str.h>
#include <word.h>

/*
 *  e_op values
 */
enum expr_op_ty
{
    OP_CAT = 1,
    OP_FUNC,
    OP_WORD
};
typedef enum expr_op_ty expr_op_ty;

typedef struct elist elist;
struct	elist
{
	size_t		el_nexprs;
	struct expr	**el_expr;
};

typedef struct position position;
struct	position
{
	string_ty	*pos_name;
	int		pos_line;
};

typedef struct expr expr;
struct expr
{
	expr_op_ty	e_op;
	long		e_references;
	position	e_position;
	union
	{
		string_ty	*e__word;
		elist		e__list;
		expr		*e__arg[2];
	}
		e__u;
};
#define e_word	e__u.e__word
#define e_list	e__u.e__list
#define e_left	e__u.e__arg[0]
#define e_right e__u.e__arg[1]

expr *expr_alloc _((void));
expr *expr_copy _((expr *));
void expr_free _((expr *));
int expr_eval _((wlist *, expr *));
void el_append _((elist *, expr *));
void el_free _((elist *));
void el_copy _((elist *, elist *));
int el2wl _((wlist *, elist *));
int expr_eval_condition _((expr *));
void expr_error _((char *, ...));
void el_zero _((elist *));

#endif /* EXPR_H */
