/*
 *	cook - file construction tool
 *	Copyright (C) 1991, 1992, 1993, 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement missing ANSI C mandated functions
 *
 * This file contains functions for use with non-ANSI conforming systems
 * to implement absent ANSI functionality.
 */

#include <ac/stddef.h>
#include <ac/stdlib.h>
#include <ac/string.h>
#include <stdio.h>

#include <main.h>


/*
 * NAME
 *	strerror - string for error number
 *
 * SYNOPSIS
 *	char *strerror(int errnum);
 *
 * DESCRIPTION
 *	The strerror function maps the error number in errnum to an error
 *	message string.
 *
 * RETURNS
 *	The strerror function returns a pointer to the string, the contents of
 *	which are implementation-defined.  The array pointed to shall not be
 *	modified by the program, but may be overwritten by a subsequent call to
 *	the strerror function.
 *
 * CAVEAT
 *	Unknown errors will be rendered in the form "Error %d", where %d will
 *	be replaced by a decimal representation of the error number.
 */

#ifndef HAVE_STRERROR

char *
strerror(n)
	int		n;
{
	extern int	sys_nerr;
	extern char	*sys_errlist[];
	static char	buffer[16];

	if (n < 1 || n > sys_nerr)
	{
		sprintf(buffer, "Error %d", n);
		return buffer;
	}
	return sys_errlist[n];
}

#endif
