/*
 *	cook - file construction tool
 *	Copyright (C) 1991, 1992, 1993, 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for c_incl/sniff.c
 */

#ifndef SNIFF_H
#define SNIFF_H

#include <stdio.h>
#include <main.h>

enum
{
	absent_ignore,
	absent_mention,
	absent_error
};

typedef struct option_ty option_ty;
struct option_ty
{
	int	o_verbose;
	int	o_absent_local;
	int	o_absent_system;
	int	o_absent_program;
};
extern option_ty option;

struct wlist;

typedef struct sniff_ty sniff_ty;
struct sniff_ty
{
	int (*scan)_((FILE *, struct wlist *, struct wlist *));
	void (*prepare)_((void));
};

extern	sniff_ty	lang_c;
extern	sniff_ty	lang_roff;

extern char *prefix;
extern char *suffix;

void sniff _((char *));
void sniff_include _((char *));
long sniff_include_count _((void));
void sniff_prepare _((void));
void sniff_language _((sniff_ty *));

#endif /* SNIFF_H */
