  (**************************************************************) 
  (*   This module was generated by BEG V1.75        *)
  (*        GMD Forschunsstelle an der Universitaet Karlsruhe   *)
  (*        Vincenz-Priessnitz-Str. 1 76131 Karlsruhe Germany   *)
  (**************************************************************)
 DEFINITION MODULE IR;
 
(*++++++ start insertion IpTypes ++++++*)

IMPORT CgBase;
FROM Strings	IMPORT	String;


(*------ end   insertion IpTypes ------*)
(******* empty insertion IpIR_d *******)
 FROM CgMobil IMPORT BegRegister;
 
 CONST    MaxArity        = 4;
          MaxScratch      = 2;
 
 TYPE     OpCode = (NoOpCode 
          ,opShortCardConstant
          ,opLongCardConstant
          ,opShortIntConstant
          ,opLongIntConstant
          ,opRealConstant
          ,opLongRealConstant
          ,opCharConstant
          ,opBoolConstant
          ,opSetConstant
          ,opNilConstant
          ,opProcedureConstant
          ,opStringAddr
          ,opLocalVariable
          ,opStaticVariable
          ,opFrameBase
          ,opContent
          ,opAssign
          ,opAssignLong
          ,opInc1
          ,opInc2
          ,opDec1
          ,opDec2
          ,opInclL
          ,opExclL
          ,opSkipAddress
          ,opSkipData
          ,opFixedNegate
          ,opFixedPlus
          ,opFixedMinus
          ,opFixedMult
          ,opFixedDiv
          ,opFixedMod
          ,opFixedAbs
          ,opFloatNegate
          ,opFloatPlus
          ,opFloatMinus
          ,opFloatMult
          ,opFloatDiv
          ,opFloatAbs
          ,opSetUnion
          ,opSetDifference
          ,opSetIntersection
          ,opSetSymDifference
          ,opSetPlusSingleL
          ,opSetPlusRange
          ,opCap
          ,opFloat
          ,opTrunc
          ,opCoerce
          ,opCheckL
          ,opFixedCompare
          ,opFloatCompare
          ,opSetCompare
          ,opTestMembershipL
          ,opTestOdd
          ,opPlaceLabel
          ,opGoto
          ,opSwitchL
          ,opTestAndBranch
          ,opFixedCompareAndBranch
          ,opFloatCompareAndBranch
          ,opSetCompareAndBranch
          ,opTestMembershipAndBranchL
          ,opTestOddAndBranch
          ,opNil
          ,opSkipArglist
          ,opPass
          ,opPassLong
          ,opProcedureCall
          ,opFunctionCall
          ,opRTSCall
          ,opBeginProcedure
          ,opCopyOpenArray
          ,opReturn
          ,opReturnValueL
          ,opEndProcedure
          ,opEndModule
          ,opMark
          ); 
 

        Expression = POINTER TO ExpressionRecord;
        Attributes = POINTER TO AttributesRecord;
        ExprAttributes  =  POINTER TO ExprAttrRec;

 CONST 
     MaxPscArity = 3;

 TYPE     

   NonTerminal = ( ntreg
      ,ntfreg
      ,ntfstack
      ,ntConstant
      ,ntFloatConstant
      ,ntSimpleVariable
      ,ntSymPlusOffset
      ,ntRegPlusSymPlusOffset
      ,ntOffsetPlusIndexMultFaktor
      ,ntmem
      ,ntCMem
      ,ntRegOrIm
      ,ntRegOrCMem
      ,ntRegOrCMemOrIm
      ,ntarglist
      ,ntloadln2
   );
   Register    = BegRegister;
TYPE RegisterSet = ARRAY [0..0] OF BITSET;
PROCEDURE RegUnion	(a, b: RegisterSet; VAR r: RegisterSet);
PROCEDURE RegInter	(a, b: RegisterSet; VAR r: RegisterSet);
PROCEDURE RegMinus	(a, b: RegisterSet; VAR r: RegisterSet);
PROCEDURE RegNegate	(a: RegisterSet; VAR r: RegisterSet);
PROCEDURE RegEmpty	(a: RegisterSet): BOOLEAN;
PROCEDURE RegIsIn	(a: Register; b: RegisterSet): BOOLEAN;
PROCEDURE RegIncl	(VAR a: RegisterSet; b: Register);
PROCEDURE RegExcl	(VAR a: RegisterSet; b: Register);
PROCEDURE RegClear	(VAR a: RegisterSet);
PROCEDURE RegDisjoint	(a, b: RegisterSet): BOOLEAN;

 TYPE

   Rule        = [0..279];

 TYPE  Cost = INTEGER;
 CONST infcost = MAX(Cost) DIV 10;

 TYPE
   CostArray   =      ARRAY NonTerminal OF Cost;

 
        ExpressionRecord = 
           RECORD
              attr             : Attributes;
              son              : ARRAY [1..MaxArity] OF Expression;
              arity            : [0..MaxArity];
              gcg              : ExprAttributes;
              hashchain        : Expression;
           END;

 
        AttributesRecord = 
           RECORD
              op        :  OpCode;
 
              CASE  (*op*) : OpCode OF 
              |  NoOpCode : 
 
              |  opShortCardConstant  : ShortCardConstant : RECORD  
                      c  :  SHORTCARD;
                 END;
              |  opLongCardConstant  : LongCardConstant : RECORD  
                      c  :  LONGCARD;
                 END;
              |  opShortIntConstant  : ShortIntConstant : RECORD  
                      c  :  SHORTINT;
                 END;
              |  opLongIntConstant  : LongIntConstant : RECORD  
                      c  :  LONGINT;
                 END;
              |  opRealConstant  : RealConstant : RECORD  
                      c  :  REAL;
                 END;
              |  opLongRealConstant  : LongRealConstant : RECORD  
                      c  :  LONGREAL;
                 END;
              |  opCharConstant  : CharConstant : RECORD  
                      c  :  CHAR;
                 END;
              |  opBoolConstant  : BoolConstant : RECORD  
                      val  :  BOOLEAN;
                 END;
              |  opSetConstant  : SetConstant : RECORD  
                      c  :  BITSET;
                 END;
              |  opNilConstant  : NilConstant : RECORD  
                 END;
              |  opProcedureConstant  : ProcedureConstant : RECORD  
                      index  :  CgBase.ProcIndex;
                 END;
              |  opStringAddr  : StringAddr : RECORD  
                      index  :  CgBase.StringIndex;
                 END;
              |  opLocalVariable  : LocalVariable : RECORD  
                      offset  :  LONGINT;
                 END;
              |  opStaticVariable  : StaticVariable : RECORD  
                      module  :  CgBase.ModuleIndex;
                      offset  :  LONGINT;
                 END;
              |  opFrameBase  : FrameBase : RECORD  
                      proc  :  CgBase.ProcIndex;
                      level  :  SHORTCARD;
                 END;
              |  opContent  : Content : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opAssign  : Assign : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opAssignLong  : AssignLong : RECORD  
                      size  :  LONGINT;
                 END;
              |  opInc1  : Inc1 : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opInc2  : Inc2 : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opDec1  : Dec1 : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opDec2  : Dec2 : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opInclL  : InclL : RECORD  
                 END;
              |  opExclL  : ExclL : RECORD  
                 END;
              |  opSkipAddress  : SkipAddress : RECORD  
                 END;
              |  opSkipData  : SkipData : RECORD  
                 END;
              |  opFixedNegate  : FixedNegate : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFixedPlus  : FixedPlus : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFixedMinus  : FixedMinus : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFixedMult  : FixedMult : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFixedDiv  : FixedDiv : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFixedMod  : FixedMod : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFixedAbs  : FixedAbs : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFloatNegate  : FloatNegate : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFloatPlus  : FloatPlus : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFloatMinus  : FloatMinus : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFloatMult  : FloatMult : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFloatDiv  : FloatDiv : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opFloatAbs  : FloatAbs : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opSetUnion  : SetUnion : RECORD  
                 END;
              |  opSetDifference  : SetDifference : RECORD  
                 END;
              |  opSetIntersection  : SetIntersection : RECORD  
                 END;
              |  opSetSymDifference  : SetSymDifference : RECORD  
                 END;
              |  opSetPlusSingleL  : SetPlusSingleL : RECORD  
                 END;
              |  opSetPlusRange  : SetPlusRange : RECORD  
                      LwbMode  :  CgBase.Mode;
                      UpbMode  :  CgBase.Mode;
                 END;
              |  opCap  : Cap : RECORD  
                 END;
              |  opFloat  : Float : RECORD  
                 END;
              |  opTrunc  : Trunc : RECORD  
                      opmode  :  CgBase.Mode;
                      resultmode  :  CgBase.Mode;
                 END;
              |  opCoerce  : Coerce : RECORD  
                      premode  :  CgBase.Mode;
                      postmode  :  CgBase.Mode;
                 END;
              |  opCheckL  : CheckL : RECORD  
                      IndexMode  :  CgBase.Mode;
                      LwbMode  :  CgBase.Mode;
                      UpbMode  :  CgBase.Mode;
                      CheckLwb  :  BOOLEAN;
                      CheckUpb  :  BOOLEAN;
                 END;
              |  opFixedCompare  : FixedCompare : RECORD  
                      mode  :  CgBase.Mode;
                      rel  :  CgBase.Relation;
                 END;
              |  opFloatCompare  : FloatCompare : RECORD  
                      mode  :  CgBase.Mode;
                      rel  :  CgBase.Relation;
                 END;
              |  opSetCompare  : SetCompare : RECORD  
                      rel  :  CgBase.Relation;
                 END;
              |  opTestMembershipL  : TestMembershipL : RECORD  
                      ElemMode  :  CgBase.Mode;
                      cond  :  BOOLEAN;
                 END;
              |  opTestOdd  : TestOdd : RECORD  
                      mode  :  CgBase.Mode;
                      cond  :  BOOLEAN;
                 END;
              |  opPlaceLabel  : PlaceLabel : RECORD  
                      lab  :  CgBase.Label;
                 END;
              |  opGoto  : Goto : RECORD  
                      tar  :  CgBase.Label;
                 END;
              |  opSwitchL  : SwitchL : RECORD  
                      mode  :  CgBase.Mode;
                      lwb  :  LONGINT;
                      upb  :  LONGINT;
                      CaseLabels  :  CgBase.LabelList;
                      DefaultLabel  :  CgBase.Label;
                 END;
              |  opTestAndBranch  : TestAndBranch : RECORD  
                      cond  :  BOOLEAN;
                      tar  :  CgBase.Label;
                 END;
              |  opFixedCompareAndBranch  : FixedCompareAndBranch : RECORD  
                      mode  :  CgBase.Mode;
                      rel  :  CgBase.Relation;
                      tar  :  CgBase.Label;
                 END;
              |  opFloatCompareAndBranch  : FloatCompareAndBranch : RECORD  
                      mode  :  CgBase.Mode;
                      rel  :  CgBase.Relation;
                      tar  :  CgBase.Label;
                 END;
              |  opSetCompareAndBranch  : SetCompareAndBranch : RECORD  
                      rel  :  CgBase.Relation;
                      tar  :  CgBase.Label;
                 END;
              |  opTestMembershipAndBranchL  : TestMembershipAndBranchL : RECORD  
                      ElemMode  :  CgBase.Mode;
                      cond  :  BOOLEAN;
                      tar  :  CgBase.Label;
                 END;
              |  opTestOddAndBranch  : TestOddAndBranch : RECORD  
                      mode  :  CgBase.Mode;
                      cond  :  BOOLEAN;
                      tar  :  CgBase.Label;
                 END;
              |  opNil  : Nil : RECORD  
                 END;
              |  opSkipArglist  : SkipArglist : RECORD  
                 END;
              |  opPass  : Pass : RECORD  
                      mode  :  CgBase.Mode;
                      offset  :  LONGINT;
                 END;
              |  opPassLong  : PassLong : RECORD  
                      size  :  LONGINT;
                      offset  :  LONGINT;
                      space  :  LONGINT;
                 END;
              |  opProcedureCall  : ProcedureCall : RECORD  
                      paramsize  :  LONGINT;
                 END;
              |  opFunctionCall  : FunctionCall : RECORD  
                      paramsize  :  LONGINT;
                      mode  :  CgBase.Mode;
                 END;
              |  opRTSCall  : RTSCall : RECORD  
                      paramsize  :  LONGINT;
                      sysproc  :  CgBase.SysProc;
                 END;
              |  opBeginProcedure  : BeginProcedure : RECORD  
                      index  :  CgBase.ProcIndex;
                      level  :  SHORTCARD;
                      FrameSize  :  LONGINT;
                      ParamSize  :  LONGINT;
                 END;
              |  opCopyOpenArray  : CopyOpenArray : RECORD  
                      DataOffset  :  LONGINT;
                      HighOffset  :  LONGINT;
                      elemsize  :  LONGINT;
                 END;
              |  opReturn  : Return : RECORD  
                      ParamSize  :  LONGINT;
                 END;
              |  opReturnValueL  : ReturnValueL : RECORD  
                      mode  :  CgBase.Mode;
                 END;
              |  opEndProcedure  : EndProcedure : RECORD  
                 END;
              |  opEndModule  : EndModule : RECORD  
                 END;
              |  opMark  : Mark : RECORD  
                      line  :  SHORTCARD;
                      col  :  SHORTCARD;
                 END;
              END;
              hashchain :  Attributes;
           END;
 

 VAR       emptyAttrRec    : AttributesRecord;
           emptyExprRec    : ExpressionRecord;
           emptyExpression : Expression;
           emptyAttributes : Attributes;
 (* Attributes and Expression Records must be initialized !! because
    they are compared physically                                       *)


TYPE
(*++++++ start insertion IpGcgTypes ++++++*)

 MemAdr      = RECORD
		  offset, faktor: LONGINT;
		  base, index: Register;
		  symbol: CgBase.RelSymb;
	       END;
 AdrModeMode = (Mconst, Mreg, Mmem);
 AdrMode     = RECORD
	          mode : CgBase.Mode;
		  CASE kind : AdrModeMode OF
		    Mconst : constant : LONGINT;
		  | Mreg   : reg      : Register;
		  | Mmem   : mem      : MemAdr;
		  END
	       END;


(*------ end   insertion IpGcgTypes ------*)

   ExprAttrRec =  RECORD
       hashchain   : ExprAttributes;
       reg  : RECORD
               mode  :  CgBase.Mode;
       END; 
       Constant  : RECORD
               val  :  LONGINT;
               mode  :  CgBase.Mode;
       END; 
       FloatConstant  : RECORD
               val  :  LONGREAL;
               mode  :  CgBase.Mode;
       END; 
       SimpleVariable  : RECORD
               base  :  MemAdr;
               index  :  MemAdr;
       END; 
       SymPlusOffset  : RECORD
               offset  :  LONGINT;
       END; 
       RegPlusSymPlusOffset  : RECORD
               offset  :  LONGINT;
       END; 
       OffsetPlusIndexMultFaktor  : RECORD
               offset  :  LONGINT;
               faktor  :  SHORTINT;
       END; 
       mem  : RECORD
               offset  :  LONGINT;
               faktor  :  SHORTINT;
       END; 
       CMem  : RECORD
               mode  :  CgBase.Mode;
       END; 
       RegOrIm  : RECORD
               mode  :  CgBase.Mode;
       END; 
       RegOrCMem  : RECORD
               mode  :  CgBase.Mode;
       END; 
       RegOrCMemOrIm  : RECORD
               mode  :  CgBase.Mode;
       END; 
       CASE : BOOLEAN OF
          FALSE :  stmtcost  : Cost;
                   stmtrule  : Rule;
       |  TRUE  :  
                   cost : CostArray; 
                   rule : ARRAY NonTerminal OF Rule;
       END;
   END;


 VAR InfCosts : CostArray;


     OptEmitIR, OptEmitMatch, OptRegAlloc : BOOLEAN;


     RegNameTable : ARRAY Register OF ARRAY [0..9] OF CHAR;



 PROCEDURE InitIR;

 PROCEDURE Error (errmesg: ARRAY OF CHAR);
 
 PROCEDURE PrintAttributes  (VAR attr : AttributesRecord);

 PROCEDURE PrintExpression  (e : Expression);

 PROCEDURE PrintExprCosts   (e : Expression);
 PROCEDURE PrintInstrCosts  (e : Expression);
 PROCEDURE PrintINTEGER     (i : INTEGER);
 PROCEDURE PrintCARDINAL    (i : CARDINAL);
 PROCEDURE PrintBOOLEAN     (b : BOOLEAN);

PROCEDURE PrintExprAttributes (ga : ExprAttributes);
PROCEDURE PrintRegister       (r  : Register      );
PROCEDURE PrintBegRegister    (r  : Register      );
PROCEDURE PrintRegisterSet    (rs : RegisterSet   );
 END IR.
