/************************************************/
/*                                              */
/*    Visual X windows Programming Interface    */
/*    ======================================    */
/*                                              */
/*      Copyright (C) 1994  by  Yong Chen       */
/*                                              */
/************************************************/

/* application C source code */

/* include part */

/* X11 and Motif includes part */
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <X11/Shell.h>

/* application's include part */







/* global definition part */

/* Defines object's Global Access Array */
typedef struct {
	Widget text;
	Widget BulletinBoard1;
	Widget Label4;
	Widget Label3;
	Widget Label2;
	Widget PushButton1;
	Widget Separator2;
	Widget Separator1;
	Widget Text2;
	Widget Text1;
	Widget Label1;
	Widget Text3;
} _GAArray;
static _GAArray vxpOBJ;

/* application's global definitions */







/*
 *main()
*/
void
main(int argc, char **argv)
{
	/* variable & prototype declaration */
	XtAppContext app_context;
	void vxpInitial();
	Widget text;
	Widget BulletinBoard1;
	Widget Label4;
	Widget Label3;
	Widget Label2;
	Widget PushButton1;
	void PushButton1_activate_cb();
	Widget Separator2;
	Widget Separator1;
	Widget Text2;
	void Text2_valueChanged_cb();
	void Text2_activate_cb();
	Widget Text1;
	void Text1_activate_cb();
	void Text1_valueChanged_cb();
	Widget Label1;
	Widget Text3;
	void Text3_activate_cb();

	/* create topLevel widget, initialize application */
	text = XtVaAppInitialize(&app_context, "Test",
		NULL, 0, &argc, argv, NULL, NULL);
	vxpOBJ.text = text;

	/* widgets creation */

	BulletinBoard1 = XtVaCreateWidget("BulletinBoard1",
		xmBulletinBoardWidgetClass,
		text, NULL);
	XtVaSetValues(BulletinBoard1, XmNx, 0, XmNy, 0,
		XmNwidth, 419, XmNheight, 321,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	vxpOBJ.BulletinBoard1 = BulletinBoard1;

	Label4 = XtVaCreateWidget("Label4",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label4, XmNx, 12, XmNy, 88,
		XmNwidth, 118, XmNheight, 28,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Background", 11,
		NULL );
	XtManageChild(Label4);
	vxpOBJ.Label4 = Label4;

	Label3 = XtVaCreateWidget("Label3",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label3, XmNx, 10, XmNy, 206,
		XmNwidth, 118, XmNheight, 25,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Font", 5,
		NULL );
	XtManageChild(Label3);
	vxpOBJ.Label3 = Label3;

	Label2 = XtVaCreateWidget("Label2",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label2, XmNx, 10, XmNy, 151,
		XmNwidth, 119, XmNheight, 26,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Foreground", 11,
		NULL );
	XtManageChild(Label2);
	vxpOBJ.Label2 = Label2;

	PushButton1 = XtVaCreateWidget("PushButton1",
		xmPushButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(PushButton1, XmNx, 147, XmNy, 277,
		XmNwidth, 89, XmNheight, 29,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNrecomputeSize, XmRString,
		"False", 6,
		XtVaTypedArg, XmNlabelString, XmRString,
		"EXIT", 5,
		NULL );
	XtAddCallback(PushButton1, XmNactivateCallback,
		PushButton1_activate_cb, (XtPointer) NULL);
	XtManageChild(PushButton1);
	vxpOBJ.PushButton1 = PushButton1;

	Separator2 = XtVaCreateWidget("Separator2",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator2, XmNx, 11, XmNy, 244,
		XmNwidth, 383, XmNheight, 20,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtManageChild(Separator2);
	vxpOBJ.Separator2 = Separator2;

	Separator1 = XtVaCreateWidget("Separator1",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator1, XmNx, 17, XmNy, 56,
		XmNwidth, 380, XmNheight, 17,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtManageChild(Separator1);
	vxpOBJ.Separator1 = Separator1;

	Text2 = XtVaCreateWidget("Text2",
		xmTextWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Text2, XmNx, 133, XmNy, 142,
		XmNwidth, 263, XmNheight, 41,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtAddCallback(Text2, XmNvalueChangedCallback,
		Text2_valueChanged_cb, (XtPointer) NULL);
	XtAddCallback(Text2, XmNactivateCallback,
		Text2_activate_cb, (XtPointer) NULL);
	XtManageChild(Text2);
	vxpOBJ.Text2 = Text2;

	Text1 = XtVaCreateWidget("Text1",
		xmTextWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Text1, XmNx, 135, XmNy, 83,
		XmNwidth, 261, XmNheight, 40,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtAddCallback(Text1, XmNactivateCallback,
		Text1_activate_cb, (XtPointer) NULL);
	XtAddCallback(Text1, XmNvalueChangedCallback,
		Text1_valueChanged_cb, (XtPointer) NULL);
	XtManageChild(Text1);
	vxpOBJ.Text1 = Text1;

	Label1 = XtVaCreateWidget("Label1",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label1, XmNx, 90, XmNy, 14,
		XmNwidth, 253, XmNheight, 38,
		XtVaTypedArg, XmNshadowThickness, XmRString,
		"4", 2,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		XtVaTypedArg, XmNrecomputeSize, XmRString,
		"False", 6,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Dynamic Resources Editing", 26,
		NULL );
	XtManageChild(Label1);
	vxpOBJ.Label1 = Label1;

	Text3 = XtVaCreateWidget("Text3",
		xmTextWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Text3, XmNx, 133, XmNy, 199,
		XmNwidth, 261, XmNheight, 42,
		XtVaTypedArg, XmNbackground, XmRString,
		"grey", 5,
		NULL );
	XtAddCallback(Text3, XmNactivateCallback,
		Text3_activate_cb, (XtPointer) NULL);
	XtManageChild(Text3);
	vxpOBJ.Text3 = Text3;

	XtManageChild(BulletinBoard1);

	/* Create windows for widgets and map them. */
	XtRealizeWidget(text);
	vxpInitial();
	/* Loop for events. */
	XtAppMainLoop(app_context);
}


void PushButton1_activate_cb
(Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
	void exit();
	exit(0);
}




void Text2_valueChanged_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}


















void Text2_activate_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
    char *text;

    text = XmTextGetString(w);
    XtVaSetValues(vxpOBJ.Label1, XtVaTypedArg, XmNforeground,
	XmRString, text, strlen(text) + 1, NULL);
}




















void Text1_activate_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
    char *text;

    text = XmTextGetString(w);
    XtVaSetValues(vxpOBJ.Label1, XtVaTypedArg, XmNbackground, 
	XmRString, text, strlen(text) + 1, NULL);
}




















void Text1_valueChanged_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}



















void Text3_activate_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
    char *text;

    text = XmTextGetString(w);
    XtVaSetValues(vxpOBJ.Label1, XtVaTypedArg, XmNfontList,
	XmRString, text, strlen(text) + 1, NULL);
}

















/* application's initial routine */
void vxpInitial()
{

}







/* application's functions */





