/* $Id: defs.h,v 1.5 1992/03/25 17:48:21 jtsillas Exp $ */

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  defs.h
 *
 *    Contain #includes, #defines and typedefs
 */

#include <stdio.h>
#include <sys/param.h>
#include <X11/Xos.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#ifdef SCO
#	include <unistd.h>
#endif

#ifdef SYSV
#ifndef MAX
#	define MAX(a,b)	((a)>(b)?(a):(b))
#	define MIN(a,b)	((a)>(b)?(b):(a))
#endif
#ifndef HAVE_TERMIO
#       define HAVE_TERMIO
#endif
#else				/* SYSV */
#       define sigset signal
#	define getcwd getwd
#endif

/* if you are running HP-UX 9.01, link in -lV3 to have the
 * right signal handlers...
 */

#ifdef Mips
typedef int pid_t;
#ifndef getcwd
#define getcwd(x,s) getwd(x) 
#endif
#endif

#ifdef __GNUC__
#   define alloca __builtin_alloca
#else
#ifdef Mips
#define const
#endif
#endif

#if !defined(MAXPATHLEN)
#define MAXPATHLEN 1024
#endif

#ifndef AssignMax
#define AssignMax(x, y) 	if ((y) > (x)) x = (y)
#endif
#ifndef AssignMin
#define AssignMin(x, y) 	if ((y) < (x)) x = (y)
#endif

#define XmStrMk(x)	XmStringCreateLtoR((x), XmSTRING_DEFAULT_CHARSET)

#define XtSetValue(a,b,c) XtVaSetValues(a,b,c,NULL)
#define XtGetValue(a,b,c) XtVaGetValues(a,b,c,NULL)

#define NHELPLABELS	120	/* Number of labels for use by help_handler */
#define NHELPBUTTONS    100	/* Number of buttons */
#define LINESIZ         512	/* input line length */
#define MAXNAME         256	/* max identifier length */
#define MAXARGS 	20	/* max number of args */
#define MAXSTOPS        256     /* max number of stops */
#define MAXSIGNS        256     /* max number of signs */
#define OFFSET	        0       /* offset for displaying signs */
#define ADD_SIZE 	16	/* # of files added during Realloc */
#define CHARS_PER_LINE  20	/* estimated number of chars per line */
#define ADD_LINES       50	/* # of lines to be added in realloc */
#define NTOKENS		6	/* number of tokens */
#define DEBUGGER      	"gdb"	/* name of executable */
#define MXGDBPROMPT  	"(mxgdb) " /* mxgdb prompt string */
#define GDBPROMPT	"(gdb)" /* The prompt used by gdb */
#define DELIMITERS	" !%^&*()+=~|;:{},/#<?\"\n\t"

#define BREAK_HELP	"Please select a function name or an address, or put cursor on a line to break at"
#define CLEAR_HELP	"Please select a stop sign to clear"
#define PRINT_HELP	"Please select an expression to print"
#define UNDISPLAY_HELP	"Please select a number to undisplay"
#define DISPLAY_HELP    "Please select ax expression to display"
#define SEARCH_HELP	"Nothing to search"

#define	LASTCH(s)	(s[strlen(s)-1]) /* Last character in a string */
#define	SECLASTCH(s)	(s[strlen(s)-2]) /* Second to last character */

#define _SCROLLDOWN (0)	/* These are used as callback arguments */
#define _SCROLLUP (1)	/* for the vertical scroll back and for the */
#define _SCROLLUPPAGE (2) /* left/right page buttons. */
#define _SCROLLDOWNPAGE (3)
#define _SCROLLDRAG (4)
#define _SCROLLRIGHT (5)
#define _SCROLLLEFT (6)
#define _SCROLLDROP (7)
#define _PAGELEFT (8)
#define _PAGERIGHT (9)

#define _STOP_SIGN 1
#define _UPDOWN_SIGN 2
#define _ARROW_SIGN 3
#define _BOMB_SIGN 4
#define _NUM_SIGNS _BOMB_SIGN

#define HELP_LEVELS 8		/* The maximum number of levels in help */
#define HELP_SIZE 64		/* The maximum length of help command */
  
typedef struct {		/* This structure defines the buttons for */
  Widget button;		/* the vertical command buttons next to the */
  char *buttonname;		/* source window. */
  char *labelbits;
  int labelwidth;
  int labelheight;
  Pixel *label_color;
  void (*CB)();
  char *CBarg;
} buttonstruct;

typedef struct {
  Boolean useCommandDialog;	/* Use a dialog box for the command windows */
  Boolean bell;		/* if True, bell on */
  String delimiters;	/* set of delimiters for word selection */
  String prompt;		/* prompt string for mxgdb */
  
  Pixel button_color;
  Pixel stop_color;	/* color of stop sign */
  Pixel arrow_color;	/* color of arrow sign */
  Pixel updown_color;	/* color of updown sign */
  Pixel bomb_color;	/* color of bomb sign */

  Boolean bigicon;		/* mxgdb option -bigicon */
  Boolean debug;		/* mxgdb option -debug */
  
  String includeDir;	/* gdb option -I includeDir */
  String cfile;		/* gdb option -c file */
  String startup;		/* gdb option -s startup */
  String tstartup;		/* gdb option -sr tstartup */
} MxgdbResources;

typedef struct {
  char *filename;	/* name of file */
  char *pathname;	/* full path name of file */
  char *buf;		/* buffer holding source file */
  long filesize;	/* size of file in bytes */
  time_t mtime;		/* time last modified */
  int lines;		/* # of lines on display */
  int currentline;	/* line where caret is */
  int topline;	/* top line number in the window */
  int bottomline;	/* bottom line number in window */
  int lastline;	/* number of lines in source file */
  XmTextPosition *linepos;	/* array of text pos for each newline*/
} FileRec, *FileRecPtr;

typedef struct {
    char	*mesg;			/* part of matched string */
    unsigned	stop;			/* stop number */
    char 	*func;			/* function name */
    int		line;			/* line number */
    char	*file;			/* file name */
    char	*display;		/* variable display output */
} Tokens;

typedef struct {
    char			*pat;		/* regular expression */
    struct re_pattern_buffer	*buf;		/* buffer for compile regex */
    int				reg_token[NTOKENS];	/* register number */
} PatternRec, *PatternRecPtr;

typedef struct commandRec {
    char		*command;
    struct commandRec	*next;
} CommandRec, *CommandRecPtr;

typedef struct {
    Cardinal	i;			/* index to arrowsign[] */
    char	file[MAXNAME];		/* file associated with */
    int	 	line;			/* line number */
    char 	func[MAXNAME];		/* function name associated with */
} Arrow;

typedef struct {
    Cardinal	i;			/* index to updownsign[] */
    char	file[MAXNAME];		/* file associated with */
    int	 	line;			/* line number */
    char 	func[MAXNAME];		/* function name associated with */
} Updown;

typedef struct {
    char	*file;			/* file associated with */
    int	 	line;			/* line number of stop */
    unsigned    tag;                    /* used in deleting stops */
} Stops;

typedef struct {
    Cardinal	i;			/* index to bombsign[] */
    char	file[MAXNAME];		/* file associated with */
    int	 	line;			/* line number */
    char 	func[MAXNAME];		/* function name associated with */
} Bomb;


typedef struct {
    Widget      w;
    Boolean     mapped;
} ArrowSign;

typedef struct {
    Widget      w;
    Boolean     mapped;
} UpdownSign;

typedef struct {
    Widget      w;
    Boolean     mapped;
} StopSign;

typedef struct {
    Widget      w;
    Boolean     mapped;
} BombSign;

/* These are used to clarify the use of bitmaps in certain verbose
 * Motif function calls.
 */

#ifdef __STDC__
#define INFO(x) x ## _bits, x ## _width, x ## _height, 8, x ## _width / 8
#else
#define INFO(x) x/**/_bits, x/**/_width, x/**/_height, 8, x/**/_width / 8
#endif

