static char rcsid[] = "$Id: MB.c,v 1.1.1.1 1992/01/10 18:29:34 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/* MB.c:
 *
 * CreateMenuButton(): Fill a menu with a set of buttons.
 * CreatePullDownMenu(): Fill a pane with a set of menus.
 *
 */

#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include "MB.h"

void CreateMenuButton(parent, Buttons, nbuttons)
     Widget parent;
     MenuButtonStruct Buttons[];
     int nbuttons;
{
  Arg args[5];
  int widgetcount;
  Cardinal nargs;
  MenuButtonStruct *thisbutton;

  for(widgetcount=0; widgetcount<nbuttons; widgetcount++)
    {
      thisbutton = &(Buttons[widgetcount]);
      XtSetArg(args[0], XmNlabelString, XmStrMk(thisbutton->Label));
      nargs = 1;
      if(*(thisbutton->accel) != '\0')
	{
	  XtSetArg(args[1], XmNaccelerator, thisbutton->accel);
	  XtSetArg(args[2], XmNacceleratorText, 
		   XmStrMk(thisbutton->acceltext));
	  nargs = 3;
	}
      Buttons[widgetcount].Button = (Widget)
	XmCreatePushButtonGadget(parent,
				 thisbutton->RN, 
				 args, nargs);
      XtManageChild(thisbutton->Button);
      XtAddCallback(thisbutton->Button, 
		    XmNactivateCallback, 
		    thisbutton->CB, 
		    thisbutton->Argument);
    }
}

void CreatePulldownMenu(parent, MenuPane, Npanes)
     Widget parent;
     PMCBStruct MenuPane[];
     int Npanes;
{
  Arg args[5];
  register int widgetcount;
  PMCBStruct *thispane;

  for(widgetcount=0; widgetcount<Npanes; widgetcount++)
    {
      thispane = &(MenuPane[widgetcount]);
      thispane->PM = (Widget) XmCreatePulldownMenu(parent, thispane->RNPM, 
						   NULL, 0);
      XtSetArg(args[0], XmNlabelString, XmStrMk(thispane->Label));
      XtSetArg(args[1], XmNsubMenuId, thispane->PM);
      XtSetArg(args[2], XmNmnemonic, thispane->mnemonic);
      thispane->CB =  (Widget) XmCreateCascadeButton(parent, thispane->RNCB, 
						     args, 3);
      XtManageChild(thispane->CB);
      CreateMenuButton(thispane->PM, thispane->Buttons, thispane->Nbuttons);
    }
}

