/* test32.c - test CPU32 background mode drivers
 * Copyright (C) 1992 by Scott Howard, all rights reserved
 * Permission is hereby granted to freely copy and use this code or derivations thereof
 * as long as no charge is made to anyone for its use
 */

char *TargetName = "CPU32";

#include	"textio.h"
#include	"regs-32.h"
#include	"bdmcalls.h"
#include	"newline.h"

void DumpRegisters (void)
{
	int Stopped = StopChip ();
	unsigned SR, Counter;
	LONG Temp;

	printf ("D0-7 ");
	for (Counter = 0; Counter < 8; Counter++)
		printf ("%08lx ", GetReg (REG_D0 + Counter));
	printf ( NEWLINE );

	printf ("A0-7 ");
	for (Counter = 0; Counter < 8; Counter++)
		printf ("%08lx ", GetReg (REG_A0 + Counter));
	printf ( NEWLINE );

	printf ("PC   %08lx      SR  ", GetReg (REG_PC));
	Temp = GetReg (REG_SR);
	SR = 0x8000;
	for (Counter = 0; Counter < 16; Counter++)
	{
		putchar ((Temp & SR) ? '1' : '0');
		SR >>= 1;
	}
	printf ( NEWLINE "SFC  %08lx      DFC %08lx      VBR %08lx" NEWLINE ,
		GetReg (REG_SFC), GetReg (REG_DFC), GetReg (REG_VBR));
	if (Stopped) RunChip (0);
}
