/* bdmcalls.h - define function calls in Background Debug Mode driver package
 * Copyright (C) 1992 by Scott Howard, all rights reserved
 * Permission is hereby granted to freely copy and use this code or derivations thereof
 * as long as no charge is made to anyone for its use
 */

#include	"sizedefs.h"
#include	"trgtstat.h"

int set_fc (void);
int restore_fc (void);
unsigned ValidPorts (void);
void SetFC (unsigned);
int Init (unsigned Port, unsigned Speed);
void DeInit (void);
unsigned GetStatus (void);
unsigned GetStatusMask (void);
int StopChip (void);
void StepChip (void);
void ResetChip (void);
void RestartChip (void);
void RunChip (LONG where);
LONG GetByte (LONG Where);
LONG GetWord (LONG Where);
LONG GetLong (LONG Where);
LONG DumpByte (LONG Where);
LONG DumpWord (LONG Where);
LONG DumpLong (LONG Where);
void PutByte (LONG Where, BYTE Data);
void PutWord (LONG Where, WORD Data);
void PutLong (LONG Where, LONG Data);
void FillByte (LONG Where, BYTE Data);
void FillWord (LONG Where, WORD Data);
void FillLong (LONG Where, LONG Data);
LONG GetReg (unsigned which);
void PutReg (unsigned which, LONG Data);
extern void DriverError (int, int, LONG);

#define	UserData	1
#define	UserCode	2
#define	SupervisorData	5
#define	SupervisorCode	6

/* end of bdmcalls.h */
