
// program to initialize the toy debit/credit database

#include <stdio.h>
#include "data.h"
#include <E/trans.h>

persistent extern branchFile   branches;
persistent extern accountFile  accounts;
persistent extern tellerFile   tellers;
persistent extern dbint        time;

const int numBranches = 5;      // as many as desired
const int numTellers  = 10;     // as many as desired
const int acctsPerBranch = 5;   // should be fewer than 100000

const int branchInit = 10000000;
const int tellerInit = 5000;

main()
{
    account  newAccount;
    teller   newTeller;
    branch   newBranch;
    int      t, b, a, i;

    E_BeginTransaction();
    // initialize teller records
    for (t = 1; t < numTellers; t++) {
        newTeller.tellerNo = t;
        newTeller.balance = tellerInit;
	tellers.append(newTeller.tellerNo, newTeller);
    }

    // initialize branch and account records
    a = 1;
    for (b = 1; b < numBranches; b++) {
	// initialize branch record
        newBranch.branchNo = b;
        newBranch.balance = branchInit;
	branches.append(newBranch.branchNo, newBranch);
	// initialize branch's account records
        for (i = 0; i < acctsPerBranch; i++) {
	    newAccount.branchNo = b;
	    newAccount.accountNo = a + i;
	    newAccount.balance = 0;
	    accounts.append(newAccount.accountNo, newAccount);
        }
	a += acctsPerBranch;
    }
    E_CommitTransaction();

    printf("Initialization complete!\n");

}

