#include <stdio.h>
#include <libc.h>
#include "binaryTree.h"

dbstruct student
{
	dbint	sid;
	dbfloat	gpa;

	student( int , float );
	void	print();
};

student::student( int s, float g ){ sid = s; gpa = g; };
void	student::print(){ printf("\n%d  %1.2f\n", sid, gpa ); };

// dbclass school : collection[ student ];
// persistent school		UWmadison;
persistent collection< student > UWmadison;;

int compare( dbfloat * x, dbfloat * y )
{
	float cmp = (*x - *y);

	if( cmp < 0 )
		return -1;
	else if( cmp == 0 )
		return 0;
	else
		return 1;
}

// dbclass gpaIndexType : binaryTree[ dbfloat, student, compare ];
// persistent gpaIndexType	gpaIndex;
persistent binaryTree< dbfloat, student > gpaIndex;


// NOTE: these iterators should be either declared inline as
// part of the binaryTree & binaryTree template definitions or
// declared as function templates; unfortunately, this doesn't
// quite work.  As a temporary expedient, specific instances of
// the 2 necessary template classes are defined below.

ITER_DEF( student  *,(binaryTree<dbfloat,student>::search( dbfloat searchKey )))
{
	if( root == NULL )
		IRETURN;
	else
		ITERATE( student *,p ,  root->search( searchKey ),
			YIELD (p);)
} END_ITER_DEF;

ITER_DEF( student  *,(binaryTreeNode<dbfloat,student>::search( dbfloat searchKey )))
{
	int cmp = compare( &searchKey, &nodeKey );
	if( cmp <= 0 ){
		if( leftChild != NULL )
			ITERATE( student *,p , leftChild->search( searchKey ),
				YIELD( p));
		if( cmp == 0 )
			YIELD (entPtr);
	} else
		if( rightChild != NULL )
			ITERATE( student *,p2 , rightChild->search( searchKey ),
				YIELD( p2));
} END_ITER_DEF

void getNewStudent( float * gpa, student **  sptr )
{
	int	sid;

	printf("\nEnter new student's id# and gpa: ");
	scanf("%d %f", &sid, gpa);
	(*sptr) = new( UWmadison ) student( sid, *gpa );

	return;
}

enum commands { ERROR, QUIT, NEWSTUDENT, PROCESS };

commands getCommand()
{
	char buffer[10];

	printf("\nCommand(q-quit/n-new student/p-process)? ");
	scanf("%s", buffer);
	switch(buffer[0]){
		case 'q':	return QUIT;
		case 'n':	return NEWSTUDENT;
		case 'p':	return PROCESS;
		default:	return ERROR;
	}

}

void getGpa( float* gpa )
{
	char buffer[10];

	printf("\nEnter gpa: ");
	scanf("%f",gpa);
}

void processStudent( student * sptr )
{
	sptr->print();
}

main( ) {
	student *	s;
	float		gpa;
	int		cmd;

	while( TRUE ) {
	    cmd = getCommand();
	    switch( cmd ) {
		case NEWSTUDENT:
			E_BeginTransaction();
			getNewStudent( &gpa, &s );
			gpaIndex.insert( (dbfloat)gpa, s );
			E_CommitTransaction();
			break;

		case PROCESS:
			E_BeginTransaction();
			getGpa( &gpa );
			ITERATE(  student *, s , gpaIndex.search( (dbfloat)gpa ),
			{
			  if (s)
				processStudent( s );
			})
			E_CommitTransaction();
			break;

		case QUIT:
			exit(1);

	    }
	}
} 


