#ifndef _SM_CLIENT_H_
#define _SM_CLIENT_H_
#include <stdio.h>
#include <setjmp.h>
#include <sys/types.h>
#include <netinet/in.h>
/* BEGIN visible to user */

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	These values are used to define the assert
 *	checking level of the compiled code
 */
#define LEVEL_1		1)
#define LEVEL_2		2)
#define LEVEL_3		3)


#ifdef DEBUG

/*
 *	This value control the level of assert
 *	checking expansion for the current compile
 */
#define ASSERT_LEVEL		(3

#define MAGIC_CHECKING		ENABLED

#define OBJECT_MAGIC		DISABLED

#define LIST_CHECKING		ENABLED

#define PARAM_CHECKING		ENABLED

#define IO_STATISTICS		ENABLED


#else


/*
 *	This value control the level of assert
 *	checking expansion for the current compile
 */
#define ASSERT_LEVEL		(0

#define MAGIC_CHECKING	ENABLED

#define OBJECT_MAGIC		DISABLED

#define LIST_CHECKING		DISABLED

#define PARAM_CHECKING		DISABLED

#define IO_STATISTICS		ENABLED


#endif

/* END visible to user */
/* BEGIN visible to user */

#define SM_ASSERT(_level, _condition)							\
	if (ASSERT_LEVEL >= _level)	{								\
		if (!(_condition))	{									\
			SM_Error(TYPE_FATAL, esmASSERT, __FILE__, __LINE__);\
		}														\
	}

/* END visible to user */
/* BEGIN visible to user */

/*
 *	Turn on function prototypes for these compilers
 */
#if defined(_AIX) || defined(mips) || defined(__cplusplus) || defined(c_plusplus) || defined(__GNUC__)
#	define PROTO(_parms) _parms 
#else
	/*
	 *	Turn it off for everything else
	 */
#	define PROTO(_parms) ()
#endif

#ifdef __cplusplus
#define BEGIN_EXTERNC extern "C" {
#define END_EXTERNC }
#else
#define BEGIN_EXTERNC 
#define END_EXTERNC 
#endif __cplusplus

/*
 * Allow things to compile with c and c++ without having to 
 * ifdef-out each use of "const"
 */
#ifndef __cplusplus
#define const
#endif

/*
 * Some compilers do not know about volatile, including ATT C++.
 * G++ seems to know about it.
 * In order to avoid all sorts of warnings about the use
 * of volatile in places like <sys/smp_lock.h> (for ultrix),
 * and serverlib/include/queues.h.o, we define volatile out of
 * existence for ATT C++.
 */
#if defined(__cplusplus) && !defined(__GNUC__)
#define volatile
#endif


/*
 * Boolean values.
 */
typedef char BOOL;

#ifndef TRUE
#define TRUE	(1)
#endif
#ifndef FALSE
#define FALSE	(0)
#endif

/*
 *	define some values for general macro expansion
 */
#define IS_ENABLED		==1)
#define IS_DISABLED		==0)
#define ENABLED			(1
#define DISABLED		(0

/*
 *	Universal constant for flags field
 */
#define NOFLAGS			((FLAGS) 0)


/*
 * Machine dependent constants.
 */
#define	BYTESPERWORD	(sizeof(int))
#ifndef BITSPERBYTE
#	define	BITSPERBYTE		8
#endif
#define	BITSPERWORD		(BITSPERBYTE * BYTESPERWORD)


/*
 * Special "no error" error return.
 */
#define	esmNOERROR	0		/* non-error "error" code	*/
#define esmFAILURE	-1		/* standard failure call	*/


/*
 * Invalid pointer values.
 */
#ifndef NULL
#define	NULL		(VOID *)0	/* invalid memory address. Don't use this for int types; use ZERO */
#endif

#define	ZERO		0

#define	NIL			-1		/* invalid integer index */


/*
 * Typedefs used all over.
 */
typedef char	ONE;			/* 1 byte */
typedef short	TWO;			/* 2 bytes */
typedef long	FOUR;			/* 4 bytes */


typedef void	(*PFV)();		/* pointer to void function		*/
typedef int		(*PFI)();		/* pointer to integer function		*/
typedef char	*(*PFCP)();		/* pointer to char pointer function */

typedef unsigned char	UONE;	/* 1 byte */
typedef unsigned short	UTWO;	/* 2 bytes */
typedef unsigned long	UFOUR;	/* 4 bytes */

#ifndef _AIX
typedef unsigned long	ulong;
#endif

typedef unsigned int	FLAGS;
typedef unsigned long	MAGIC;
typedef unsigned short	SHORT_MAGIC;

/*
 * These typedefs go here because they are used all over the place.
 * They are variants of flags but are given different types to
 * help avoid conflicts.
 */
typedef	FLAGS	BFFLAGS;
typedef	FLAGS	SCANFLAGS;
typedef	FLAGS	SCANTYPE;
typedef	FLAGS	NEIGHBORFLAGS;


/*
 * Version history graph node id.
 */
typedef FOUR VHGNODEID;

/*
 *  define a type for a slotted page slot
 */
typedef TWO     SLOTINDEX;

/*
 * Macro for checking errors.
 */
#define	CHECKERROR(a) 							\
	    if ((int)(a) < smNOERROR) return ((int)(a))

/* END visible to user */
/* BEGIN visible to user */

/*
 *	Set object alignment to 8 byte bountries.
 *
 *	The only valid values are 8 and 4.  Adding new values
 *	requires a change to include/object.h.
 */
#define ALIGNON 8
#define ALIGNON1 (ALIGNON-1)

/*
 *	the object size align macro
 *
 *	This macro aligns object sizes to ALIGNON boundries.
 *	Note that zero length objects are also rounded up.
 */
#define ALIGNSIZE(_size)								\
	( ((_size) == 0) ? ALIGNON :( (_size) + ALIGNON1 ) & ~ALIGNON1)


/* END visible to user */
/* BEGIN visible to user */

/*
 *	definitions for communication between the client and the server process
 */
#define ERROR_REPLY	 		0 	/* reply from server to client,
								 * when server cannot even tell what
								 * kind of message the client tried to
								 * send.
								 */
#define MOUNT_VOLUME	 	1
#define DISMOUNT_VOLUME	 	2
#define FORMAT_VOLUME	 	3
#define READ_PAGE		 	4
#define WRITE_PAGE		 	5
#define ALLOC_PAGE		 	6
#define DEALLOC_PAGE	 	7
#define CHECK_PAGE		 	8
#define GET_UNIQUE		 	9
#define STAT_VOLUME			10		
#define SET_ROOT_ENTRY		11
#define GET_ROOT_ENTRY		12
#define REMOVE_ROOT_ENTRY	13
#define BEGIN_TRANS			14
#define COMMIT_TRANS		15
#define ABORT_TRANS			16
#define LOCK_PAGE			17
#define LOCK_FILE			18
#define CREATE_FILE			19
#define DELETE_FILE			20	
#define FIRST_PHYSICAL_PAGE	21	
#define LAST_PHYSICAL_PAGE	22	
#define NEIGHBOR_PAGE		23	
#define FIRST_LOGICAL_PAGE	24	
#define LAST_LOGICAL_PAGE	25	
#define MARK_FILE_PAGE		26	
#define RESET_RUSAGE		27	
#define GET_RUSAGE			28	
#define CREATE_SEQ_FILE		29
#define OPEN_SEQ_LOAD		30
#define OPEN_SEQ_SCAN		31
#define SCAN_NEXT_SEQ		32
#define LOAD_NEXT_SEQ		33
#define CLOSE_RESOURCE		34
#define TEST_NULL_RPC		35
#define TEST_PAGE_RPC		36

#define WRITE_LOG_PAGE	 	37
#define INIT_CLIENT			38
#define UNLOCK_PAGE			39
#define UNLOCK_FILE			40
#define QUERY_PAGE			41
#define SET_ANCHOR			42
#define SET_CLR				43
#define MON_DUMP			44

/*
 * administrative messages	
 */
#define ADMIN_CHECKPOINT	45
#define ADMIN_CHECKPOINTFREQ	46
#define ADMIN_SHUTSERVER	47
#define ADMIN_STATISTICS	48
#define ADMIN_DEBUG			49
	/* divided into these: */
#define 	ADMIN_DEBUG_CLIENT_LOG_OFF	500
#define 	ADMIN_DEBUG_SET_VAR			501

#define TEST_PAGE_SEND		50
#define SYNC_TRANS			51
#define FILE_NUMPAGES		52

/* 
 *	distributed commit messages
 */
#define ENTER2PC			53
#define COORD_PREPARE_TRANS	54
#define COORD_VOTE_REQ		55
#define SERVER_VOTE			56
#define CLIENT_COMMAND		57 /* ?? do we need this or use COMMIT/ABORT */
#define	CONTINUE_2PC		58
#define RECOVER_2PC			59

#define COORD_COMMAND		60
#define SERVER_ACK			61

#define ADD_VOLUME			62
#define RM_VOLUME			63

#define MAX_MSG_NUMBER		63	

#define SENT		0x1
#define RECEIVED	0x2

typedef struct {
	char  *name;
	short  type;
} MESSAGENAME;
extern MESSAGENAME	MsgNames[];

typedef struct msg_stats {
	int	sent [ MAX_MSG_NUMBER+1 ];
	int	received [ MAX_MSG_NUMBER+1 ];
	int	replied_ok [ MAX_MSG_NUMBER+1 ];
	int	replied_in_error [ MAX_MSG_NUMBER+1 ];
	int	no_reply_requested [ MAX_MSG_NUMBER+1 ];
	int	bytes_sent; 
	int	bytes_received;
	int	pages_sent; /* anything larger than MIN_PAGESIZE */
	int pages_received; /* anything larger than MIN_PAGESIZE */
	int	partial_pages_sent; /* anything smaller than MIN_PAGESIZE */
	int partial_pages_received; /* anything smaller than MIN_PAGESIZE */
} MESSAGESTATS;

extern MESSAGESTATS MsgStats;

/* END visible to user */
/* BEGIN visible to user */
/*
 *	Typedef for volume id
 */
typedef TWO		VOLID;

/*
 *  macro for finding the index into the buffer list
 *  for the given size buffer
 *  (Really a bf macro but it's used on both cli & srvr)
 */
#define OFFSET(_page2size)      (_page2size - MIN_PAGE2SIZE)

/*
 *  define a force mark for the WAL protocol
 */
typedef FOUR	    			FORCEMARK;

/*
 * Short form of PID (no volume id)
 */
typedef FOUR	SHORTPID;


/*
 * Definition for page identifier (PID).
 * Ifdefs allow an application to be compiled with C or C++.
 */
#if defined(__cplusplus) || defined(c_plusplus)

class PID {
public:

#else 

struct PID {

#endif 

    SHORTPID 	page;		/* page address */
    VOLID 		volid;		/* volume id */

#if defined(__cplusplus) || defined(c_plusplus)

	inline BOOL equalFunc(PID *other) const {
		return ((other->page == this->page) &&
			(other->volid == this->volid));
	};
	inline int hashFunc() const { return (int)(this->page); };

#if defined(SHELL_C)
    operator char*();	 /* used by tcl shell only */
    void fill(char* s);
#endif 

#endif 

}; /* } class PID */

/*
 *	define the type of the unique field
 */
typedef UFOUR	UNIQUE;


/* 
 * Temporary typedef for file id.
 */
typedef struct {

    PID			pid;		/* the root page of the file	*/
	UNIQUE		unique;		/* unique bit for file			*/

} FID;

/* END visible to user */
/* BEGIN visible to user */

/*
 *	define the log record counter
 */
typedef struct	{

	UFOUR	wrapCount;
	UFOUR	count;

} LRC;

/* END visible to user */
/* BEGIN visible to user */

/*
 *	definitions for the buffer queues
 */
#define MIN_PAGE2SIZE		13 /*8K*/
#define MIN_PAGESIZE		(1 << MIN_PAGE2SIZE)
#define MAX_PAGE2SIZE		16
#define MAX_PAGESIZE		(1 << MAX_PAGE2SIZE)
#define MAX_BLOCK2_COUNT	(MAX_PAGE2SIZE - MIN_PAGE2SIZE)
#define MAX_BLOCK_COUNT		(MAX_PAGESIZE/MIN_PAGESIZE)

#define BITMAP_PAGE2SIZE	(MIN_PAGE2SIZE)
#define BITMAP_PAGESIZE		(1 << BITMAP_PAGE2SIZE)
#define BITMAP_USABLESIZE	(BITMAP_PAGESIZE - sizeof(LRC))

#define HEADER_PAGE2SIZE	(MIN_PAGE2SIZE)
#define HEADER_PAGESIZE		(MIN_PAGESIZE)

/* END visible to user */
/* BEGIN visible to user */
#define			VOL_PROPERTIES	0x5 /* all the flags that have any meaning below  */
#define			VOLPROP_TEMP	0x1 /* cannot be temp and log */
#define			VOLPROP_UNUSED	0x2 /* RAWDEV is not a permanent property */
#define			VOLPROP_LOG		0x4 /* is a log (if not a log, its a data volume) */
/* END visible to user */
/* BEGIN visible to user */
/*
 *	define  the maximum that the root name can be
 */
#define MAX_ROOTNAME_SIZE	32
#define MAX_ROOTDATA_SIZE	32
/* END visible to user */
/* BEGIN visible to user */

/*
 *	object.h
 *
 *		defines, typedefs, etc. used by object-level routines and
 *		clients of the storage manager.
 */

/*
 *	define the size of slotted pages
 */
#define SLOTTED_PAGE2SIZE	MIN_PAGE2SIZE
#define SLOTTED_PAGESIZE	(1 << SLOTTED_PAGE2SIZE)


/*
 *	define the sizes of large object pages
 */
#define LG_PAGE2SIZE	MIN_PAGE2SIZE
#define LG_PAGESIZE		(1 << LG_PAGE2SIZE)
#if	(MIN_PAGE2SIZE == 12)
#	define LGDATA_PAGE2SIZE	(MIN_PAGE2SIZE+1) /* double lg obj pages */
#else
#	define LGDATA_PAGE2SIZE	(MIN_PAGE2SIZE)   /* large obj pages == others */
#endif
#define LGDATA_PAGESIZE	(1 << LGDATA_PAGE2SIZE)
/*#define LGDATA_USABLESIZE is defined below */


/*
 *	define the sizes of btree pages
 */
#define BTREE_PAGE2SIZE		MIN_PAGE2SIZE
#define BTREE_PAGESIZE		(1 << BTREE_PAGE2SIZE)
#define INDEXDESC_PAGE2SIZE	MIN_PAGE2SIZE
#define INDEXDESC_PAGESIZE	(1 << INDEXDESC_PAGE2SIZE)

/*
 *	define the number of uniques allocated when page is created
 *	(100 per every 4K of pagesize)
 */
#if SLOTTED_PAGE2SIZE < 12
#define UNIQUE_ALLOC_COUNT	(100)
#else
#define UNIQUE_ALLOC_COUNT	(100+100*(SLOTTED_PAGE2SIZE-12))
#endif

    
/*
 *	Typedef for object addresses.
 */
typedef struct {

    SHORTPID	page;			/* the page address of the object's header	*/
    SLOTINDEX	slot;			/* slot number of the object				*/
	VOLID		volid;			/* the id of the volume						*/
	UNIQUE		unique;			/* unique number of the object				*/

} OBJADDR;


/*
 * Typedef for object ids.
 */
typedef struct {

    OBJADDR  diskAddr;			/* the object's disk address	*/

} OID;


/* END visible to user */
/* BEGIN visible to user */

/*
 *	Defines for near in CreateObject call.
 */
#define NEAR_OBJ  			1
#define NEAR_FIRST			2
#define NEAR_LAST			3
#define NEAR_DISTINGUISHED	4	/* not used */
/* for backward compatibility */
#define NEAR_FIRST_PHYSICAL	NEAR_FIRST
#define NEAR_LAST_PHYSICAL	NEAR_LAST	
#define NEAR_FIRST_LOGICAL	NEAR_FIRST
#define NEAR_LAST_LOGICAL	NEAR_LAST


/*
 *	Typedef for generic object headers as viewed by clients of the storage manager.
 *	Note that the fields must match the initial fields of SMALLOBJHDR 
 *	and LARGEOBJHDR (all the same for now).
 */
typedef struct {

    TWO			properties;		/* the properties bit vector	*/
    TWO			tag;			/* the object's tag				*/
    FOUR		size;			/* the object's data size		*/

	/* MUST MAINTAIN 8-byte ALIGNMENT HERE: if you change this 
	 * the size of the OBJHDR, you might have to add a filler
	 * to maintain 8-byte alignment e.g.
		FOUR		filler;		
	 */

#if OBJECT_MAGIC IS_ENABLED
	MAGIC		magic;
#if (ALIGNON == 8)
	FOUR		filler;		
	/* no alignment needed */
#elif (ALIGNON == 4)
	/* no alignment needed */
#else
	not implemented
#endif
#endif OBJECT_MAGIC IS_ENABLED


} OBJHDR;


#define OBJECT_HDR_MAGIC		0x8AC429DA


/* END visible to user */
/* BEGIN visible to user */
/*
 *	Properties bits; only a few for now.
 */
#define P_LARGEOBJ		0x1		/* whether this is a large object		*/
#define P_HEADERONPAGE	0x2		/* large object header is on the page	*/
#define P_PAGESIZEOBJ	0x4		/* whether this is a page size object	*/
#define P_MOVED			0x8		/* object has been moved to a new page	*/
#define P_FORWARD		0x10	/* this is the forwarded record			*/
#define P_VERSIONED		0x20	/* object is versioned			  	 */
#define P_FROZEN		0x40	/* object is frozen version			 */
#define P_HISTORYGRAPH	0x80	/* object is a version history graph */
#define P_DESTROYPENDING	0x100	/* object is marked to be destroyed
									   pending freezing of all working i
									   verions */
#define P_INDEX			0x200	/* object is an index	 		  	 */
#define P_CREATEINPROGRESS	0x400	/* object is process of being created.
										used for logging lg obj creates. */

/*
 *	define a type for a slot that includes a unique number
 */
typedef struct {

	FOUR	offset;
	UNIQUE	unique;

} PAGESLOT;


/*
 *	Define a header for the slotted page
 */
typedef struct {

    SLOTINDEX  	slotCount;			/* slots in use on the page				*/
	SLOTINDEX	freeSlot;			/* list of free slots					*/
	LRC			lrc;				/* lrc for logging						*/
    FOUR     	freeStart;			/* offset of contig free area on page	*/
    FOUR     	freeBytes;			/* free bytes in the page				*/
    PID     	pid;				/* the page's pid						*/
    FID     	fid;				/* the file the page belongs to			*/
    PID     	neighborPid;		/* the neighboring page Pid				*/
	SHORTPID	nextLogicalPid;		/* used for logical sequence sets		*/
    FOUR    	largeCount;			/* marked if the page has large obj		*/
	UNIQUE		unique;				/* current unique value					*/
	FOUR		uniqueCount;		/* limit of unique values				*/
	MAGIC		magic;

} SLOTTEDHEADER;


/*
 *	Amount of contiguous free space initially on page.
 */
#define INITIALLYFREE	(SLOTTED_PAGESIZE - sizeof(SLOTTEDHEADER))

/*
 *	the definition of a page
 */
typedef struct {

    char			data[INITIALLYFREE - sizeof(PAGESLOT)];	/* the data region	*/
    PAGESLOT		slot[1];			/* slot array, indexes backwards		*/
	SLOTTEDHEADER	header;				/* header of the slotted page			*/

} SLOTTEDPAGE;


#define SLOT_PAGE_MAGIC			0xb1a5dccb


/* 
 *	Maximum number of slots on a page.
 */
#define MAXPAGESLOTS	((SLOTTED_PAGESIZE - sizeof(SLOTTEDHEADER)) / sizeof(PAGESLOT))


/*
 *	Define for the threshold at which a new object starts life as
 *	a large object rather than a small object.  This must be defined
 *	to include the size of the small object header.
 */
#ifdef LGTESTING
#	define LARGETHRESHOLD	LGMAXLEAF
#else
#	define LARGETHRESHOLD	\
		(SLOTTED_PAGESIZE - (sizeof(SLOTTEDHEADER) + sizeof(PAGESLOT) + sizeof(OBJHDR)))
#endif


/*
 *	define the largest large object that will fit in a tree with
 *	the root on a slotted page
 */
#define LSLOTTHRESHOLD		(LGMAXPAGESLOTS * LGMAXLEAF)


/*
 *	define some state variables for checking for free space
 */
#define PAGE_NO_SPACE		0x0
#define PAGE_LAST_SLOT		0x1
#define PAGE_INT_SLOT		0x2


/*
 *	define the hash function for hashing an oid
 */
#define BF_HashOid(_oid)								\
	((_oid)->diskAddr.unique & ObjectHashMask)



#define INIT_LARGENODE_MAGIC(_nodePtr)					\
														\
	(_nodePtr)->header.magic = LARGENODE_MAGIC;			
	
#define INIT_LGDATAHDR_MAGIC(_nodePtr)					\
														\
	(_nodePtr)->header.magic = LGDATAHDR_MAGIC;			
	
#define INIT_SLOTROOT_MAGIC(_nodePtr)					\
														\
	(_nodePtr)->header.magic = SLOTROOT_MAGIC;			

	
/*
 *	define a check for a large node magic number
 */
#define CHECK_LARGENODE_MAGIC(_nodePtr)					\
														\
	if ((_nodePtr)->header.magic != LARGENODE_MAGIC)	{	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);				\
	}
	

/*
 *	define a check for a large data magic number
 */
#define CHECK_LGDATAHDR_MAGIC(_nodePtr)					\
														\
	if ((_nodePtr)->header.magic != LGDATAHDR_MAGIC)	{	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);				\
	}
	

/*
 *	define a check for a large node magic number
 */
#define CHECK_SLOTROOT_MAGIC(_nodePtr)					\
														\
	if ((_nodePtr)->header.magic != SLOTROOT_MAGIC)	{	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);				\
	}


/*
 *	define index descriptor stuff
 */

#define SM_MAXELEMLEN   20      /* range 4--124 (multiples of 4) */

typedef enum { SM_BTREENDX, SM_HASHNDX } SMTYPE;

typedef enum { SM_EQ = 1, SM_G = 2, SM_L = 4,
				SM_GEQ = 3, SM_LEQ = 5 } SMCOND;

#define SM_BOF	NULL, SM_GEQ
#define SM_EOF	NULL, SM_LEQ

typedef enum { SM_char, SM_int, SM_long, SM_short, SM_float, 
				SM_double, SM_string } SMDATATYPE;
#define SM_Boolean SM_char

/* END visible to user */
/* BEGIN visible to user */

typedef struct {
		PID 	pid;
		} IID;					/* INDEX IDENTIFIER */

#ifdef __cplusplus
#ifdef PIDEQ
inline operator ==(const IID& i1, const IID& i2) {
		return PIDEQ(i1.pid, i2.pid);
		}
inline operator !=(const IID& i1, const IID& i2) {
		return ! (i1 == i2);
		}
#endif PIDEQ
#endif __cplusplus

#define PFCDEFINED
#ifdef __cplusplus
typedef int 	(*PFC) PROTO((int kLen1, const void* kVal1, 
									int kLen2, const void* kVal2));
#else
typedef int 	(*PFC) PROTO((int kLen1, void* kVal1, int kLen2, void* kVal2));
#endif

typedef void    (*PFK) PROTO((int kLen, char* kVal));


/* END visible to user */
/* BEGIN visible to user */

/*
 *	define the transaction id
 */
typedef long	TID;

/*
 *	define the null tid
 */
#define NULL_TID	(0)


/*
 * define the maximum length of opaque char string in GTID 
 */
#define MAXOPAQUELEN 255

/*
 *	define the global transaction id
 */
typedef struct {
	
	int 		length;
	char 		opaque[MAXOPAQUELEN];

} GTID;

/* END visible to user */
/* BEGIN visible to user */
#define MAX_HOSTNAME    100
#define MAX_SERVERNAME  100
/* END visible to user */
/* BEGIN visible to user */
/*
 *  define the coordinator handle
 */
typedef struct {
 	TID         coordTid;
	char        hostName[MAX_HOSTNAME];  /* a.b.c.d of the server's host 
							from inet_ntoa(host's inaddr) */
	char        serverName[MAX_SERVERNAME];	
						/* string representation of port # */

} COORD_HANDLE;
/* END visible to user */
/* BEGIN visible to user */
/*
 * vote returned by ESM Servers
 */
typedef	UONE VOTE;
/* END visible to user */
/* BEGIN visible to user */
/*
 * definitions for the votes from a server to the coordinator
 */
#define		VOTEUNKNOWN	0
#define		YESVOTE		1
#define		NOVOTE		2
#define		READVOTE	3
/* END visible to user */
/* BEGIN visible to user */
#define VERSION_NUMBER "3.0"
#define  SM_VERSION_3_0
/* END visible to user */
/* BEGIN visible to user */

/*
 *	Shutdown message flags for SHUTDOWNBODY defined in msgdefs.h
 */
#define SHUT_TAKE_CHECKPOINT	0x1
#define SHUT_DUMP_CORE			0x2
#define SHUT_ABORT_TRANS		0x4
#define SHUT_COMMIT_TRANS		0x8
#define SHUT_CLEAN_VOLUMES		0x10
#define SHUT_ABNORMAL_EXIT		0x20

/*
 *	statistics message flags for STATISTICSBODY defined in msgdefs.h
 */
#define STAT_CLEAR				0x1

/*
 *	Statistics structure returned to clients
 */
typedef struct _ServerStats {
	int		numClients;		/* number of clients connected		*/
	int		numTrans;		/* number of active transactions	*/
	int		numVolumes;		/* number of volumes mounted		*/
	int	    freeLogSpace;   /* approximate number of bytes of free log space */
	int	    chpntFreq;     	/* current checkpoint frequency */
	int	    totalCommits; 	/* counter for number of transactions committed */
	int	    totalAborts;	/* counter for number of transactions aborted */
	int		diskReads;		/* counter for disk read operations	*/
	int		diskWrites; 	/* counter for disk write operations*/

	int		numActiveCoordinator;	/* number of active trans for
								 	   which this server is the coord */
	int		numPreparedParticipant;	/* number of prepared trans for 
									   which the server is a 
									   participant */

	MESSAGESTATS msgStats;  /* server's message stats */

	struct sockaddr_in	 serverAddr;/* inet addr to which server listens */

} SERVERSTATS;

/* END visible to user */
/* BEGIN visible to user */

/*
 *  Definition of flags for buffer groups
 */
#define G_FREE      0x0
#define G_OPEN      0x1
#define G_TRANS     0x2

/* added for client operation logging - MJF */
#define LOG_GROUP   0x4
#define FORCE_GROUP 0x8

/* END visible to user */
/* BEGIN visible to user */
/* 
 * Buffer replacement policies for buffer groups.
 */
#define BF_DEFAULT      0
#define BF_LRU          1
#define BF_MRU          2
/* END visible to user */
/* BEGIN visible to user */
typedef struct UserDesc {

    char        *basePtr;       /* ptr user will use to access data     */
    int	        byteCount;      /* bytes accessible to user             */
    int	        objectSize;     /* size of object                       */
    TWO         userFlags;      /* properties field of the obj header   */
    TWO         type;   
    TWO         flags;          /* if this descriptor is valid          */
    TWO         tag;            /* tag field from obj hdr               */
    OID         oid;            /* oid of object being referenced       */
/* END visible to user */
/* BEGIN visible to user */
} USERDESC;
/* END visible to user */
/* BEGIN visible to user */
/* Flags passed as argument to administrative funcs, such
 * as sm_GetRusage(), to indicate which servers to address
 */
#define VOL_ALL					0
#define VOL_USED_SINCE_INIT		1
#define VOL_USED_IN_TRANSACTION 2
#define VOL_BY_VOLID 			3

/* END visible to user */
/* BEGIN visible to user */

typedef struct struct_scan_desc SCANDESC;

/* END visible to user */
/* BEGIN visible to user */

/*
 *	types of allowed scans
 */
#define LOGICAL_SCAN	0x1
#define PHYSICAL_SCAN	0x2

/* END visible to user */
/* BEGIN visible to user */

typedef struct struct_load_desc LOADDESC;

/* END visible to user */
/* BEGIN visible to user */

/*
 *	types of allowed loads
 */
#define LOGICAL_LOAD	0x1
#define PHYSICAL_LOAD	0x2

/* END visible to user */
/* BEGIN visible to user */

/*
 *	define flags for file creation parameters
 */
#define LOGICAL_ORDER	0x1

/* END visible to user */
/* BEGIN visible to user */

/*
 *	Define types of storage manager errors
 */
#define TYPE_USER		0
#define TYPE_LOG		1
#define TYPE_WARNING	2
#define TYPE_SYS		3
#define TYPE_FATAL		4 /* kill server and dump core */
#define TYPE_CRASH		5
	/* 
	 *	TYPE_CRASH is used for errors which the storage manager 
	 * 	should be able to "handle" but are not dealt with at
	 * 	this time
	 */
#define TYPE_STOP		6 
#define TYPE_QUIET		7 /* like TYPE_STOP but no message given */
	

/*
 *	Macro to encode error code as a base number in the upper 16 bits
 *	and an error number in the lower 16 bits
 */
#define	SM_ERR_ENCODE(_base, _number)					\
	( ((_base) << 16) + (_number) )


/*
 *	Macro to decode the error number
 */
#define	SM_ERR_DECODE(_code)					\
	(  (_code) & (0x0000FFFF ) )

/*
 *	Macro to decode the base number for the error
 */
#define	SM_ERR_BASE_DECODE(_code)					\
	(  (_code) >> 16 )


#define UNIX_ERROR_BASE			0
#define GENERAL_ERROR_BASE		1
#define SM_ERROR_BASE			2
#define BF_ERROR_BASE			3
#define LG_ERROR_BASE			4
#define EH_ERROR_BASE			5
#define FI_ERROR_BASE			6
#define IO_ERROR_BASE			7
#define MSG_ERROR_BASE			8
#define THREAD_ERROR_BASE		9
#define BM_ERROR_BASE			10
#define TRANS_ERROR_BASE		11
#define LOCK_ERROR_BASE			12
#define LOG_ERROR_BASE			13
#define RESOURCE_ERROR_BASE		14
#define RECOVER_ERROR_BASE		15
#define IM_ERROR_BASE			16
#define OPT_ERROR_BASE			17
#define DISTR_ERROR_BASE        18
#define MAX_ERROR_BASE			19 	/* always last */

/*
 *	The unix errors are defined in /usr/include/errno.h
 */
#define MAX_UNIX_ERROR			0x0fffffff /* unknown */

/*
 *	define the general errors
 */
#define esmINTERNAL				SM_ERR_ENCODE(GENERAL_ERROR_BASE, 1)
#define esmASSERT				SM_ERR_ENCODE(GENERAL_ERROR_BASE, 2)
#define esmMALLOCFAILED			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 3)
#define esmSERVERDIED			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 4)
#define esmNOTIMPLEMENTED		SM_ERR_ENCODE(GENERAL_ERROR_BASE, 5)
#define esmUNIXSIGNAL			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 6)
#define esmPOOLEMPTY			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 7)
#define MAX_GENERAL_ERROR		8 /* adjust as errors added/removed */

/*
 *	define the sm layer errors
 */
#define esmBADOID				SM_ERR_ENCODE(SM_ERROR_BASE, 1)
#define esmBADSTART				SM_ERR_ENCODE(SM_ERROR_BASE, 2)
#define esmNOFREEUSERDESC		SM_ERR_ENCODE(SM_ERROR_BASE, 3)
#define esmBADUSERDESC			SM_ERR_ENCODE(SM_ERROR_BASE, 4)
#define esmBADPARAMS			SM_ERR_ENCODE(SM_ERROR_BASE, 5)
#define esmBADGROUP				SM_ERR_ENCODE(SM_ERROR_BASE, 6)
#define esmBADLENGTH			SM_ERR_ENCODE(SM_ERROR_BASE, 7)
#define esmROOTNAMETOOLONG		SM_ERR_ENCODE(SM_ERROR_BASE, 8)
#define esmNOFREESCANDESC		SM_ERR_ENCODE(SM_ERROR_BASE, 9)
#define esmENDOFOBJECT			SM_ERR_ENCODE(SM_ERROR_BASE, 10)
#define esmBADSLOTTEDMAGIC		SM_ERR_ENCODE(SM_ERROR_BASE, 11)
#define esmBADOBJECTMAGIC		SM_ERR_ENCODE(SM_ERROR_BASE, 12)
#define esmBADOBJECTFLAGS		SM_ERR_ENCODE(SM_ERROR_BASE, 13)
#define esmNOFREELOADDESC		SM_ERR_ENCODE(SM_ERROR_BASE, 14)
#define esmHISTORYGRAPHOID		SM_ERR_ENCODE(SM_ERROR_BASE, 15)
#define esmNOTVERSIONED			SM_ERR_ENCODE(SM_ERROR_BASE, 16) /* obj not a version */
#define esmNOTFROZEN			SM_ERR_ENCODE(SM_ERROR_BASE, 17) /* obj not frozen */
#define esmFROZEN				SM_ERR_ENCODE(SM_ERROR_BASE, 18) /* obj is frozen */
#define esmVHGTOOLARGE			SM_ERR_ENCODE(SM_ERROR_BASE, 19) 
#define MAX_SM_ERROR			20 /* adjust as errors added/removed */


/*
 *	define the bf related error
 */
#define esmCANTSWAP				SM_ERR_ENCODE(BF_ERROR_BASE, 1)
#define esmFIXEDPAGES			SM_ERR_ENCODE(BF_ERROR_BASE, 2)
#define esmNOFREEPAGEHASH		SM_ERR_ENCODE(BF_ERROR_BASE, 3)
#define esmNOUNRESERVED			SM_ERR_ENCODE(BF_ERROR_BASE, 4)
#define esmNOFREEGROUPS			SM_ERR_ENCODE(BF_ERROR_BASE, 5)
#define esmBADREPLACEPOLICY		SM_ERR_ENCODE(BF_ERROR_BASE, 6)
#define esmPAGEGONE				SM_ERR_ENCODE(BF_ERROR_BASE, 7)
#define esmNOBUFSPACE			SM_ERR_ENCODE(BF_ERROR_BASE, 8)
#define esmREQUESTTOOBIG		SM_ERR_ENCODE(BF_ERROR_BASE, 9)
#define esmGROUPGONE			SM_ERR_ENCODE(BF_ERROR_BASE, 10)
#define esmNOSHMSPACE			SM_ERR_ENCODE(BF_ERROR_BASE, 11)
#define MAX_BF_ERROR			12 /* adjust as errors added/removed */


/*
 *	define the large object related errors
 */
#define esmBADRANGE				SM_ERR_ENCODE(LG_ERROR_BASE, 1)
#define esmNOFREELGNODELIST		SM_ERR_ENCODE(LG_ERROR_BASE, 2)
#define MAX_LG_ERROR			3 /* adjust as errors added/removed */

/*
 *	define the error handler related errors
 */
#define MAX_EH_ERROR            0 /* adjust as errors added/removed */

/*
 *	define the file layer errors
 */
#define esmEMPTYFILE			SM_ERR_ENCODE(FI_ERROR_BASE, 1)
#define esmBADNEARTYPE			SM_ERR_ENCODE(FI_ERROR_BASE, 2)
#define esmBADFILEPAGEMAGIC		SM_ERR_ENCODE(FI_ERROR_BASE, 3)
#define esmAFTERLASTPID			SM_ERR_ENCODE(FI_ERROR_BASE, 4)
#define esmBEFOREFIRSTPID		SM_ERR_ENCODE(FI_ERROR_BASE, 5)
#define esmFILESTACKOVERFLOW	SM_ERR_ENCODE(FI_ERROR_BASE, 6)
#define esmFILEPAGENOTFOUND		SM_ERR_ENCODE(FI_ERROR_BASE, 7)
#define esmNOFREEFILESTACK		SM_ERR_ENCODE(FI_ERROR_BASE, 8)
#define esmPAGEEXISTS			SM_ERR_ENCODE(FI_ERROR_BASE, 9)
#define esmPAGEMARKED			SM_ERR_ENCODE(FI_ERROR_BASE, 10)
#define esmBADFID				SM_ERR_ENCODE(FI_ERROR_BASE, 11)
#define esmNOFREEFIDHASH		SM_ERR_ENCODE(FI_ERROR_BASE, 12)
#define esmFILENOTLOGICAL		SM_ERR_ENCODE(FI_ERROR_BASE, 13)
#define esmBADPAGESIZE			SM_ERR_ENCODE(FI_ERROR_BASE, 14)
#define esmBADFILEHEADERMAGIC	SM_ERR_ENCODE(FI_ERROR_BASE, 15)
#define esmNOFREEOPENFILE		SM_ERR_ENCODE(FI_ERROR_BASE, 16)
#define MAX_FILE_ERROR			17 /* adjust as errors added/removed */


/*
 *	define the io related errors
 */
#define esmBADVOLHEADER			SM_ERR_ENCODE(IO_ERROR_BASE, 1)
#define esmDUPVOLID				SM_ERR_ENCODE(IO_ERROR_BASE, 2)
#define esmDISKPROCDIED			SM_ERR_ENCODE(IO_ERROR_BASE, 3)
#define esmBADVOLID				SM_ERR_ENCODE(IO_ERROR_BASE, 4)
#define esmDUPVOLNAME			SM_ERR_ENCODE(IO_ERROR_BASE, 5)
#define esmFRAGMENTED			SM_ERR_ENCODE(IO_ERROR_BASE, 6)
#define esmDISKFULL				SM_ERR_ENCODE(IO_ERROR_BASE, 7)
#define esmDISKMOUNTED			SM_ERR_ENCODE(IO_ERROR_BASE, 8)
#define esmBADROOTNAME			SM_ERR_ENCODE(IO_ERROR_BASE, 9)
#define esmROOTTABLEFULL		SM_ERR_ENCODE(IO_ERROR_BASE, 10)
#define esmNOVOLINFO			SM_ERR_ENCODE(IO_ERROR_BASE, 11)
#define esmNOFREECONTEXT		SM_ERR_ENCODE(IO_ERROR_BASE, 12)
#define esmBADPID				SM_ERR_ENCODE(IO_ERROR_BASE, 13)
#define esmSERVPROCDIED			SM_ERR_ENCODE(IO_ERROR_BASE, 14)
#define esmNOSUCHVOLUME			SM_ERR_ENCODE(IO_ERROR_BASE, 15)
#define esmMOUNTTABLEFULL		SM_ERR_ENCODE(IO_ERROR_BASE, 16)

#define MAX_IO_ERROR			17 /* adjust as errors added/removed */


/*
 *	define the message related errors
 */
#define esmPROTOCOLVERSION		SM_ERR_ENCODE(MSG_ERROR_BASE, 1)
#define esmBADMESSAGENUMBER		SM_ERR_ENCODE(MSG_ERROR_BASE, 2)
#define esmBADMESSAGEMAGIC		SM_ERR_ENCODE(MSG_ERROR_BASE, 3)
#define esmALREADYCONNECTED		SM_ERR_ENCODE(MSG_ERROR_BASE, 4)
#define esmNOTCONNECTED			SM_ERR_ENCODE(MSG_ERROR_BASE, 5)
#define esmNOFREETIMERS			SM_ERR_ENCODE(MSG_ERROR_BASE, 6)
#define esmUNKNOWNHOSTNAME      SM_ERR_ENCODE(MSG_ERROR_BASE, 7)
#define esmCONFIGMISMATCH		SM_ERR_ENCODE(MSG_ERROR_BASE, 8)
#define esmBADFAMILY			SM_ERR_ENCODE(MSG_ERROR_BASE, 9)
#define MAX_MSG_ERROR          10 /* adjust as errors added/removed */


/*
 *	define the thread related errors
 */
#define esmNOFREETHREAD			SM_ERR_ENCODE(THREAD_ERROR_BASE, 1)
#define MAX_THREAD_ERROR		2 /* adjust as errors added/removed */


/*
 *	define the bitmap related error
 */
#define esmNOFREEPAGECONTEXT	SM_ERR_ENCODE(BM_ERROR_BASE, 1)
#define esmTOOMANYBITS			SM_ERR_ENCODE(BM_ERROR_BASE, 2)
#define MAX_BM_ERROR			3 /* adjust as errors added/removed */


/*
 *	define the transaction related errors
 */
#define esmNOFREETRANSREC		SM_ERR_ENCODE(TRANS_ERROR_BASE, 1)
#define esmTRANSDISABLED		SM_ERR_ENCODE(TRANS_ERROR_BASE, 2)
#define esmBADTRANSID			SM_ERR_ENCODE(TRANS_ERROR_BASE, 3)
#define esmNOTTRANSMASTER		SM_ERR_ENCODE(TRANS_ERROR_BASE, 4)
#define esmTRANSABORTED			SM_ERR_ENCODE(TRANS_ERROR_BASE, 5)
#define esmTRANSCOMMITTED		SM_ERR_ENCODE(TRANS_ERROR_BASE, 6)
#define esmNOFREETRANSVOLREC	SM_ERR_ENCODE(TRANS_ERROR_BASE, 7)
#define esmTRANSINPROGRESS		SM_ERR_ENCODE(TRANS_ERROR_BASE, 8)
#define esmNOACTIVETRANS		SM_ERR_ENCODE(TRANS_ERROR_BASE, 9)
#define esmCLIENTREQUEST		SM_ERR_ENCODE(TRANS_ERROR_BASE, 10)
#define MAX_TRANS_ERROR			11 /* adjust as errors added/removed */


/*
 *	define the locking related errors
 */
#define esmBADLOCKTABLESIZE		SM_ERR_ENCODE(LOCK_ERROR_BASE, 1)
#define esmBADLOCKMODE			SM_ERR_ENCODE(LOCK_ERROR_BASE, 2)
#define esmNOFREELOCKHEADER		SM_ERR_ENCODE(LOCK_ERROR_BASE, 3)
#define esmNOFREELOCKENTRY		SM_ERR_ENCODE(LOCK_ERROR_BASE, 4)
#define esmNOFREELOCKCLASSREC	SM_ERR_ENCODE(LOCK_ERROR_BASE, 5)
#define esmNOFREELOCKCLASS		SM_ERR_ENCODE(LOCK_ERROR_BASE, 6)
#define esmBADLOCKCLASS			SM_ERR_ENCODE(LOCK_ERROR_BASE, 7)
#define esmLOCKBUSY				SM_ERR_ENCODE(LOCK_ERROR_BASE, 8)
#define esmLOCKCAUSEDDEADLOCK	SM_ERR_ENCODE(LOCK_ERROR_BASE, 9)
#define esmNOSUCHLOCK			SM_ERR_ENCODE(LOCK_ERROR_BASE, 10)
#define esmWAITEREXISTS			SM_ERR_ENCODE(LOCK_ERROR_BASE, 11)
#define esmPHANTOMDEADLOCK		SM_ERR_ENCODE(LOCK_ERROR_BASE, 12)
#define esmCAUSEDPHANTOMDEADLOCK SM_ERR_ENCODE(LOCK_ERROR_BASE, 13)
#define esmLOCKPREEMPTED 		SM_ERR_ENCODE(LOCK_ERROR_BASE, 14)
#define MAX_LOCK_ERROR			15 /* adjust as errors added/removed */


/*
 *	define the logging related errors
 */
#define esmLOGDISABLED			SM_ERR_ENCODE(LOG_ERROR_BASE, 1)
#define esmLOGWRAPPED			SM_ERR_ENCODE(LOG_ERROR_BASE, 2)
#define esmNOFREELOGSPACE		SM_ERR_ENCODE(LOG_ERROR_BASE, 3)
#define esmLOGRECORDTOOBIG		SM_ERR_ENCODE(LOG_ERROR_BASE, 4)
#define esmBADLOGPAGEHEADER		SM_ERR_ENCODE(LOG_ERROR_BASE, 5)
#define esmBADLOGRECORDHEADER	SM_ERR_ENCODE(LOG_ERROR_BASE, 6)
#define esmBADLOGVOLUME			SM_ERR_ENCODE(LOG_ERROR_BASE, 7)
#define esmMOUNTLSNTOOHIGH		SM_ERR_ENCODE(LOG_ERROR_BASE, 8)
#define esmLOGTOOSMALL			SM_ERR_ENCODE(LOG_ERROR_BASE, 9)
#define esmLOGGINGOFF			SM_ERR_ENCODE(LOG_ERROR_BASE, 10)
#define MAX_LOG_ERROR			11 /* adjust as errors added/removed */


/*
 *	define the resource related errors
 */
#define esmBADRESOURCE			SM_ERR_ENCODE(RESOURCE_ERROR_BASE, 1)
#define MAX_RESOURCE_ERROR		2 /* adjust as errors added/removed */


/*
 *	define the recovery related errors
 */
#define	esmCANNOTRECOVER		SM_ERR_ENCODE(RECOVER_ERROR_BASE, 1)
#define MAX_RECOVER_ERROR		2 /* adjust as errors added/removed */


/*
 *	define the Index Manager related errors
 */
#define esmKEYNOTFOUND			SM_ERR_ENCODE(IM_ERROR_BASE, 1)
#define esmKEYALREADYEXISTS		SM_ERR_ENCODE(IM_ERROR_BASE, 2)
#define esmDUPLICATEKEYPID		SM_ERR_ENCODE(IM_ERROR_BASE, 3)
#define esmKEYTOOLONG			SM_ERR_ENCODE(IM_ERROR_BASE, 4)
#define esmMAXKEYLENEXCEEDED	SM_ERR_ENCODE(IM_ERROR_BASE, 5)
#define esmOIDNOTFOUND			SM_ERR_ENCODE(IM_ERROR_BASE, 6)
#define esmOIDEXISTS			SM_ERR_ENCODE(IM_ERROR_BASE, 7)
#define esmINVALIDDIRECTION		SM_ERR_ENCODE(IM_ERROR_BASE, 8)
#define esmSCANEXHAUST			SM_ERR_ENCODE(IM_ERROR_BASE, 9)
#define esmINVALIDCURSOR		SM_ERR_ENCODE(IM_ERROR_BASE, 10)
#define esmINVALIDCOND			SM_ERR_ENCODE(IM_ERROR_BASE, 11)
#define esmCONFLICTCOND			SM_ERR_ENCODE(IM_ERROR_BASE, 12)
#define esmBULKLOADING          SM_ERR_ENCODE(IM_ERROR_BASE, 13)
#define esmINDEXNOTEMPTY        SM_ERR_ENCODE(IM_ERROR_BASE, 14)
#define esmNEEDTEMPVOL			SM_ERR_ENCODE(IM_ERROR_BASE, 15)
#define esmWRONGNDXTYPE			SM_ERR_ENCODE(IM_ERROR_BASE, 16)
#define esmWRONGHASHLOAD		SM_ERR_ENCODE(IM_ERROR_BASE, 17)
#define MAX_IM_ERROR			18 /* adjust as errors added/removed */

/*
 *	define the option processing related errors
 */
#define esmBADOPTION			SM_ERR_ENCODE(OPT_ERROR_BASE, 1)
#define esmOPTIONSYNTAX			SM_ERR_ENCODE(OPT_ERROR_BASE, 2)
#define esmOPTIONNOTUNIQUE		SM_ERR_ENCODE(OPT_ERROR_BASE, 3)
#define esmOPTIONNOTSET			SM_ERR_ENCODE(OPT_ERROR_BASE, 4)
#define esmBADOPTIONCLASS		SM_ERR_ENCODE(OPT_ERROR_BASE, 5)
#define esmBADOPTIONVALUE		SM_ERR_ENCODE(OPT_ERROR_BASE, 6)
#define esmBUFPAGESNOTSET		SM_ERR_ENCODE(OPT_ERROR_BASE, 7)
#define MAX_OPT_ERROR			8 /* adjust as errors added/removed */

/*
 *	define the distributed transaction related errors
 */
#define esmTRANSNOTPREPARED		SM_ERR_ENCODE(DISTR_ERROR_BASE, 1)
#define esmBADCOMMAND			SM_ERR_ENCODE(DISTR_ERROR_BASE, 2)
#define esmNOFREEGTIDREC		SM_ERR_ENCODE(DISTR_ERROR_BASE, 3)
#define esmTOOMANYSERVERS		SM_ERR_ENCODE(DISTR_ERROR_BASE, 4)
#define esmNOFREESERVERTIDINFO	SM_ERR_ENCODE(DISTR_ERROR_BASE, 5)
#define esmBADHANDLE			SM_ERR_ENCODE(DISTR_ERROR_BASE, 6)
#define esmWOULDBLOCK			SM_ERR_ENCODE(DISTR_ERROR_BASE, 7)
#define esmBADVOTE				SM_ERR_ENCODE(DISTR_ERROR_BASE, 8)
#define esmBADSTATE				SM_ERR_ENCODE(DISTR_ERROR_BASE, 9)
#define esmCOORDUNKNOWN			SM_ERR_ENCODE(DISTR_ERROR_BASE, 10)
#define esmTRANSPREPARED		SM_ERR_ENCODE(DISTR_ERROR_BASE, 11)
#define esmTRANSIN2PC			SM_ERR_ENCODE(DISTR_ERROR_BASE, 12)
#define esmTRANSNOTIN2PC		SM_ERR_ENCODE(DISTR_ERROR_BASE, 13)
#define MAX_DISTR_ERROR			14 /* adjust as errors added/removed */

/*
 *	Define error for handling macros
 */
#define SM_ERROR(type, code)					\
	SM_Error((type), (code), __FILE__, __LINE__)
/* END visible to user */
/* BEGIN visible to user */
#define SM_TRANSABORTED(type, reason)	\
	sm_reason = reason;\
	SM_Error((type), esmTRANSABORTED, __FILE__, __LINE__)
/* END visible to user */
/* BEGIN visible to user */
/*
 *	define flags for opening a buffer group
 */
#define TRANS_GROUP		0x1
/* END visible to user */
/* BEGIN visible to user */

/*
 *	the typedef for a lock mode.  The size of this
 *	definition defines the number of lock modes that
 *	can be allocated
 */
typedef UONE	LOCKMODE;


/*
 *	define the specific information that relates to our type of lock modes
 */
#define NUM_LOCK_MODES		6

/* END visible to user */
/* BEGIN visible to user */

/*
 *	define the lock modes
 */
#define NL	0
#define IS	1
#define IX	2
#define SH	3
#define SIX	4
#define EX	5

/* END visible to user */
/* BEGIN visible to user */

/*
 *	Definition of tracing areas
 */
#define TR_DEBUG		0x1
#define TR_BF			0x2
#define TR_LIST			0x4
#define TR_FI			0x8

#define TR_SM			0x10
#define TR_LG			0x20
#define TR_EH			0x40
#define TR_IO			0x80

#define TR_TEST			0x100
#define TR_THREAD		0x200
#define TR_LATCH		0x400
#define TR_SEM			0x800

#define TR_INIT			0x1000
#define TR_DISK			0x2000
#define TR_MSG			0x4000
#define TR_DISKRW		0x8000

#define TR_ADMIN		0x10000
#define TR_CL			0x20000
#define TR_BITMAP		0x40000
#define TR_TRANS		0x80000

#define TR_LOCK			0x100000
#define TR_LOG			0x200000
#define TR_RECOVER		0x400000
#define TR_ACCESS		0x800000

#define TR_SEQ			0x1000000
#define TR_VERSION		0x2000000
#define TR_VHGLIST		0x4000000 /* version history graph list funcs */
#define TR_SHM			0x8000000 /* shared memory functions		 */

#define TR_DISTR		0x10000000	/* for distr trans */
#define TR_MR			0x20000000	/* media recovery */


/*
 *	definition of trace flags
 */
typedef unsigned long TRACEFLAGS;


/*
 *	define a trace array for levels
 */
typedef struct	{

	unsigned char	level[32];

} TRACELEVEL;


/*
 *	put in the extern declaration
 */
extern TRACEFLAGS	TraceFlags;
extern char			*TraceName;
extern TRACELEVEL	TraceLevel;


/*
 *	define the tracing levels
 */
#define TR_LEVEL_0		(0)
#define TR_LEVEL_1		(1)
#define TR_LEVEL_2		(2)
#define TR_LEVEL_3		(3)


/*
 *	define function prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern int	checkTraceLevel PROTO((TRACEFLAGS, int));

#ifdef __cplusplus
}
#endif

/* END visible to user */
/* BEGIN visible to user */

/*
 *	Macros for tracing
 *
 *	Depend on the global variable Trace for information
 */

#ifdef DEBUG

#define TRACING		ENABLED

#else

#define TRACING		DISABLED

#endif


#if TRACING IS_ENABLED


#define TRACE(_Area, _Level) (													\
																				\
	(((_Area) & TraceFlags) && (checkTraceLevel((_Area), _Level))) ? (			\
		printf("%s file: %-22s  line: %4d\n", TraceName, __FILE__, __LINE__),	\
		fflush(stdout)															\
	) : (TraceFlags)															\
)


#define TRPRINT(_Area, _Level, _Message) (										\
																				\
	(((_Area) & TraceFlags) && (checkTraceLevel((_Area), _Level))) ? (			\
		printf("%s file: %-22s  line: %4d  ", TraceName, __FILE__, __LINE__),	\
		printf _Message,														\
		printf("\n"),															\
		fflush(stdout)															\
	) : (TraceFlags)															\
)


#else


#define TRACE(_Area, _Level)

#define TRPRINT(_Area, _Message, _Level)


#endif

/* END visible to user */
/* BEGIN visible to user */
extern int			sm_errno;
extern int			sm_reason;	/* reason a transaction was aborted */
extern FILE			*sm_ErrorStream;

/*
 *	Default locking modes for files and pages.  
 *	Users can set these as desired.
 */
extern LOCKMODE		sm_DefaultPageLock;
extern LOCKMODE		sm_DefaultFileLock;

/* END visible to user */
/* BEGIN visible to user */

#define SM_MAXKEYLEN			1024	/* max length of index key */

#define SM_MAXOPTCLASS			10		/* max # of option classification levels */

/* END visible to user */
/* BEGIN visible to user */

/*
 * Logging level flags
 */
#define	LOG_NONE	0x0
#define	LOG_SPACE	0x1
#define	LOG_DATA	0x2
#define LOG_ALL		(LOG_DATA | LOG_SPACE)

/* END visible to user */
/* BEGIN visible to user */

/* use as a parameter on object reads to specify entire object */
#define READ_ALL -1

/* use as a parameter on object delete to specify rest of object */
#define DELETE_ALL -1


/*
 *	Macros to set invalid (null) object, index, file, transaction,
 *	cursor, and buffer group ID's
 */
#define INVALIDATE_OID(_oid)    ((_oid).diskAddr.volid = 0)
#define OID_IS_INVALID(_oid)    ((_oid).diskAddr.volid == 0)
#define INVALIDATE_IID(_iid)    ((_iid).pid.volid = 0)
#define IID_IS_INVALID(_iid)    ((_iid).pid.volid == 0)
#define INVALIDATE_FID(_fid)	((_fid).pid.volid = 0)
#define FID_IS_INVALID(_fid)    ((_fid).pid.volid == 0)
#define INVALIDATE_TID(_tid)	((_tid) = 0)
#define TID_IS_INVALID(_tid)    ((_tid) < 1)
#define INVALIDATE_BUFGROUP(_buf)	((_buf) = -1)
#define BUFGROUP_IS_INVALID(_buf)	((_buf) < 0)
#define INVALIDATE_CURSOR(_cur)	(INVALIDATE_BUFGROUP((_cur).groupIndex))
#define CURSOR_IS_INVALID(_cur) (BUFGROUP_IS_INVALID((_cur).groupIndex))
#define INVALIDATE_VOLID(_volid)  (_volid = 0)
#define VOLID_IS_INVALID(_volid)  (_volid == 0)


/*
 *	Globals required for transaction macros	
 */
extern jmp_buf	sm_TransJmpBuf;
extern int		*sm_TransReturnCode;					


#define SM_BEGIN_TRANSACTION(_tid, _retCodeVariable)				\
	do{														\
		sm_TransReturnCode = &(_retCodeVariable);			\
		*sm_TransReturnCode = esmNOERROR;					\
		if (sm_BeginTransaction((_tid))  != esmNOERROR) {   \
			*sm_TransReturnCode = sm_errno;					\
			break;											\
		}													\
		if (setjmp(sm_TransJmpBuf) != 0) {					\
			sm_AbortTransaction(*(_tid));		\
			break;											\
		}	

#define SM_COMMIT_TRANSACTION(_tid)							\
	} while (0);											\
	if (*sm_TransReturnCode == esmNOERROR) {				\
		if (sm_CommitTransaction((_tid)) != esmNOERROR) {	\
			*sm_TransReturnCode = sm_errno;					\
			sm_AbortTransaction((_tid));		\
		} else {											\
			*sm_TransReturnCode = esmNOERROR;				\
		}													\
	}

#define SM_ABORT_TRANSACTION(_retCode)						\
	{														\
		*sm_TransReturnCode = (_retCode);					\
		longjmp(sm_TransJmpBuf, 0);							\
	}

/*
 *	Example use of these functions
 *
		#include <setjmp.h>

		SM_USE_TRANSACTION_MACROS

		main()
		{
			int abort;
			TID	tid;

			printf("outside\n");

			SM_BEGIN_TRANSACTION(&tid, abort)

				f();
				printf("inside\n");
			
			SM_COMMIT_TRANSACTION()
			if (abort) {
				printf("aborted\n");
			} else {
				printf("commited\n");
			}
		}

		f()
		{
			int a;

			printf("abort? ");
			scanf("%d", &a);
			if (a) {
				SM_ABORT_TRANSACTION(1)
			}
		}

	 *
	 *	End of example
	 */

/* END visible to user */
/* BEGIN visible to user */

typedef struct {
    BOOL valid;
    PID  rootPID;
    PID  page;
    TWO  slotNum;
    TWO  index;
} BT_CURSOR;


typedef struct {
    IID     ndx;                /* index id */
    char    b2[SM_MAXKEYLEN];   /* bound2 (must be aligned) */
    int     b2len;              /* length of bound2 */
    int     groupIndex;
    SMCOND  cond2;
    BOOL    eof;		/* TRUE if end of file reached */
    union {
	BT_CURSOR   btCursor;
    } opaque;
} SMCURSOR;


typedef struct {
    TWO     length;         /* length of the key */
    void*   valuePtr;       /* pointer to value of the key */
} KEY;

/* END visible to user */
/* BEGIN visible to user */

struct _ServerStats;

BEGIN_EXTERNC

extern int		sm_Enter2PC PROTO((TID, GTID, COORD_HANDLE * ));
extern int		sm_PrepareTransaction PROTO((TID, VOTE * ));
extern int		sm_Recover2PC PROTO((COORD_HANDLE, GTID, TID *, BOOL ));
extern int		sm_Continue2PC PROTO((TID, BOOL ));
extern int		sm_AbortTransaction PROTO((TID ));
extern int		sm_AppendToObject PROTO((int, OID *, int, void * ));
extern int		sm_BeginTransaction PROTO((TID * ));
extern int		sm_CloseBufferGroup PROTO((int ));
extern int		sm_BufferGroupInfo PROTO((int, int *, int *, int * ));
extern int		sm_CloseLoad PROTO((LOADDESC * ));
extern int		sm_CloseScan PROTO((SCANDESC * ));
extern int		sm_CommitTransaction PROTO((TID ));
extern int		sm_CreateFile PROTO((int, VOLID, FID *));
extern int		sm_DestroyFile PROTO((int, FID * ));
extern int      sm_SetLogLevel PROTO((int, int, FID[]));
extern int		sm_CreateObject PROTO((int, FID *, int, OID *, OBJHDR *, int, void *, OID * ));
extern int		sm_DeleteFromObject PROTO((int, OID *, int, int ));
extern int		sm_DestroyObject PROTO((int, OID * ));
extern char		*sm_Error PROTO((int ));
extern int		sm_GetFirstOid PROTO((int, FID *, OID *, OBJHDR *, BOOL * ));
extern int		sm_GetLastOid PROTO((int, FID *, OID *, OBJHDR *, BOOL * ));
extern int		sm_GetNextOid PROTO((int, OID *, OID *, OBJHDR *, BOOL * ));
extern int		sm_GetPreviousOid PROTO((int, OID *, OID *, OBJHDR *, BOOL * ));
extern int		sm_GetRootEntry PROTO((VOLID, char *, void *, int * ));
extern int		sm_Initialize PROTO((void));
extern int		sm_InsertInObject PROTO((int, OID *, int, int, void * ));
extern int		sm_LoadNextObject PROTO((LOADDESC *, int, void *, OID * ));
extern int		sm_OpenBufferGroup PROTO((int, int, int *, FLAGS ));
extern int		sm_OpenLoad PROTO((FID *, int, int, float, LOADDESC ** ));
extern int		sm_OpenScan PROTO((FID *, int, int, SCANDESC **, OID * ));
extern int		sm_OpenScanWithGroup PROTO((FID *, int, int, SCANDESC **, OID * ));
extern int		sm_ReadObject PROTO((int, OID *, int, int, USERDESC **));
extern int		sm_ReadObjectHeader PROTO((int, OID *, OBJHDR * ));
extern int		sm_ReleaseObject PROTO((USERDESC * ));
extern int		sm_ScanNextBytes PROTO((SCANDESC *, int ));
extern int		sm_ScanNextObject PROTO((SCANDESC *, int, int, USERDESC **, BOOL * ));
extern int		sm_SetObjectHeader PROTO((int, OID *, OBJHDR * ));
extern int		sm_SetRootEntry PROTO((VOLID, char *, void *, int ));
extern int		sm_RemoveRootEntry PROTO((VOLID, char *));
extern int		sm_ShutDown PROTO((void ));
extern int		sm_WriteObject PROTO((int, int, int, void *, USERDESC *, BOOL ));

extern int		sm_LockObject PROTO((int, OID *, LOCKMODE));
extern int		sm_OidToFid PROTO((int, OID *, FID *));
extern int		sm_FreezeVersion PROTO((int, OID * ));
extern int		sm_CreateVersion PROTO((int, int, OID *, OID*, OID* ));
extern char		*sm_ErrorId PROTO((int ));

/*
 *	Administrative functions
 */
extern int		sm_TakeCheckpoint PROTO((FLAGS, VOLID, TWO ));
extern int		sm_ChangeCheckpointFrequency PROTO((FLAGS, VOLID, int ));
extern int		sm_ShutdownServer PROTO((FLAGS, VOLID, FLAGS ));
extern int		sm_ServerStatistics PROTO((FLAGS, VOLID, int *, struct _ServerStats **, BOOL ));
extern int 		sm_PrintMessageStats PROTO((FILE *const, MESSAGESTATS *const));
extern int 		sm_PageCount PROTO((FID*, int*));
extern int 		sm_VolumeProperties PROTO((VOLID, int *));
extern int 		sm_AddServerVolume PROTO((FLAGS, VOLID, char *, char *));
extern int 		sm_RemoveServerVolume PROTO((FLAGS, VOLID, VOLID)); 

extern int sm_CreateIndex PROTO((VOLID volume, int groupIndex, SMTYPE ndxType,
                    SMDATATYPE dataType, int maxKeyLen, 
					int elSize, BOOL unique, IID* ndx));
extern int sm_DestroyIndex PROTO((IID* ndx, int groupIndex));
extern int sm_InsertEntry PROTO((IID* ndx, int groupIndex, KEY* key, void* elem));
extern int sm_RemoveEntry PROTO((IID* ndx, int groupIndex, KEY* key, void* elem));
extern int sm_FetchInit PROTO((IID* ndx, int groupIndex, KEY* bound1, SMCOND cond1,
                          KEY* bound2, SMCOND cond2, SMCURSOR* cursor));
extern int sm_FetchNext PROTO((SMCURSOR* cursor, KEY* retKey, 
						  void* retElem, BOOL* eof));
extern int 	sm_SetLHashLoadThreshold PROTO((IID*, int, float));

extern int sm_BeginIndexLoad PROTO((IID* ndx, int groupIndex, int workVolume, int runSize));
extern int sm_EndIndexLoad PROTO((IID* ndx));
extern int sm_AbortIndexLoad PROTO((IID* ndx));


/*
 *	Option processing functions
 */

extern int		sm_SetClientOption PROTO((const char*, const void*, SMDATATYPE));
extern int		sm_GetClientOption PROTO((char*, void*));
extern int		sm_ReadConfigFile PROTO((char*, char*, char**));
extern int		sm_ParseCommandLine PROTO((int *, char**, char**));

extern int		sm_MountVolume PROTO((VOLID)); 
extern int		sm_DismountVolume PROTO((VOLID )); 	/* needed */

END_EXTERNC

/* END visible to user */
#endif
