#ifndef _TypedHash_h
#define _TypedHash_h
#include <E/HashIndex.h>
// btree index with typed pointer fields
template <class keyt,dbclass eltt> dbclass TypedHashIndex 
	: public HashIndex<keyt>
{
public:
	TypedHashIndex(BOOL uniqf=0): HashIndex<keyt> ( uniqf) {};
	insert(keyt key,eltt * eltpt) 
	{ return HashIndex<keyt>::insert(key,eltpt);};
	remove(keyt key,eltt * eltpt) 
	{ return HashIndex<keyt>::remove(key,eltpt);};
	// all other ops inherited
};
// typed case of HashRetrieve iteratore
template <class keyt,dbclass eltt> class TypedHashRetrieve
	: public HashRetrieve<keyt>
{
	// single point retrieve
public:
	eltt * cur_pt; // override the index_retrieve_base cur_elem
	TypedHashRetrieve( TypedHashIndex<keyt,eltt>& this_index,keyt test)
		: HashRetrieve<keyt> (this_index, test) {};
	TypedHashRetrieve(TypedHashIndex<keyt,eltt> &this_index)   // no key; set later.
		: HashRetrieve<keyt> (this_index){};
	TypedHashRetrieve(TypedHashIndex<keyt,eltt>& this_index,keyt lb, keyt up, int exl=0)
		: HashRetrieve<keyt> (this_index, lb,  up,  exl){};
	// for the next operation, we need to copy the void pointer
	// into a typed locaton
	// other operations are inherited.
	void
	next() 
	{ 	index_retrieve_base::next(); 
		cur_pt = (eltt *)index_retrieve_base::cur_elem; 	
	}
};
#endif
