/****************************************************************************/
/* v_access.h  version 0.5                                                  */
/*                                                                          */
/* routines to access the video-blaster and compatible cards                */
/* for the GNU djgpp/gcc compiler                                           */
/*                                                                          */
/* (C)1994 Bernhard Schwall                                                 */
/*   based on routines from Chips & Technologies                            */
/*   published in TOOL 02/92                                                */
/*                                                                          */
/****************************************************************************/

#ifndef V_ACCESS_H
#define V_ACCESS_H

/* use the audio mixer from the Media Pro Plus */
/* #define MEDIA_PRO_PLUS_MIXER */

/* use the audio mixer of the SB16 */
#define SB16_MIXER

/* define if memoryaccess is allowed */
#define MemAccess

typedef unsigned char   BYTE;
typedef	unsigned short  WORD;
typedef signed short    INT;
typedef signed short    BOOL;
typedef unsigned long   DWORD;

#define TRUE	1
#define FALSE	0

#ifdef __cplusplus
extern "C" {
#endif

extern WORD PortNr;
extern BYTE *VidMem;

WORD V_wr_i2c(WORD Nr, WORD Index, WORD Wert);
void V_SetVolume(WORD Wert);
WORD V_GetVolume();
void V_EnableVideo();
void V_DisableVideo();
void V_SetColorKey(WORD Wert);
WORD V_GetColorKey();
void V_EnableFieldReplication();
void V_DisableFieldReplication();
void V_FreezeVideo();
void V_UnfreezeVideo();
BOOL V_Freeze();
void V_SetWriteProtectMask(WORD Wert);
WORD V_GetWriteProtectMask();
void V_SetVideoSource(WORD Wert);
WORD V_GetVideoSource();
void V_SetInputFormat(WORD Wert);
WORD V_GetInputFormat();
void V_SetColor(WORD x, WORD Wert);
void V_SetVideoAddress(WORD Wert);
void V_SetCaptureAddress(WORD x, WORD y);
WORD V_Initialize(char *name, INT clear);
void V_Exit();
void V_HorizontalZoom(WORD Wert);
void V_VerticalZoom(WORD Wert);
void V_CreateWindow(INT x, INT y, WORD b, WORD h);
void V_SetWindowPosition(INT x, INT y);
void V_SetWindowSize(WORD b, WORD h);
void V_SetSkewFactor(WORD x, WORD Wert);
WORD V_GetSkewFactor(WORD x);
void V_SetRegister(WORD Nr, WORD Wert);
WORD V_GetRegister(WORD Nr);
void V_EnableInterlace();
void V_DisableInterlace();

/*--------------------------------------------------------------------------*/

static inline void port_out(int value, int port)
{
  __asm__ volatile ("outb %0,%1"
  : : "a"  ((unsigned char)value), "d" ((unsigned short)port));
}

static inline void port_outw(unsigned short value, int port)
{
  __asm__ volatile ("outw %0,%1"
  : : "a"  ((unsigned short)value), "d" ((unsigned short)port));
}

static inline int port_in(int port)
{
  unsigned char value;
  __asm__ volatile ("inb %1,%0"
          : "=a" (value)
          : "d" ((unsigned short)port));
  return value;
}
#ifdef __cplusplus
}
#endif

#endif /* V_ACCESS_H */
