typedef float NXCoord;

typedef struct _NXPoint
{
	NXCoord x;
	NXCoord y;
} NXPoint;

typedef struct _NXSize
{
	NXCoord width;
	NXCoord height;
} NXSize;

typedef struct _NXRect
{
	NXPoint origin;
	NXSize	size;
} NXRect;


#define YES				1
#define	NO				0

#define GAIN			1
#define WFRAME			2
#define VFRAME			3
#define INPUT			4
#define FIELDS			5
#define SM				6
#define CLIPPING		7
#define PLL				8
#define XOFF			9
#define YOFF			10	
#define LUMA			13
#define CHROMA			14
#define MOVE			15
#define SIZE			16
#define ONOFF			17
#define QUIT			18
#define	OPEN			19 /**/
#define	ZOOM			20
#define SYSTEM			21
#define REMOVECLIP		22
#define START			23
#define STOP			24
#define MIXER			25
#define INFO			26
#define SETCLIP			27
#define SATURATION		28
#define BRIGHTNESS		29
#define	CONTRAST		30
#define GRABSIZE		31
#define SHARPNESS		32
#define	PREFILTER		33
#define	SLEEP			34
#define	PATTERN			35
#define	CLEARCLIPS		36
#define	PAN				37
#define	RUN				38
#define	READIMAGE		39
#define	CLOSE			40
#define WRITEIMAGE		41
#define AUDIO			42
#define VOLUME			43
#define FADER			44
#define BALANCE			45
#define BASS			46
#define TREBLE			47
#define AUDIO_INPUT		48
#define SETCLIPLIST		49
#define LOG				50
#define ASK				51
#define HELP			52
#define SAY				53
#define HUE				54

#define NUMTOKENS 		54
#define	COMMAND		1
#define FARG		2	
#define IARG 		4
#define NARG		8
#define	PERCENT		16
#define RELATIVE	32

typedef struct _Token
{
	unsigned char	type;
	struct
	{
		char	t;
		float	f;
		int		i;
		char	s[64];
	} val;
} Token;

typedef unsigned char BOOL;


void action(int numtokens, Token *tokens);
void tokenize(char *tmp, Token *tokens, int *numtks);

BOOL getframe(Token* tokens,int numtokens,NXRect *paRect);
BOOL getsize(Token* tokens,int numtokens,NXSize *paSize);
BOOL getpos(Token* tokens,int numtokens,NXPoint *paPoint);
BOOL getonoff(Token* tokens,int numtokens,BOOL *pOnOff);
BOOL getfval(Token* tokens,int numtokens,float *pfVal);
void printInfo(FILE *fp);
unsigned int findcommand(char *s);
void print_error(FILE *fp,int error);
