// view.c : functions for display an image under X-window
//  a part of PMS-grabber package
// the "GNU Public Lincense" policy applies to all programs of this package
// (c) Wolfgang Koehler, wolf@first.gmd.de, Dec. 1994
//     Kiefernring 15
//     14478 Potsdam, Germany
//     0331-863238

#include "window.h"
#include <X11/Xutil.h>
#include "ximage.h"
#include "evaluation.h"
#include "view.h"

view_window *grab_wi;
unsigned short *cap_buf = NULL;
XImage *ximage = NULL;
int biWidth, biHeight;

#include <sys/times.h>
// computes the time since last call to this function
int comp_time() {
  struct tms tt; 
  unsigned tx = times(&tt);  // returns time since boot in 1/100 sec ticks
  static unsigned tl = 0;
  int delt = tx - tl; 
  tl = tx;
  return delt;
}

int tcap = 0, tdraw = 0; // delta-t between two grabs: capture & draw

// uses coltab555 to directly map a rgb555-buffer into a XImage
void map_buf555(unsigned short *buf, int n) {
  unsigned char *imb = ximage->data;
  if (imb == NULL) return;  
  int i; for (i=0; i < n; i++) *imb++ = coltab555[ *buf++ ];
}

void map_and_redraw() {
  int n = biWidth*biHeight;
  map_buf555(cap_buf, n);   // full color transformation : 320x240 : 0.50 sec
  grab_wi->redraw();    // 320x240 : 0.20 sec
  tdraw = comp_time(); // wird erst beim naechsten Bild dargestellt
}

int sharpness() {
  int xm = biWidth/2, ym = biHeight/2; 
  int x,y,x0 = xm-50, x1 = xm+50, y0 = ym-50, y1 = ym+50; 
  int s = 0;
  for (y = y0; y < y1; y++) for (x = x0; x < x1; x++) {
    short (*image) [biWidth] = (short (*)[biWidth]) cap_buf;
    short dx,dy,z; 
    dx = image[y][x] - image[y][x-1];
    dy = image[y][x] - image[y-1][x];
    z = SQR(b555(dx)) + SQR(g555(dx)) + SQR(r555(dx)) + 
	SQR(b555(dy)) + SQR(g555(dy)) + SQR(r555(dy));
    s+= z;
  }
  return (s);
}

// ****** class "view_window" ***** 
view_window::view_window(window &parent,int w, int h, int x, int y) :
  window(parent,w,h,x,y,0) { 
  // info window at bottom
  infw = new info_window(*this,w,20,0,height-20);  
  Cursor grab_cursor = XCreateFontCursor(display,24); // XC_circle
  XDefineCursor(display,Win,grab_cursor);
  redraw_chain = NULL;
  create_buffers(biWidth, biHeight);
}

// info about cursor point coloring
void view_window::Motion_CB(XMotionEvent ev) {
  if (polling_mode) return;

  short c,b,r,g,ct;  // first part : values from capture buffer  
  c = cap_buf[ev.x + ev.y*biWidth]; 
  b = b555(c);
  g = g555(c);
  r = r555(c);
  short lum = r+g+b; // luminance value

  if (color_info) {
    XColor cval;  // second part : values from XImage
    cval.pixel = XGetPixel(ximage,ev.x,ev.y);
    XQueryColor(display, def_cmap, &cval);    
    // norming cval to 0..31
    int norm = (256*256)/31; // 2114

    sprintf(infw->info,"(%3d,%3d) c=(%2d,%2d,%2d)->(%2d,%2d,%2d) %3d",
       ev.x,ev.y,r,g,b,
       cval.red/norm,cval.green/norm,cval.blue/norm,cval.pixel);
  } else {
    int lumx = lum ? lum : 1; // avoid division by 0
    int rf = (100*r)/lumx, gf = (100*g)/lumx, bf = (100*b)/lumx;
    sprintf(infw->info,"(%3d,%3d) c=(%2d,%2d,%2d) %2d (%2d,%2d,%2d)",
             ev.x,ev.y,r,g,b,lum,rf,gf,bf);
  }
  infw->redraw();
}

void view_window::redraw() { 
  if (ximage == NULL) return;
  int ww = MIN(width,ximage->width),
      wh = MIN(height,ximage->height);
    
  XPutImage(display,Win,gc_copy,ximage,0,0,0,0,ww,wh);  
  char * format = (width < 300) ? "%3d %3d %.2f %.2f %d": 
                                    "w = %d h = %d tc = %.2f td = %.2f %d"; 
  int sharp = 0; // = sharpness();
  sprintf(infw->info,format,ww,wh,0.01*tcap,0.01*tdraw,sharp);
  infw->redraw();
  if (redraw_chain) (*redraw_chain)();
}

void view_window::Expose_CB(XExposeEvent ev) {
   XPutImage(display,Win,gc_copy,ximage,ev.x,ev.y,ev.x,ev.y,
             ev.width,ev.height); 
} 

// no default resize of children : infw is only shifted
void view_window::resize(int w, int h) {     
  if (w == width && h == height) return;
  width = w; height = h;
  XResizeWindow(display,Win,w,h); 
  infw->resize(w,20);
  XMoveWindow(display,infw->Win,0,h-20); 
}

void create_buffers(int w, int h) {
  if (cap_buf) delete[] cap_buf;
  cap_buf = new unsigned short[w * h]; // fuer capture
  if (cap_buf == NULL) error("no room for cap_buf");

  // der image buffer wird automatisch mitgeloescht !
  if (ximage) XDestroyImage(ximage);
  ximage = create_image(w, h);
}  

// adjusting the size of the main window to fit an image ww*hh
void adjust_size(int ww, int hh) {
  window *mw = grab_wi->mainw; // not yet consistent
  mw->resize(ww,hh+40);
  XResizeWindow(display,mw->Win,ww,hh+40); 
}
