//[q0,qd0]=qinit(speed,bankangle,direction)
//---------------------------------------------------------------------------*/
//---------------------------------------------------------------------------*/
//                                rear wheel                                 */
//---------------------------------------------------------------------------*/
//---------------------------------------------------------------------------*/
//   x1  =q(1)   position (x) on the ground
         q0(1)=0;     
//   y1  =q(2)   position (y) on the ground
         q0(2)=0;
//   z1  =q0(3)  position (z) 
         q0(3)=r1;
//               Euler angles 
//   phi1=q0(4)   Phi angle
         q0(4)=0;
//   the1=q(5)   Theta angle 
         q0(5)=%pi/2-bankangle*%pi/180;
//   psi1=q(6)   Psi angle
         q0(6)=0;
     

//   x1d  =qd(1) speed along the (x) axis
         qd0(1)= speed;
//   y1d  =qd(2) speed along the (y) axis
         qd0(2)= 0;
//   z1d  =qd(3)
         qd0(3)=0;
//   phi1d=qd(4)
         qd0(4)=0;
//   the1d=qd(5)
         qd0(5)=0;
//   psi1d=qd(6) angular velocity
         qd0(6)=-qd0(1)/r1;      


//---------------------------------------------------------------------------*/
//---------------------------------------------------------------------------*/
//                                 frame                                     */
//---------------------------------------------------------------------------*/
//---------------------------------------------------------------------------*/

//   x2  =q(7)  position (x) 
        q0(7)=b2*cos(ro);
//   y2  =q(8)  position (y)
        q0(8)=b2*sin(ro)*cos(q0(5));
//   z2  =q(9)  position (z)
        q0(9)=b2*sin(ro)+r1;
//   ksi2=q(10) angle 
        q0(10)=ro;

//   x2d  =qd(7) speed along (x) axis
        qd0(7)=qd0(1);
//   y2d  =qd(8) speed along (y) axis
        qd0(8)=qd0(2);
//   z2d  =qd(9) 
        qd0(9)=0;
//   ksi2d=qd(10) 
        qd0(10)=0;

//---------------------------------------------------------------------------*/
//---------------------------------------------------------------------------*/
//                               front wheel                                 */
//---------------------------------------------------------------------------*/
//---------------------------------------------------------------------------*/

//   x4  =q(15)  position along (x) axis
         q0(15)=d;
//   y4  =q(16)  position along (y) axis
         q0(16)=0;
//   z4  =q(17)  position along (z) axis
         q0(17)= r4;
//   phi4=q(18)  direction
         q0(18)=direction*%pi/180;
//   the4=q(19) Theta angle
         q0(19)= %pi/2; 
//   psi4=q(20) rotation autour de l'axe de la roue
         q0(20)= 0;

   
//   x4d  =qd(15) speed (x) axis
         qd0(15)= qd0(1);
//   y4d  =qd(16) speed (y) axis
         qd0(16)= qd0(2);; 
//   z4d  =qd(17)
         qd0(17)= 0;
//   phi4d=qd(18)
         qd0(18)= 0;
//   the4d=qd(19) 
         qd0(19)=0;
//   psi4d=qd(20) angular velocity
         qd0(20)=-qd0(15)/r4;
//
//   center of the wheel
//
         q0(21)=q0(15);     //x(21)=x(15);
         q0(22)=q0(16);     //x(22)=x(16);
         q0(23)=q0(17);     //x(23)=x(17);
//
         qd0(21)=qd0(15);   //x(44)=x(38);
         qd0(22)=qd0(16);   //x(45)=x(39);
         qd0(23)=qd0(17);   //x(46)=x(40);

//--------------------------------------------------------------------------*/
//--------------------------------------------------------------------------*/
//                                fork                                      */
//--------------------------------------------------------------------------*/
//--------------------------------------------------------------------------*/
  
//   x3  =q(11) x-position 
        q0(11)=d-b4*cos(%pi/2-kapa);
//   y3  =q(12) y-position 
        q0(12)=b4*sin(%pi/2+kapa)*cos(q0(19));
//   z3  =q(13) z-position 
        q0(13)=b4*sin(%pi/2-kapa)+r4;
//   ksi3=q(14) angle entre la fourche et le sol 
        q0(14)=%pi/2+kapa;

//   x3d  =qd(11) speed
        qd0(11)= qd0(1);
//   y3d  =qd(12) speed
        qd0(12)=0;
//   z3d  =qd(13)
        qd0(13)=0;
//   ksi3d=qd(14)
        qd0(14)=0;
//--------------------------------------------------------------------------*/
//--------------------------------------------------------------------------*/
//end