//-------------------------------------------------------------------//

// Synopsis:    Hilbert transform

// Syntax:      hilbert ( X )

// Description:

//      Hilbert computes the Hilbert transform of a real
//      sequence. Hilbert returns a complex valued analytic function
//      Z, such that:

//              Z = X + jXh

//      Where X is the original series, Xh

//      Properties: y = hilbert (x);
//                  A = abs (y) is an envelope of x.
//                  ph= angle (y) is the instaneous phase of x.
//                  -N*eps < real (y)' * imag (y) < N*eps

//                  
// Reference: J. S. Bendat, A. G. Piersol, Random Data, Analysis 
//            and Measurement Procedures. 2nd Edition, 1986, 
//            J. Wiley and Sons. 

// See Also: fft, ifft

//-------------------------------------------------------------------//

hilbert = function ( x )
{
  local (x)

  y = fft (real (x[:]));  # Make sure it is a vector.
  n = y.n;
  if (n != 1)
  {
    b = [1;                      # B_1(0) term
         2*ones ((n-1)/2,1);     # f > 0
         ones (1-mod(n,2),1);    # B_1(0) again (symmetric ?)
         zeros ((n-1)/2,1) ];    # f < 0
    y = b.*y;
  }

  return ifft(y);
};
