#include <dos.h>
#include <stdlib.h>
#include <stdio.h>

/* changes for DJGPP/GRX by Hartmut Schirmer and Axel Rohde */
#ifdef DJ
#  include <grx.h>
#  include <mousex.h>
#endif

#define false (0)
#define true (!0)
void mousecursor( int toggle);
/*
main()
{
	for (;;) {
		mousecursor(true);
		printf("Mouse col %d  %d \n",mousecol(),mouserow());
		delay(1000);
	}
}

*/

int mousebuttons()                    /* see if mouse buttons are pressed */
{
#ifdef DJ
   MouseEvent event;

   MouseGetEvent( M_BUTTON_DOWN | M_POLL, &event);
   return event.buttons & 3;
#else
   union REGS inregs;
   union REGS outregs;
   inregs.x.ax = 6;
   int86(0x33,&inregs,&outregs);
   return(outregs.x.ax & 3);
#endif
}



int mousecheck()                      /* see if mouse exists, & # of buttons */
{
#ifdef DJ
   if (!MouseDetect()) return 0;
   MouseInit();
   return 2;
#else   
   union REGS inregs;
   union REGS outregs;
   inregs.x.ax = 0;
   int86(0x33,&inregs,&outregs);
   return(outregs.x.ax ? outregs.x.bx : 0);
#endif
}



int mouseclick()                      /* see if mouse buttons were clicked */
{
#ifdef DJ
   MouseEvent event, event2;
   
   MouseGetEvent( M_BUTTON_DOWN|M_POLL, &event);
   if (event.buttons) {
		 MouseGetEvent( M_BUTTON_UP | M_POLL, &event2);
		 MouseGetEvent( M_BUTTON_UP, &event);
		 return 3 & event2.buttons;
   }
   return 0;   
#else
   int click = 0;
   union REGS inregs;
   union REGS outregs;
   inregs.x.ax = 5;
   inregs.x.bx = 1;
   int86(0x33,&inregs,&outregs);
   click = outregs.x.bx << 1;
   inregs.x.bx--;
   int86(0x33,&inregs,&outregs);
   return(click | outregs.x.bx);
#endif
}



int mousecol()                        /* get column where mouse cursor is */
{
#ifdef DJ
   MouseEvent event;
   
   MouseGetEvent( M_MOTION | M_POLL, &event);
   return event.x;
#else
   union REGS inregs;
   union REGS outregs;
   inregs.x.ax = 3;
   int86(0x33,&inregs,&outregs);
   return(outregs.x.cx);
#endif
}



void mousecursor(toggle)              /* turn mouse cursor on or off */
   int toggle;
{
#ifdef DJ
   if (toggle) MouseDisplayCursor();
		  else MouseEraseCursor();
#else
   union REGS inregs;
   union REGS outregs;
   if (toggle) inregs.x.ax = 1;
   else inregs.x.ax = 2;
   int86(0x33,&inregs,&outregs);
#endif
}



void mouseloc(column,row)             /* set location of mouse cursor */
   int column, row;
{
#ifdef DJ
   MouseWarp(column, row);
#else
   union REGS inregs;
   union REGS outregs;
   inregs.x.ax = 4;
   inregs.x.cx = column;
   inregs.x.dx = row;
   int86(0x33,&inregs,&outregs);
#endif
}



int mouserow()                        /* get row where mouse cursor is */
{
#ifdef DJ
   MouseEvent event;
   
   MouseGetEvent( M_MOTION | M_POLL, &event);
   return event.y;
#else
   union REGS inregs;
   union REGS outregs;
   inregs.x.ax = 3;
   int86(0x33,&inregs,&outregs);
   return(outregs.x.dx);
#endif
}

