/*
 * powerglove.h
 *
 * (c)9/3/1994 Stuart N. John
 *
 */

#ifndef POWERGLOVE_H
#define POWERGLOVE_H


#define PGDEVICE "/dev/ttyS1"  /* serial device for glove data */


#define G_BYTES 7  /* number of bytes in glove data array */

#define G_X 0  /* index of x coordinate value       */
#define G_Y 1  /* index of y coordinate value       */
#define G_Z 2  /* index of z coordinate value       */
#define G_W 3  /* index of wrist rotation value     */
#define G_F 4  /* index of finger bit values        */
#define G_K 5  /* index of key code value           */
#define G_T 6  /* index of relative tick time value */


/* functions to handle powerglove */

extern int glove_init(void);
extern int glove_update(char *data, char filtermode);
extern int glove_quit(void);

#endif
