/*
 * mode.h
 *
 * (c)23/1/1994 Stuart N. John
 *
 */

#ifndef MODE_H
#define MODE_H


#define M_BYTES 3  /* number of mode flag bytes */


typedef struct
{
  char datalist;  /* data combination list */
  char comms;     /* communication mode    */
  char filter;    /* digital filter toggle */
} Mode_t;


/* data list flags */

/* the server may be instructed to send only partial glove data
   defined by a combination of these flags */

#define PGDATA_NONE  0
#define PGDATA_FLEX  1
#define PGDATA_WRIST 2
#define PGDATA_XYZ   4


/* communication mode */

/* client-server communication may be either one-way or two-way.
   one-way mode - the server continuously sends data to the client,
   two-way mode - the client must poll the server when it requires new data */

#define PGCOMMS_ONEWAY 1
#define PGCOMMS_TWOWAY 2


/* filter mode */

/* the server has a predictive filter algorithm designed to eliminate
   glitches in the glove data, this filter may be switched on or off */

#define PGFILTER_OFF 0
#define PGFILTER_ON  1

#endif
