#include <sys/types.h>
#include <stdio.h>

#include "glove.h"
#include "mode.h"
#include "client.h"


int main(int argc, char *argv[])
{
  int     client;
  int     i;
  Glove_t *glove;

  client = client_get_service("pgloved");  /* connect to glove server */
  if (client < 0)
  {
    fprintf(stderr, "demo: can't use glove\n");
    exit(1);
  }

  client_set_datalist(client, PGDATA_FLEX | PGDATA_WRIST | PGDATA_XYZ);
  client_set_comms(client, PGCOMMS_TWOWAY);
  client_set_filter(client, PGFILTER_ON);

  client_get_datalist(client);
  client_get_comms(client);
  client_get_filter(client);

  for(i = 1; i < 200; i++)
  {
    glove = client_get_record(client);
    fprintf(stderr, "x:%4d ", getX(glove));
    fprintf(stderr, "y:%4d ", getY(glove));
    fprintf(stderr, "z:%4d ", getZ(glove));
    fprintf(stderr, "r:%2d ", getRotation(glove));
    fprintf(stderr, "k:%2x ", getKey(glove));
    fprintf(stderr, "t:%3d ", getTime(glove));
    fprintf(stderr, "   \r");
  }

  fprintf(stderr, "\n\ndemo: filter off\n\n");

  client_set_filter(client, PGFILTER_OFF);

  for(i = 1; i < 200; i++)
  {
    glove = client_get_record(client);
    fprintf(stderr, "x:%4d ", getX(glove));
    fprintf(stderr, "y:%4d ", getY(glove));
    fprintf(stderr, "z:%4d ", getZ(glove));
    fprintf(stderr, "r:%2d ", getRotation(glove));
    fprintf(stderr, "k:%2x ", getKey(glove));
    fprintf(stderr, "t:%3d ", getTime(glove));
    fprintf(stderr, "   \r");
  }

  fprintf(stderr, "\n\ndemo: one-way mode & filter\n\n");

  client_set_filter(client, PGFILTER_ON);
  client_set_comms(client, PGCOMMS_ONEWAY);

  for(i = 1; i < 200; i++)
  {
    glove = client_get_record(client);
    fprintf(stderr, "x:%4d ", getX(glove));
    fprintf(stderr, "y:%4d ", getY(glove));
    fprintf(stderr, "z:%4d ", getZ(glove));
    fprintf(stderr, "r:%2d ", getRotation(glove));
    fprintf(stderr, "k:%2x ", getKey(glove));
    fprintf(stderr, "t:%3d ", getTime(glove));
    fprintf(stderr, "   \r");
  }

  fprintf(stderr, "\n");

  client_quit(client);  /* close connection to glove server */

  fprintf(stderr, "demo: bye...\n");

  printf("demo: exit\n");
  exit(0);
}
