#
# Copyright (c) 1993 Eric Schenk.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
# SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

# Set the path where you installed the sample window manager TCL files here.
set tkwm_libpath @TKWM_LIBRARY@
set tkwm_resource @TKWM_LIBRARY@/stkwm.tcl

# Read the option databases
source $tkwm_libpath/functions.tcl
source $tkwm_libpath/preferences.tcl
initialize_prefs

# get the widgets I define locally
source $tkwm_libpath/widgets.tcl
source $tkwm_libpath/mbuttons.tcl
source $tkwm_libpath/decos.tcl
# get the core window manager routines.
source $tkwm_libpath/menus.tcl
source $tkwm_libpath/frames.tcl
source $tkwm_libpath/iframes.tcl
source $tkwm_libpath/icons.tcl
source $tkwm_libpath/move.tcl
source $tkwm_libpath/resize.tcl
source $tkwm_libpath/focus.tcl
source $tkwm_libpath/managers.tcl
source $tkwm_libpath/error.tcl

# get the defaults for customizable code
source $tkwm_libpath/custom.tcl

# get any user customizations
catch {source ~/.stkwmrc}

# let TCL catch up before we start mapping windows
update idletasks

# Map the existing windows
tkwm_restart
