#
# Copyright (c) 1993 and 1994 Eric Schenk.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
# SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc send_cmd {cmd} {
    send tkwm $cmd
}

#-------------------------------------------------------------------------------
# Data for constructing dialogs
#-------------------------------------------------------------------------------

set FramesData {
    {"Opaque Move"          Tk.Client*opaqueMove boolean}
    {"Opaque Resize"        Tk.Client*opaqueResize boolean}
    {"Constrained Move"     Tk.Client*constrained boolean}
    {"Use Old WM_STATE"     Tk.Client*use_WM_STATE boolean}
    {"Titlebar"             Tk.Client*TkwmClientFrame.titlebar boolean}
    {"Border Width"         Tk.Client*TkwmClientFrame.borderWidth integer_choice}
    {"Left Buttons"         Tk.Client*TkwmClientFrame.leftButtons button_choice}
    {"Right Buttons"        Tk.Client*TkwmClientFrame.rightButtons button_choice}
    {"Font"                 Tk.Client*TkwmClientFrame.font font_choice}
    {"Cursor"               Tk.Client*TkwmClientFrame.cursor cursor}
    {"Geometry Manager"     Tk.Client*manager manager_choice}
    {"Background"           Tk.Client*TkwmClientFrame.background color_choice}
    {"Foreground"           Tk.Client*TkwmClientFrame.foreground color_choice}
    {"Active Background"    Tk.Client*TkwmClientFrame.activeBackground color_choice}
    {"Active Foreground"    Tk.Client*TkwmClientFrame.activeForeground color_choice}
}

set TransientsData {
    {"Titlebar"           Tk.Client*transient-decoration.titlebar boolean}
    {"Border Width"       Tk.Client*transient-decoration.borderWidth integer_choice}
    {"Left Buttons"       Tk.Client*transient-decoration.leftButtons button_choice}
    {"Right Buttons"      Tk.Client*transient-decoration.rightButtons button_choice}
    {"Cursor"             Tk.Client*transient-decoration.cursor cursor}
    {"Background"         Tk.Client*transient-decoration.background color_choice}
    {"Foreground"         Tk.Client*transient-decoration.foreground color_choice}
    {"Active Background"  Tk.Client*transient-decoration.activeBackground color_choice}
    {"Active Foreground"  Tk.Client*transient-decoration.activeForeground color_choice}
}

set IconsData {
    {"Opaque Move"           Tk.Client*Icon.opaqueMove boolean}
    {"Opaque Resize"         Tk.Client*Icon.opaqueResize boolean}
    {"Constrained Movement"  Tk.Client*Icon.constrained boolean}
    {"Titlebar"              Tk.Client*Icon.TkwmIconFrame.titlebar boolean}
    {"Font"                  Tk.Client*Icon.TkwmIconFrame.font font_choice}
    {"Cursor"                Tk.Client*Icon.TkwmIconFrame.cursor cursor}
    {"Image Width"           Tk.Client*Icon.width integer_choice}
    {"Image Height"          Tk.Client*Icon.height integer_choice}
    {"Image Bitmap"          Tk.Client*Icon.bitmap bitmap_choice}
    {"Geometry Manager"      Tk.Client*Icon.manager manager_choice}
    {"Background"            Tk.Client*Icon.TkwmIconFrame.background color_choice}
    {"Foreground"            Tk.Client*Icon.TkwmIconFrame.foreground color_choice}
    {"Active Background"     Tk.Client*Icon.TkwmIconFrame.activeBackground color_choice}
    {"Active Foreground"     Tk.Client*Icon.TkwmIconFrame.activeForeground color_choice}
}

set MenusData {
    {"Font"                  Tk.Menu*font font_choice}
    {"Cursor"                Tk.Menu*cursor cursor}
    {"Border Width"          Tk.Menu*borderWidth integer_choice}
    {"Active Border Width"   Tk.Menu*activeBorderWidth integer_choice}
    {"Background"            Tk.Menu*background color_choice}
    {"Foreground"            Tk.Menu*foreground color_choice}
    {"Title Foreground"      Tk.Menu*disabledForeground color_choice}
    {"Active Background"     Tk.Menu*activeBackground color_choice}
    {"Active Foreground"     Tk.Menu*activeForeground color_choice}
}

proc specialize {respath} {
    global name_or_class
    if {$name_or_class!=""} {
	if [regexp {^(Tk.Client)\*(.*)} $respath dummy a b] {
	    set res $a.$name_or_class.$b
	} else {
	    set res $respath
	}
    } else {
        set res $respath
    }
    return $res
}

proc makeDisplay {name} {
    global prefs tkwm_prefs use_default

    upvar "#0" ${name}Data data
    set path .display.[string tolower $name]

    frame $path
    frame $path.questions -borderwidth 1 -relief raised
    pack $path.questions -side right -expand yes -fill both -anchor nw
    set index 0
    foreach i $data {
	set message [lindex $i 0]
	set varindex [lindex $i 1]
	set svarindex [specialize [lindex $i 1]]
	set type [lindex $i 2]
	set choices [lindex $i 3]
        if ![info exists tkwm_prefs($svarindex)] {
	    set prefs($varindex) [compute_default $varindex]
	    set use_default($varindex) 1
        } else {
	    set prefs($varindex) $tkwm_prefs($svarindex)
	    set use_default($varindex) 0
        }
	$type $path.questions.$index $message: $varindex
	pack $path.questions.$index -side top -anchor w -pady 2 -fill x
	incr index
    }
}

proc updateDisplay {name} {
    global prefs tkwm_prefs use_default

    upvar "#0" ${name}Data data
    set path .display.[string tolower $name]

    set index 0
    foreach i $data {
	set varindex [lindex $i 1]
	set svarindex [specialize $varindex]
        if ![info exists tkwm_prefs($svarindex)] {
	    set prefs($varindex) [compute_default $varindex]
	    set use_default($varindex) 1
        } else {
	    set prefs($varindex) $tkwm_prefs($svarindex)
	    set use_default($varindex) 0
        }
	incr index
    }
}

proc change_display {} {
    global views oldviews
    if [info exists oldviews] {
	if [string match $views $oldviews] return
    }
    if [info exists oldviews] {pack forget .display.[string tolower $oldviews]}
    pack .display.[string tolower $views] -fill both -anchor nw -expand yes
    set oldviews $views
}

proc updateDisplays {} {
    global prefs name_or_class user_default MenusData
    updateDisplay Frames
    updateDisplay Transients
    updateDisplay Icons
    if {$name_or_class!=""} {
        foreach i $MenusData {
	    set use_default([lindex $i 1]) 1
	}
    } else {
	updateDisplay Menus
    }
}

# This really gross code is needed because Tk just can't do the
# magic I want with resources. Namely, lookup the resource default
# for a resource specification and return the default that would be
# returned if that string where not defined. If you can think of a
# better way to accomplish this I'd like to hear about it!

# Generate a list of default lookups that might be valid for
# the current pattern.

proc compute_default_list {resource} {
    global name_or_class resource_class
    if {$name_or_class!=""} {
	if [regexp {^(Tk.Client)\*(.*)} $resource dummy a b] {
	    set td [regexp {^transient-decoration\.(.*)} $b dummy c]
	    if ![string match $name_or_class $resource_class] {
		if $td {
		    lappend lst \
			tkwm_prefs($a.$name_or_class.TkwmClientFrame.$c)
		}
		lappend lst tkwm_prefs($a.$resource_class.$b)
		if $td {
		    lappend lst \
			tkwm_prefs($a.$resource_class.TkwmClientFrame.$c)
		}
	    }
	    lappend lst tkwm_prefs($a*$b)
	    if $td {
		lappend lst tkwm_prefs($a*TkwmClientFrame.$c)
	    }
	    lappend lst tkwm_defaults($a*$b)
	    if $td {
		lappend lst tkwm_defaults($a*TkwmClientFrame.$c)
	    }
	} else {
	    # Not a wildcarded spec. Simple case.
	    set lst [list tkwm_defaults($resource)]
	}
    } else {
	# looking for the global default
	set td [regexp {^(Tk.Client)\*transient-decoration(.*)} $resource d a b]
	if $td {
            lappend lst [list tkwm_prefs($a*TkwmClientFrame$b)]
	}
        lappend lst [list tkwm_defaults($resource)]
	if $td {
            lappend lst [list tkwm_defaults($a*TkwmClientFrame$b)]
	}
    }
    return $lst
}

proc compute_default {resource} {
    global tkwm_prefs tkwm_defaults

    foreach i [compute_default_list $resource] {
	if [info exists $i] {return [set $i]}
    }
    return ""
}

proc disable {} {
    . config -cursor watch
    grab set .top.class_label
    update
}

proc enable {} {
    . config -cursor top_left_arrow
    grab release .top.class_label
    update
}

proc sort_function {a b} {
    regexp {^([^.*]+[.*])*} $a c
    regexp {^([^.*]+[.*])*} $b d
    set result [string compare $c $d]
    if {$result=="0"} {return [string compare $a $b]}
    return $result
}

proc merge_prefs {} {
    global tkwm_prefs::global tkwm_prefs::classes tkwm_prefs::names
    global use_default prefs tkwm_prefs
    global name_or_class resource_class

    finalize_entries

    if {$name_or_class!=""} {
    	if [string match $name_or_class $resource_class] {
            catch {unset tkwm_prefs::classes($name_or_class)}
	} else {
	    catch {unset tkwm_prefs::names($name_or_class)}
	}
    }
    foreach i [array names use_default] {
	set v [specialize $i]
	if $use_default($i) {
	    catch {unset tkwm_prefs($v)}
	    catch {unset tkwm_prefs::global($v)}
	} else {
	    set tkwm_prefs($v) $prefs($i)
	    if {$name_or_class==""} {
		set tkwm_prefs::global($v) 1
	    } else {
		if [string match $name_or_class $resource_class] {
		    lappend tkwm_prefs::classes($name_or_class) $v
		} else {
		    lappend tkwm_prefs::names($name_or_class) $v
		}
	    }
	}
    }
}

proc change_application {choice} {
    global resource_class name_or_class views
    if [string match $name_or_class $choice] {return}
    disable
    # merge the existing results into the database
    merge_prefs
    # put new choices on display.
    handleError {
	set resource_class [send_cmd "winfo class \[lindex \[set tkwm_prefs::names($choice)\] 0\]"]
    } {
	set resource_class $choice
    }
    set name_or_class $choice
    if {$name_or_class!=""} {
	.top.view.menu disable 3
    } else {
	.top.view.menu enable 3
    }
    if {$views=="Menus"&&$name_or_class!=""} {set views Frames}
    updateDisplays
    change_display
    enable
}


proc save_to_file {file} {
    global tkwm_prefs::global tkwm_prefs::classes tkwm_prefs::names
    global tkwm_prefs
    set out [open $file w 0600]

    unwindProtect {
	if [info exists tkwm_prefs] {
	    if [info exists tkwm_prefs::global] {
		foreach i [lsort [array names tkwm_prefs::global]] {
		    puts $out "$i: $tkwm_prefs($i)"
		}
	    }
	    if [info exists tkwm_prefs::classes] {
		foreach i [array names tkwm_prefs::classes] {
		    puts $out "!"
		    foreach j [lsort [set tkwm_prefs::classes($i)]] {
			puts $out "$j: $tkwm_prefs($j)"
		    }
		}
	    }
	    if [info exists tkwm_prefs::names] {
		foreach i [array names tkwm_prefs::names] {
		    puts $out "!"
		    foreach j [lsort [set tkwm_prefs::names($i)]] {
			puts $out "$j: $tkwm_prefs($j)"
		    }
		}
	    }
	}
    } {
	close $out
    }
}

proc read_pref_file {file varname hook} {
    upvar "#0" $varname data
    upvar "#0" $varname::list lst
    
    catch {unset data}
    catch {unset lst}
    handleError {
	set out [open $file r]
	unwindProtect {
	    while {[gets $out s]!="-1"} {
		if {[string index $s 0]!="!"} {
		    set l [split $s ":"]
		    set data([lindex $l 0]) [string trim [lindex $l 1]]
		    eval $hook [lindex $l 0]
		}
	    }
	} {
	    close $out
	}
    } {}
}

proc null_read_hook {a} {}

proc read_hook {respath} {
    global tkwm_prefs::global tkwm_prefs::classes tkwm_prefs::names

    if [regexp {Tk\.Client\.([^.]*)} $respath dummy a] {
	set c [string index $a 0]
	if [string match [string tolower $c] $c] {
	    lappend tkwm_prefs::names($a) $respath
	} else {
	    lappend tkwm_prefs::classes($a) $respath
	}
	return
    } else {
        # the set of current global resources
        set tkwm_prefs::global($respath) 1
    }
}

proc get_preferences {} {
    global tkwm_libpath
    global tkwm_prefs::global tkwm_prefs::classes tkwm_prefs::names
    catch {unset tkwm_prefs::global}
    catch {unset tkwm_prefs::names}
    catch {unset tkwm_prefs::classes}

    if {[winfo screendepth .]>"1"} {
	read_pref_file $tkwm_libpath/tkwm_color.appdefs \
	    tkwm_defaults null_read_hook
	read_pref_file ~/.tkwm_color.appdefs tkwm_prefs read_hook
    } else {
	read_pref_file $tkwm_libpath/tkwm_mono.appdefs \
	    tkwm_defaults null_read_hook
	read_pref_file ~/.tkwm_mono.appdefs tkwm_prefs read_hook
    }
    update
}

set made_backup 0

proc make_backup {} {
    global made_backup
    if $made_backup {return}
    set made_backup 1
    if {[winfo screendepth .]>"1"} {
	catch {exec cp [glob ~]/.tkwm_color.appdefs \
	    [glob ~]/.tkwm_color.appdefs~}
    } else {
	catch {exec cp [glob ~]/.tkwm_mono.appdefs \
	    [glob ~]/.tkwm_mono.appdefs~}
    }
}

proc apply_prefs {} {
    global tkwm_prefs
    disable
    merge_prefs
    make_backup
    if {[winfo screendepth .]>"1"} {
	save_to_file ~/.tkwm_color.appdefs
    } else {
	save_to_file ~/.tkwm_mono.appdefs
    }
    send_cmd {after 1 {initialize_prefs; apply_resources}}
    enable
}

proc restore_prefs {} {
    disable
    if {[winfo screendepth .]>"1"} {
	catch {exec cp [glob ~]/.tkwm_color.appdefs~ \
	    [glob ~]/.tkwm_color.appdefs}
    } else {
	catch {exec cp [glob ~]/.tkwm_mono.appdefs~ \
	    [glob ~]/.tkwm_mono.appdefs}
    }
    send_cmd {after 1 {initialize_prefs; apply_resources}}
    get_preferences
    updateDisplays
    enable
}

proc run {win} {
    global views name_or_class tkwm_libpath resource_class
    global tkwm_prefs::classes tkwm_prefs::names

    set name_or_class ""
    if {$win!=""&&[send_cmd "winfo exists $win"]} {
	if [send_cmd "info exists ${win}(res_name)"] {
            set t [send_cmd "set ${win}(res_name)"]
	    set name_or_class [send_cmd "winfo name $t"]
	    set resource_class [send_cmd "winfo class $t"]
	}
    }

    wm minsize . 1 1
    wm geometry . 600x550
    wm title . "Properties Editor"
    wm iconname . Props
    . config -cursor top_left_arrow

    global tk_strictMotif; set tk_strictMotif 1

    frame .top -relief raised -borderwidth 1
    frame .display
    frame .bottom -relief raised -borderwidth 1

    menubutton .top.view -bitmap @$tkwm_libpath/down_arrow.xbm -menu .top.view.menu -relief raised -borderwidth 2

    menu .top.view.menu
    .top.view.menu add radiobutton -label "Frames" -variable views -command change_display
    .top.view.menu add radiobutton -label "Icons" -variable views -command change_display
    .top.view.menu add radiobutton -label "Transients" -variable views -command change_display
    .top.view.menu add radiobutton -label "Menus" -variable views -command change_display
    label .top.label -textvariable views -width 15 -anchor w
    pack .top.view .top.label -side left

    menubutton .top.class -bitmap @$tkwm_libpath/down_arrow.xbm -menu .top.class.m -relief raised -borderwidth 2
    menu .top.class.m
    .top.class.m add command -label "GLOBAL" \
	-command {change_application ""}
    label .top.class_label -textvariable name_or_class
    pack .top.class .top.class_label -side left

    pack .top -fill x -side top

    pack .display -fill both -expand yes


    pack .bottom -side bottom -fill x
    button .bottom.apply -text "Apply" -padx 3 -pady 3 -command {apply_prefs}
    button .bottom.quit -text "Quit" -padx 3 -pady 3 -command {exit}
    frame .bottom.restore -borderwidth 2 -relief sunken
    button .bottom.restore.b -text "Restore" -padx 3 -pady 3 -command {restore_prefs}
    pack .bottom.restore.b -padx 5 -pady 5

    pack .bottom.apply .bottom.quit .bottom.restore -side left -padx 5 -pady 5 -expand yes
    wm deiconify .

    label .display.centered -text "Loading Preferences..."
    place .display.centered -relx 0.5 -rely 0.5 -anchor c
    update idletasks
    update
    disable

    get_preferences

    send_cmd pref_client_list
    foreach i [send_cmd {array names tkwm_prefs::classes}] {
	set foo($i) 1
        .top.class.m add command -label $i -command [list change_application $i]
    }
    if [info exists tkwm_prefs::classes] {
        foreach i [array names tkwm_prefs::classes] {
	    if [info exists foo($i)] continue
	    set foo($i) 1
            .top.class.m add command -label $i -command [list change_application $i]
        }
    }
    foreach i [send_cmd {array names tkwm_prefs::names}] {
	set foo($i) 1
        .top.class.m add command -label $i -command [list change_application $i]
    }
    if [info exists tkwm_prefs::names] {
        foreach i [array names tkwm_prefs::names] {
	    if [info exists foo($i)] continue
	    set foo($i) 1
            .top.class.m add command -label $i -command [list change_application $i]
        }
    }

    .display.centered config -text "Creating Dialogs..."
    update idletasks

    makeDisplay Frames
    makeDisplay Transients
    makeDisplay Icons
    makeDisplay Menus
    enable
    destroy .display.centered
    # Get the default display showing
    set views Frames
    if {$name_or_class!=""} {
	.top.view.menu disable 3
    } else {
	.top.view.menu enable 3
    }
    change_display
}
