
/*
 * (c) 1988 by George Kyriazis
 */

/*
 * include file for the ray-tracer
 */

#ifndef	NULL
#define	NULL 0
#endif

#ifndef	FALSE
#define	FALSE	0
#endif

#ifndef	TRUE
#define	TRUE	!FALSE
#endif

#define	MINT	1e-5

#define	ABS(a)	( ((a) > 0 ) ? (a) : -(a) )
#define	MIN(a, b)	( (a) < (b) ? (a) : (b) )

#define	MAXLEVEL	3	/* maximum recursion level */

#define	SPHERE		0
#define	SQUARE		1

struct	vector	{double x,y,z;};

/* the color structure */
struct	color	{
		double	r,g,b;
		};

/* the object structure */
struct	obj	{
		int	type;		/* type of object */
		union data {
			struct	sphere {	/* sphere definition */
				struct	vector	center;
				double	radius;
				} sphere;
			struct	quad {		/* quad definition */
				struct	vector	p1;
				struct	vector	p2;
				struct	vector	p3;
				} quad;
			} data;
		double	reflection;	/* precentage reflection */
		double	refraction;	/* percentage refraction */
		struct	color	refl_color;	/* reflective color */
		struct	color	refr_color;	/* refractive color */
		struct	color	ambient;	/* ambient color */
		struct	color	diffuse;		/* diffuse color */
		struct	color	specular;	/* specular color */
		double	width;		/* specular width factor */
		double	index;		/* index of refraction */
		double	refl_diffuse;	/* circle of diffusion in reflection */
		double	refr_diffuse;	/* circle of diffusion in refraction */
		struct	vector	time;	/* motion coefficients */
		};

/* light source */
struct	light {
	struct	vector	org;
	double	angle;
};
struct	light	light;

/* number of objects */
int	noo;

/* number of tries per pixel */
int	tries;

/* eye viewing stuff */
struct	vector	hor, ver, eye_dir, eye, up;
double	fov;

/* time information */
double	time1, time2;		/* time limits */
double	Time;			/* current time */

/* background cuing info */
int	bgflag;
#define	NONE	0
#define	X	1
#define	Y	2
#define	Z	3

/* the array of spheres */
struct	obj	*obj;

/* resolution */
int	xres, yres;

/* the ray structure */
struct	ray	{
		struct	vector	pos;	/* origin */
		struct	vector	dir;	/* direction */
		struct	obj	*obj;	/* where the ray comes from */
		double	theta;		/* the diffusion angle */
		};

/* the intersection structure */
struct	intersect	{
		struct	obj	*obj;	/* which object */
		double	t;		/* where in the ray */
		struct	vector	n;	/* the normal at that point */
		};

/* some statistics variables */
int	raycount;		/* total number of rays */
int	shadowcount;		/* total number of shadow rays traced */
int	reflectcount;		/* total number of reflected rays */
int	refractcount;		/* total number of refracted rays */
int	intersectcount;		/* total number of object intersections */
int	objtestcount;		/* total number of intersection tests */

int	rayline;		/* rays / line */
int	shadowline;		/* shadow rays / line */
int	reflectline;		/* reflected rays / line */
int	refractline;		/* refracted rays / line */
int	intersectline;		/* object intersections / line */
int	objtestline;		/* object intersection tests / line */
