/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		rayausg.h
 *  Filetyp:		Header
 ********************************************************************************
 *  Modulname:		Anzeige
 *  Release:		2
 *  letzte Aenderung:	25.3.93
 *  Autor:  		Hartmut 
 *  Status:		Definitionen fuer rayausg.c
 *		       							
 *  exp. Bezeichner:
 *  ----------------
 *
 *  Beschreibung:
 *  -------------
 *  In diesem Header werden einige Makros definiert, die eventuell an die
 *  Umgebung anzupassen sind (Beispiel: Filename des AERO-Includefiles fuer
 *  den POV-Ray).
 *
 *  Fehler:
 *  -------
 *
 *  Releasegeschichte:					       	
 *  -------------------						       	
 *   1:   Grundlegende Version (POV-Ray V1.0)  --> V1.3
 *   2:   Anpassung an POV-Ray V2.x            --> V1.5
 ********************************************************************************/

/***********************************************************************
 *  Konstanten fuer die zu benutzende Raytracer-Version
 ***********************************************************************/

#define POVRAY1   1
#define POVRAY2   2
#if 0					  /* moegliche Erweiterungen */
#define RAYSHADE  3
#endif


#ifndef RAYAUSG_C

/*****************************************************************************
 *  Funktion:       void ErzeugeRaytracerBild(char *grundname, TKamera kamera, 
 *                                   TZustand *zustand, int modus, int rayvers,
 *                                                             int framenumber)
 *
 *  Parameter:      grundname:   Pfad und Grundname des Files (einschliesslich 
 *                               Framenummer, ohne Extension)
 *                  kamera:      Position, Lage und zoom der Kamera
 *                  zustand:     Zeiger auf den darzustellenden Zustand
 *                  modus:       Art der Ausgabe (Bitvektor)
 *                               Bit 0: Fussboden zeichnen (1) oder nicht (0)
 *                               Bit 1: Koordinatenachsen der Fenster zeichnen (1)
 *                                      oder nicht (0)
 *                               Bit 2: Koordinatenachsen der einzelnen Koerper
 *                                      zeichnen (1) oder nicht (0)
 *                  rayvers:     Zu verwendende Raytracer-Version:
 *                                  1: POV-Ray V1.0
 *                                  2: POV-Ray V2.x
 *                  framenumber: Nummer des aktuellen AERO-Frames
 *
 *  Rueckgabewert:  -
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Mit dieser Routine wird der angegebene Zustand als Quelltext fuer den
 *  Raytracer ausgegeben. Dabei wird davon ausgegangen, dass es ein
 *  File mit den Texturen fuer die einzelnen Materialien gibt.
 *****************************************************************************/

extern
void ErzeugeRaytracerBild(char *grundname, TKamera kamera, TZustand *zustand, 
			  int animmodus, int rayvers, int framenumber);

#else  /* RAYAUSG_C */

/***********************************************************************
 *  Filename fuer das POV-Ray V1.0 Include-File mit den Grundkoerpern
 ***********************************************************************/

#define POVRAY1BASICFILENAME "aeropov1.inc"


/***********************************************************************
 *  Filename fuer das POV-Ray V1.0 Include-File mit den Materialien
 ***********************************************************************/

#define POVRAY1MATERIALFILENAME "aerop1materials.inc"


/***********************************************************************
 *  Filename fuer das POV-Ray V2.x Include-File
 ***********************************************************************/

#define POVRAY2INCLUDE "aeropov2.inc"


/***********************************************************************
 *  Namen fuer die 3 Grundrichtungsvektoren relativ zur Kamera. Ausser-
 *  dem Werte fuer Zoom und die Kameraposition selbst
 ***********************************************************************/

#define POVRAY2CAMPOS "aerocameraposition"
#define POVRAY2ZOOM "aerocamerazoom"
#define POVRAY2CAMX "aerocamerax"
#define POVRAY2CAMY "aerocameray"
#define POVRAY2CAMZ "aerocameraz"


#if 0
/***********************************************************************
 *  Namen fuer Lichter fuer das POV-Ray V2.x Include-File
 ***********************************************************************/

#define POVRAY2LIGHT     "aerolight"
#define POVRAY2LIGHTPOS  "aerolightpos"
#endif


/***********************************************************************
 *  Namen fuer die von AERO vorbesetzten Konstanten (ermoeglichen ani-
 *  mierte Erweiterungen und Hintergrund-Szenen)
 ***********************************************************************/

#define POVRAY2FRAME     "aeroframe"
#define POVRAY2TIME      "aerotime"


/***********************************************************************
 *  Namen fuer die einzelnen Koerper, so wie sie in POVRAY1BASICFILENAME
 *  bzw. POVRAY2INCLUDE benannt sind.
 ***********************************************************************/

#define PovrayQuader   "aerobox"       
#define PovrayZylinder "aerocylinder"
#define PovrayKugel    "aerosphere"
#define PovrayEbene    "aeroplane"

/***********************************************************************
 *  Namen fuer die einzelnen Verbindungen, so wie sie in POVRAY1BASICFILENAME
 *  bzw. POVRAY2INCLUDE benannt sind.
 ***********************************************************************/

#define PovrayStange     "aerorod"
#define PovrayGelenk     "aerojoint"
#define PovrayDaempfer   "aerodamper"
#define PovrayFederTeil  "aerospringpart"
#define PovrayFederBound "aerospringbound"


/***********************************************************************
 *  Namen fuer die Texturen, die fuer die Verbindungen benutzt werden und
 *  die in POVRAY1BASICFILENAME bzw. POVRAY2INCLUDE verwendet werden.
 ***********************************************************************/

#define PovrayStangenTextur  "aerorodtexture"
#define PovrayGelenkTextur   "aerojointtexture"
#define PovrayDaempferTextur "aerodampertexture"
#define PovrayFederTextur    "aerospringtexture"

#endif  /* RAYAUSG_C */
