/* example2.c 
 */
#include <stdio.h>

#include "folgeschrittberechnung.h"
#include "materialien.h"

TZustand *myworld;


void step_output()
{
    printf("Time %fsec, sphere at x=%f, y=%f\n", 
	   myworld->Zeit, myworld->Koerper->Position[0], 
	   myworld->Koerper->Position[1]);
}

void main(int argc, char *argv[])
{
    TKonfigFBB konfig;

    /* reading a state from file "bsp.state" 
     */
    if (ReadZustand(&myworld, &GrundMaterialien, "bsp.state", NULL)==FALSE) {
	printf("*** error in bsp.state\n");
	exit();
    }
    
    ErfrageKonfigFBB(&konfig);
    konfig.I_Fehlersteuerung = TRUE;  /* integration with step control */
    konfig.B_PenalityMethode = FALSE; /* don't use penality method for
				       * impacts */

    InitFBB(myworld);

    KonfigFBB(&konfig);

    while (myworld->Zeit+0.05 <= 2.0) {
	step_output();
	FolgeBildBerechnung(myworld, 0.05);
	UngeaendertFBB(myworld);     /* don't use if you changed the world! */
    }
    step_output();

    EndFBB(myworld);
}

