#ifndef lint
static       char    rcsid[] = "$Header: solid.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	solid.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * a SOLID must have 4 points, but the third and the forth points
 * are the same for a trinagle
 *
 * a SOLID can be extruded if it has thickness. if a SOLID has thickness
 * and its layer name has an "_I" suffix, but the reference points is not
 * defined, the orientation of the faces defined by the SOLID have to be
 * reversed.
 */

typedef	struct	solid	{
	INT	npoints;		/* number of points, must be 3 or 4 */
	FLOAT	points[4][3];		/* vertex of the solid */
} SOLID;

/*
 * parse a SOLID
 */

ENTITY	*SolidDxfParse(layerlist)
LAYER	**layerlist;
{
	ENTITY	*entity;
	SOLID	*solid;
	INT	pointsset = 0;
	INT	defaultflag = 0;

	entity = Malloc(ENTITY, 1);
	solid = Malloc(SOLID, 1);
	entity->type = ENTITY_SOLID;
	entity->data = (VOID *) solid;

	entity->layer = LayerDxfParse(layerlist);

	do {
		GetNextGroup();
		switch(Group->code) {
		case 10:
			/*
			 * four points
			 * 10, 20, 30, 11, 21, 31, 12, 22, 32, 13, 23, 33
			 */

			if (pointsset != 0)
				DXFERR("duplicated points for a SOLID %s", "\n");

			pointsset = 1;
			CoordDxfParse(0, solid->points[0]);
			GetNextGroup();
			CoordDxfParse(1, solid->points[1]);
			GetNextGroup();
			CoordDxfParse(2, solid->points[2]);
			GetNextGroup();
			CoordDxfParse(3, solid->points[3]);

			/*
			 * check if the 3rd and 4th points are the same
			 */

			if (CoordSame(solid->points[2], solid->points[3]) == 0)
				solid->npoints = 4;
			else
				solid->npoints = 3;
			break;

		default:
			if (OptionsDxfParse(&entity->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * check if points are all defined
	 */

	if (pointsset == 0)
		DXFERR("undefined points of a SOLID %s", "\n");

	return(entity);
}

/*
 * output a SOLID into DEF/NFF/DXF file
 */

VOID	SolidDefOutput(entity)
ENTITY	*entity;
{
	INT	i, j;
	SOLID	*solid;
	FLOAT	thickness;
	FLOAT	*extrusion;
	FLOAT	delta[3];
	FLOAT	polygon[2][4][3];
	FLOAT	rectangle[4][3];
	FLOAT	a, b, c, d;

	solid = (SOLID *) entity->data;

	if (FaceDegeneratedCheck(solid->npoints, solid->points) != 0)
		return;

	NameOutput(entity->layer);

	VecCopy(solid->points[0], polygon[0][0]);
	VecCopy(solid->points[1], polygon[0][1]);
	VecCopy(solid->points[2], polygon[0][2]);
	if (solid->npoints == 4)
	VecCopy(solid->points[3], polygon[0][3]);

	if (OptionsThickness(entity->options, &thickness) == 0) {
		CheckOrientation(solid->npoints, polygon[0], entity->layer);
		OutputPolygon(solid->npoints, polygon[0], entity);
		return;
	}

	extrusion = OptionsExtrusion(entity->options);
	VecScale(thickness, extrusion, delta);

	VecAdd(solid->points[0], delta, polygon[1][0]);
	VecAdd(solid->points[1], delta, polygon[1][1]);
	VecAdd(solid->points[2], delta, polygon[1][2]);
	if (solid->npoints == 4)
	VecAdd(solid->points[3], delta, polygon[1][3]);

	PlaneEquation(solid->npoints, polygon[0], &a, &b, &c, &d);
	d = a * extrusion[0] + b * extrusion[1] + c * extrusion[2];
	if (d > TOE)
		ReversePolygon(solid->npoints, polygon[0]);
	else
	if (d < -TOE)
		ReversePolygon(solid->npoints, polygon[1]);
	else
		GENERR("cannot extrude a SOLID %s", "\n");

	if (CheckOrientation(solid->npoints, polygon[0], entity->layer) != 
	    CheckOrientation(solid->npoints, polygon[0], entity->layer))
	    	GENERR("two faces of a SOLID have the same orientation after checking %s", "\n");

	if (entity->layer->point == NULL)
		if (CheckLayerName(entity->layer) != 0) {
			ReversePolygon(solid->npoints, polygon[0]);
			ReversePolygon(solid->npoints, polygon[1]);
		}

	for (i = 0; i < solid->npoints; i++) {
		j = i + 1;
		if (j == solid->npoints)
			j = 0;
		VecCopy(polygon[0][i], rectangle[0]);
		VecCopy(polygon[0][j], rectangle[1]);
		VecCopy(polygon[1][solid->npoints - j], rectangle[2]);
		VecCopy(polygon[1][solid->npoints - i], rectangle[3]);
		OutputPolygon(4, rectangle, entity);
	}

	OutputPolygon(solid->npoints, polygon[0], entity);
	OutputPolygon(solid->npoints, polygon[1], entity);
}
