/* $Header: function.h,v 1.2 90/12/12 15:30:21 zhang Exp $ */

/*
 * $Log:	function.h,v $
 * 
 * Revision 1.1  90/03/13  23:25:04  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#ifndef	_FUNCTION

#undef	_CHECK_ARGS

#ifdef	_CHECK_ARGS

/*
 * define some global functions
 */

extern	INT	atoi(CHAR *str);
extern	VOID	exit(INT code);

/*
 * the following are general global functions
 */

/*
 * global functions defined in alloc.c
 */

extern	CHAR	*Alloc(INT num);

/*
 * global functions defined in block.c
 */

extern	BLOCK	*BlockDxfParse(VOID);
extern	BLOCK	*BlockSearch(CHAR *blockname);
extern	VOID	BlockDefOutput(BLOCK *block);
extern	VOID	BlockNffOutput(BLOCK *block);
extern	VOID	BlockDxfOutput(BLOCK *block);
extern	VOID	BlockRadOutput(BLOCK *block);

/*
 * global functions defined in check.c
 */

extern	VOID	PlaneEquation(INT n, FLOAT p[][3],
		FLOAT *a, FLOAT *b, FLOAT *c, FLOAT *d);
extern	INT	CheckDirection(INT npoints, FLOAT polygon[][3], FLOAT point[3]);
extern	INT	CheckLayerName(LAYER *layer);
extern	VOID	ReversePolygon(INT n, FLOAT p[][3]);
extern	INT	CheckOrientation(INT n, FLOAT p[][3], LAYER *layer);

/*
 * global functions defined in coord.c
 */

extern	VOID	CoordDxfParse(INT number, FLOAT point[3]);
extern	INT	CoordSame(FLOAT p[3], FLOAT q[3]);
extern	VOID	CoordDxfOutput(INT number, FLOAT point[3]);
extern	FLOAT	CoordDistance(FLOAT p[3], FLOAT q[3]);

/*
 * global functions defined in entity.c
 */

extern	INT	EntityType(VOID);
extern	ENTITY	*EntityDxfParse(LAYER **layerlist);

/*
 * global functions defined in error.c
 */

extern	ENTITY	*NullDxfParse(VOID);
extern	VOID	NullDefOutput(VOID);
extern	VOID	NullNffOutput(VOID);
extern	VOID	NullDxfOutput(VOID);
extern	VOID	NullRadOutput(VOID);

/*
 * global functions defined in group.c
 */

extern	INT	CmpGroupString(GROUP *group, INT code, CHAR *string);
extern	INT	CmpGroupInteger(GROUP *group, INT code, INT integer);

/*
 * global functions defined in layer.c
 */

extern	LAYER	*LayerInsert(LAYER **layerlist, CHAR *layername);
extern	VOID	EntityInsertToLayer(ENTITY *entity);
extern	LAYER	*LayerDxfParse(LAYER **layerlist);

/*
 * global functions defined in main.c
 */

extern	VOID	PrintStatistics(FILE *fd, CHAR *progname);
extern	VOID	Usage(VOID);
extern	VOID	main(INT argc, CHAR *argv[]);

/*
 * global functions defined in matrix.c
 */

extern	VOID	MatrixUnit(MATRIX matrix[2]);
extern	VOID	MatrixRotate(MATRIX matrix[2], FLOAT vector[3], FLOAT theta);
extern	VOID	MatrixTranslate(MATRIX matrix[2],
		FLOAT deltax, FLOAT deltay, FLOAT deltaz);
extern	VOID	MatrixScale(MATRIX matrix[2],
		FLOAT xscale, FLOAT yscale, FLOAT zscale);
extern	VOID	MatrixExtrusion(MATRIX matrix[2], FLOAT extrusion[3]);
extern	VOID	MatrixMultiply(MATRIX m1[2], MATRIX m2[2], MATRIX m[2]);
extern	VOID	XformPoint(MATRIX m, FLOAT p[3], FLOAT q[3]);
extern	VOID	XformVector(MATRIX m, FLOAT p[3], FLOAT q[3]);
extern	VOID	MatrixPrint(MATRIX m);

/*
 * global functions defined in name.c
 */

extern	CHAR	*NameInsert(LAYER *layer);
extern	VOID	NameDxfOutput(LAYER *layer);
extern	VOID	NameRadOutput(LAYER *layer);
extern	VOID	NameOutput(LAYER *layer);

/*
 * global functions defined in parse.c
 */

#if !defined(MSDOS) && !defined(vax) && !defined(VAX)
extern	VOID	VAX_INT_2_TO_IEEE_INT_2(CHAR *src, CHAR *dst);
#endif
#if defined(vax) || defined(VAX)
extern	VOID	IEEE_FLOAT_8_TO_VAX_FLOAT_8(CHAR *src, CHAR *dst);
#endif
extern	VOID	AsciiGetNextGroup(VOID);
extern	VOID	BinaryGetNextGroup(VOID);
extern	VOID	SkipSection(VOID);
extern	VOID	ParseBlocksSection(VOID);
extern	VOID	ParseEntitiesSection(VOID);
extern	VOID	SkipEndOfFile(VOID);
extern	VOID	ParseDxfFile(CHAR *FileName);

/*
 * global functions defined in options.c
 */

extern	INT	OptionsDxfParse(OPTIONS **options);
extern	INT	OptionsThickness(OPTIONS *options, FLOAT *thickness);
extern	FLOAT	*OptionsExtrusion(OPTIONS *options);
extern	INT	OptionsExtrusionVector(OPTIONS *options, FLOAT vector[3]);

/*
 * global functions defined in output.c
 */

extern	VOID	ResortEntities(VOID);
extern	VOID	OutputDxfPolygon(INT n, FLOAT p[][3], ENTITY *entity);
extern	VOID	OutputPolygon(INT n, FLOAT p[][3], ENTITY *entity);
extern	VOID	OutputNffPhongPolygon(INT n, FLOAT p[][3], FLOAT n[][3], ENTITY *entity);
extern	VOID	OutputFile(CHAR *OutFileName);

/*
 * global functions defined in stack.c
 */

extern	VOID	StackPush(INSERT *insert, MATRIX matrix[2]);
extern	VOID	StackPop();

/*
 * global functions defined in vector.c
 */

extern	FLOAT	VecNormalize(FLOAT s[3]);
extern	VOID	ArbitraryAxis(FLOAT xaxis[3], FLOAT yaxis[3], FLOAT zaxis[3]);

/*
 * the following are global functions for handling entities
 */

/*
 * global functions defined in line.c
 */

extern	ENTITY	*LineDxfParse(LAYER **layerlist);
extern	VOID	LineDefOutput(ENTITY *entity);

/*
 * global functions defined in point.c
 */

extern	ENTITY	*PointDxfParse(LAYER **layerlist);
extern	VOID	PointDefOutput(ENTITY *entity);
extern	VOID	PointNffOutput(ENTITY *entity);
extern	VOID	PointDxfOutput(ENTITY *entity);
extern	VOID	PointRadOutput(ENTITY *entity);

/*
 * global functions defined in circle.c
 */

extern	ENTITY	*CircleDxfParse(LAYER **layerlist);
extern	VOID	CircleTriangleTesselation(INT n, FLOAT center[3],
		FLOAT start[3], FLOAT end[3], ENTITY *entity);
extern	VOID	CircleRectangleTesselation(INT m, INT n, FLOAT p0[3],
		FLOAT p1[3], FLOAT p2[3], FLOAT p3[3], ENTITY *entity);
extern	INT	CircleTesselationNumber(FLOAT radius);
extern	VOID	CircleDefOutput(ENTITY *entity);
extern	VOID	CircleNffOutput(ENTITY *entity);
extern	VOID	CircleRadOutput(ENTITY *entity);

/*
 * global functions defined in arc.c
 */

extern	ENTITY	*ArcDxfParse(LAYER **layerlist);
extern	INT	ArcTesselationNumber(FLOAT radius, FLOAT deltaangle);
extern	VOID	ArcDefOutput(ENTITY *entity);

/*
 * global functions defined in trace.c
 */

extern	ENTITY	*TraceDxfParse(LAYER **layerlist);
extern	VOID	TraceDefOutput(ENTITY *entity);

/*
 * global functions defined in solid.c
 */

extern	ENTITY	*SolidDxfParse(LAYER **layerlist);
extern	VOID	SolidDefOutput(ENTITY *entity);

/*
 * global functions defined in text.c
 */

extern	ENTITY	*TextDxfParse(LAYER **layerlist);
extern	VOID	TextDefOutput(ENTITY *entity);
extern	VOID	TextNffOutput(ENTITY *entity);
extern	VOID	TextDxfOutput(ENTITY *entity);
extern	VOID	TextRadOutput(ENTITY *entity);

/*
 * global functions defined in shape.c
 */

extern	ENTITY	*ShapeDxfParse(LAYER **layerlist);
extern	VOID	ShapeDefOutput(ENTITY *entity);
extern	VOID	ShapeNffOutput(ENTITY *entity);
extern	VOID	ShapeDxfOutput(ENTITY *entity);
extern	VOID	ShapeRadOutput(ENTITY *entity);

/*
 * global functions defined in insert.c
 */

extern	ENTITY	*InsertDxfParse(LAYER **layerlist);
extern	VOID	InsertDefOutput(ENTITY *entity);

/*
 * global functions defined in attrib.c
 */

extern	ATTRIB	*AttribDxfParse(LAYER **layerlist);

/*
 * global functions defined in polyline.c
 */

extern	ENTITY	*PolylineDxfParse(LAYER **layerlist);

extern	VOID	ArcCenterCalculation(FLOAT start[3], FLOAT end[3], FLOAT bulge,
		FLOAT *extrusion, FLOAT center[3], FLOAT *radius,
		FLOAT *startangle, FLOAT *endangle, FLOAT *deltaangle);
extern	VOID	PolylineDefOutput(ENTITY *entity);

/*
 * global functions defined in vertex.c
 */

extern	VERTEX	*VertexDxfParse(LAYER **layerlist);

/*
 * global functions defined in face.c
 */

extern	ENTITY	*FaceDxfParse(LAYER **layerlist);
extern	INT	FaceDegeneratedCheck(INT n, FLOAT p[][3]);
extern	VOID	FaceDefOutput(ENTITY *entity);

/*
 * global functions defined in dimension.c
 */

extern	ENTITY	*DimensionDxfParse(LAYER **layerlist);
extern	VOID	DimensionDefOutput(ENTITY *entity);
extern	VOID	DimensionNffOutput(ENTITY *entity);
extern	VOID	DimensionDxfOutput(ENTITY *entity);
extern	VOID	DimensionRadOutput(ENTITY *entity);

#else

/*
 * define some global functions
 */

extern	INT	atoi();
extern	VOID	exit();

/*
 * the following are general global functions
 */

/*
 * global functions defined in alloc.c
 */

extern	CHAR	*Alloc();

/*
 * global functions defined in block.c
 */

extern	BLOCK	*BlockDxfParse();
extern	BLOCK	*BlockSearch();
extern	VOID	BlockDefOutput();
extern	VOID	BlockNffOutput();
extern	VOID	BlockDxfOutput();
extern	VOID	BlockRadOutput();

/*
 * global functions defined in check.c
 */

extern	VOID	PlaneEquation();
extern	INT	CheckDirection();
extern	INT	CheckLayerName();
extern	VOID	ReversePolygon();
extern	INT	CheckOrientation();

/*
 * global functions defined in coord.c
 */

extern	VOID	CoordDxfParse();
extern	INT	CoordSame();
extern	VOID	CoordDxfOutput();
extern	FLOAT	CoordDistance();

/*
 * global functions defined in entity.c
 */

extern	INT	EntityType();
extern	ENTITY	*EntityDxfParse();

/*
 * global functions defined in error.c
 */

extern	ENTITY	*NullDxfParse();
extern	VOID	NullDefOutput();
extern	VOID	NullNffOutput();
extern	VOID	NullDxfOutput();
extern	VOID	NullRadOutput();

/*
 * global functions defined in group.c
 */

extern	INT	CmpGroupString();
extern	INT	CmpGroupInteger();

/*
 * global functions defined in layer.c
 */

extern	LAYER	*LayerInsert();
extern	VOID	EntityInsertToLayer();
extern	LAYER	*LayerDxfParse();

/*
 * global functions defined in main.c
 */

extern	VOID	PrintStatistics();
extern	VOID	Usage();
extern	VOID	main();

/*
 * global functions defined in matrix.c
 */

extern	VOID	MatrixUnit();
extern	VOID	MatrixRotate();
extern	VOID	MatrixTranslate();
extern	VOID	MatrixScale();
extern	VOID	MatrixExtrusion();
extern	VOID	MatrixMultiply();
extern	VOID	XformPoint();
extern	VOID	XformVector();
extern	VOID	MatrixPrint();

/*
 * global functions defined in name.c
 */

extern	CHAR	*NameInsert();
extern	VOID	NameDxfOutput();
extern	VOID	NameRadOutput();
extern	VOID	NameOutput();

/*
 * global functions defined in parse.c
 */

#if !defined(MSDOS) && !defined(vax) && !defined(VAX)
extern	VOID	VAX_INT_2_TO_IEEE_INT_2();
#endif
#if defined(vax) || defined(VAX)
extern	VOID	IEEE_FLOAT_8_TO_VAX_FLOAT_8();
#endif
extern	VOID	AsciiGetNextGroup();
extern	VOID	BinaryGetNextGroup();
extern	VOID	SkipSection();
extern	VOID	ParseBlocksSection();
extern	VOID	ParseEntitiesSection();
extern	VOID	SkipEndOfFile();
extern	VOID	ParseDxfFile();

/*
 * global functions defined in options.c
 */

extern	INT	OptionsDxfParse();
extern	INT	OptionsThickness();
extern	FLOAT	*OptionsExtrusion();
extern	INT	OptionsExtrusionVector();

/*
 * global functions defined in output.c
 */

extern	VOID	ResortEntities();
extern	VOID	OutputDxfPolygon();
extern	VOID	OutputPolygon();
extern	VOID	OutputNffPhongPolygon();
extern	VOID	OutputFile();

/*
 * global functions defined in stack.c
 */

extern	VOID	StackPush();
extern	VOID	StackPop();

/*
 * global functions defined in vector.c
 */

extern	FLOAT	VecNormalize();
extern	VOID	ArbitraryAxis();

/*
 * the following are global functions for handling entities
 */

/*
 * global functions defined in line.c
 */

extern	ENTITY	*LineDxfParse();
extern	VOID	LineDefOutput();

/*
 * global functions defined in point.c
 */

extern	ENTITY	*PointDxfParse();
extern	VOID	PointDefOutput();
extern	VOID	PointNffOutput();
extern	VOID	PointDxfOutput();
extern	VOID	PointRadOutput();

/*
 * global functions defined in circle.c
 */

extern	ENTITY	*CircleDxfParse();
extern	VOID	CircleTriangleTesselation();
extern	VOID	CircleRectangleTesselation();
extern	INT	CircleTesselationNumber();
extern	VOID	CircleDefOutput();
extern	VOID	CircleNffOutput();
extern	VOID	CircleRadOutput();

/*
 * global functions defined in arc.c
 */

extern	ENTITY	*ArcDxfParse();
extern	INT	ArcTesselationNumber();
extern	VOID	ArcDefOutput();

/*
 * global functions defined in trace.c
 */

extern	ENTITY	*TraceDxfParse();
extern	VOID	TraceDefOutput();

/*
 * global functions defined in solid.c
 */

extern	ENTITY	*SolidDxfParse();
extern	VOID	SolidDefOutput();

/*
 * global functions defined in text.c
 */

extern	ENTITY	*TextDxfParse();
extern	VOID	TextDefOutput();
extern	VOID	TextNffOutput();
extern	VOID	TextDxfOutput();
extern	VOID	TextRadOutput();

/*
 * global functions defined in shape.c
 */

extern	ENTITY	*ShapeDxfParse();
extern	VOID	ShapeDefOutput();
extern	VOID	ShapeNffOutput();
extern	VOID	ShapeDxfOutput();
extern	VOID	ShapeRadOutput();

/*
 * global functions defined in insert.c
 */

extern	ENTITY	*InsertDxfParse();
extern	VOID	InsertDefOutput();

/*
 * global functions defined in attrib.c
 */

extern	ATTRIB	*AttribDxfParse();

/*
 * global functions defined in polyline.c
 */

extern	ENTITY	*PolylineDxfParse();

extern	VOID	ArcCenterCalculation();
extern	VOID	PolylineDefOutput();

/*
 * global functions defined in vertex.c
 */

extern	VERTEX	*VertexDxfParse();

/*
 * global functions defined in face.c
 */

extern	ENTITY	*FaceDxfParse();
extern	INT	FaceDegeneratedCheck();
extern	VOID	FaceDefOutput();

/*
 * global functions defined in dimension.c
 */

extern	ENTITY	*DimensionDxfParse();
extern	VOID	DimensionDefOutput();
extern	VOID	DimensionNffOutput();
extern	VOID	DimensionDxfOutput();
extern	VOID	DimensionRadOutput();

#endif

#define	_FUNCTION
#endif
