#ifndef lint
static       char    rcsid[] = "$Header: error.c,v 1.2 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	error.c,v $
 * Revision 1.1  90/03/13  23:24:37  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"
#include "extern.h"

#ifdef	MSC

/*
 * for MSC, use function call instead for reducing code size
 */

/*
 * error during parsing a DXF file
 */

/*VARARGS1*/
VOID	DXFERR(fmt, arg)
CHAR	*fmt;
INT	arg;
{
	fprintf(stderr, "\n%s: DXF file %s", ProgName, DxfFileName);
	if (DxfAscOrBin == 0)
		fprintf(stderr, " at line %d - ", DxfFileLine);
	else
	if (DxfAscOrBin == 1)
		fprintf(stderr, " at byte %d - ", DxfFileByte);

	fprintf(stderr, fmt, arg);

	exit(-1);
}

/*
 * general error
 */

/*VARARGS1*/
VOID	GENERR(fmt, arg)
CHAR	*fmt;
INT	arg;
{
	/*
	 * if it's parsing a DXF file
	 */

	if (OutFile == NULL)
		fprintf(stderr, "\n%s: ", ProgName);
	else
		fprintf(stderr, "%s: ", ProgName);

	fprintf(stderr, fmt, arg);
	exit(-1);
}
#endif

/*
 * various routines to print error messages and die...
 */

ENTITY	*NullDxfParse()
{
	GENERR("called (*dxfparse)(), dying...%s", "\n");
	return(NULL);
}

VOID	NullDefOutput()
{
	GENERR("called (*defoutput(), dying...%s", "\n");
}

VOID	NullNffOutput()
{
	GENERR("called (*nffoutput(), dying...%s", "\n");
}

VOID	NullDxfOutput()
{
	GENERR("called (*dxfoutput(), dying...%s", "\n") ;
}

VOID	NullRadOutput()
{
	GENERR("called (*radoutput(), dying...%s", "\n") ;
}
