################################################################################
##  A procedure to get the primitives tree as list of lists                   ##  
##  LAST EDIT: Thu Aug  4 13:11:16 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

proc buildPrLst {} {
    set prList {}
    set prs [join [RT_primitives]]
    set list "" 
    foreach obj $prs {
	if {""==[$obj -get_father]} {
	    append list [ buildChildList $obj ]
	}
    }
    return $list
}
    
proc buildChildList {obj} {
    set children [$obj -get_children]
    set list " \{$obj \{ " 
    foreach cld $children {
	append list [ buildChildList $cld ]
    }
    append list " \} \}"
    return $list
}

proc buildPrTree {} {
    set prList {}
    set prs [lsort [RT_primitives]]
    set list "" 
    foreach obj $prs {
	append list [ buildChildTree $obj ]
    }
    return $list
}
    
proc buildChildTree {obj} {
    set children [lsort [$obj -get_children]]
    set list " $obj " 
    foreach cld $children {
	foreach el [ buildChildTree $cld ] {
	    append list " _$el"
	}
    }
    return $list
}

