################################################################################
##  An IOM class that encapsulates a YART pixmap.                             ##  
##  LAST EDIT: Thu Aug  4 10:46:59 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

Tcl_Object IOM_Pixmap {} {xPath } {Name Parent Options} {String String String} {Create a new Pixmap {ARG 1 Name} for the YART-Render, as Tk widget. The Pixmap is packed to {ARG 2 Parent} with the packer options {ARG 3 Options}.} {

    set parent $Parent
    if [string compare $Parent .] { set path $Parent.Name } { set path .$Name }
    set $THIS->xPath $path

    #build the basic frame widget
    frame $path -border 5

    frame $path.f 
    pack append $path $path.f {top fill expand}
    frame $path.f.f -border 3  -relief  sunken
    
    pack append $path.f $path.f.f {left fill expand}
    PixmapDisplay $path.f.f.px 200 200
 
    pack append $path.f.f $path.f.f.px {fill expand}

    #pack the basic frame widget
    pack append $parent $path $Options
}

Tcl_Method IOM_Pixmap  ~IOM_Pixmap {} {}  {Destroy the Pixmap} {
    destroy $[set THIS]->xPath
}


Tcl_Method IOM_Pixmap  -cursorOn {} {}  {Define some cursor bindings for the frame under the Pixmap} { 

    set path [set [set THIS]->xPath]
    catch "$path.f.f configure -cursor tcross"
    bind $path.f.f.px <ButtonPress-2>  "catch \"$path.f.f configure -cursor exchange\""
    bind $path.f.f.px <Shift-ButtonPress-2>  "catch \"$path.f.f configure -cursor box_spiral\""
    bind  $path.f.f.px <ButtonRelease-2>  "catch \"$path.f.f configure -cursor tcross\""
    bind  $path.f.f.px <Shift-ButtonRelease-2>  "catch \"$path.f.f configure -cursor tcross\""
    bind $path.f.f.px <ButtonPress-3>  "catch \"$path.f.f configure -cursor fleur\""
    bind $path.f.f.px <Shift-ButtonPress-3>  "catch \"$path.f.f configure -cursor double_arrow\""
    bind  $path.f.f.px <ButtonRelease-3>  "catch \"$path.f.f configure -cursor tcross\""
    bind  $path.f.f.px <Shift-ButtonRelease-3>  "catch \"$path.f.f configure -cursor tcross\""
    
    bind $path.f.f.px <Shift-ButtonPress-1>  "catch \"$path.f.f configure -cursor sizing\""
    bind  $path.f.f.px <Shift-ButtonRelease-1>  "catch \"$path.f.f configure -cursor tcross\""
}

Tcl_Method IOM_Pixmap  -cursorOff {} {}  {Undefine the cursor bindingings for the frame under the Pixmap} { 

    set path [set [set THIS]->xPath]

    catch "$path.f.f configure -cursor tcross"

    bind $path.f.f.px <ButtonPress-2>  ""
    bind $path.f.f.px <Shift-ButtonPress-2>  ""
    bind  $path.f.f.px <ButtonRelease-2>  ""
    bind  $path.f.f.px <Shift-ButtonRelease-2>  ""
    bind $path.f.f.px <ButtonPress-3>  ""
    bind $path.f.f.px <Shift-ButtonPress-3>  ""
    bind  $path.f.f.px <ButtonRelease-3>  ""
    bind  $path.f.f.px <Shift-ButtonRelease-3>  ""
    bind $path.f.f.px <Shift-ButtonPress-1>  ""
    bind  $path.f.f.px <Shift-ButtonRelease-1>  ""
}

IOM_Pixmap -keywords {Pixmap Userinterface}

IOM_Pixmap -description {Encapsulation of a YART pixmap in an IOM class.}


