//  LAST EDIT: Thu Mar  9 14:50:16 1995 by ekki(@prakinf.tu-ilmenau.de)

extern "C" {
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
}

#include "list.h"
#include "constr.h"
#include "error.h"


const char* DBN_VARIABLE = "Variable";
const char* DBN_CONSTRAINT = "Constraint";

DB_Variable::DB_Variable(char *_name, DB_Boolean c): name( _name ) {
    con = c;
    determinedBy = NULL;
    mark = 0;
    stay = TRUE;
    if ( c ) walkStrength = DBS_REQUIRED; // it's a constant
    else walkStrength = DBS_WEAKEST;  // it's a variable
    db_allVariables->add( this );
}

DB_Variable::~DB_Variable() {
    DB_Constraint* c;
    c = (DB_Constraint*)constraints.removeFirst();
    while (c) {
	delete c;
	c = (DB_Constraint*)constraints.removeFirst();
    }
    db_allVariables->remove( this);
}

void DB_Variable::removePropagateFrom(DB_List *list) {
    DB_Variable *v = this;
    delete db_todo2;
    db_todo2 = new DB_List;
    determinedBy = NULL;
    walkStrength = DBS_WEAKEST;
    stay = TRUE;

    class Functoid: public RT_GeneralListFunctoid {
	void exec(RT_GeneralListEntry *e, void *l) {
	    if ( e->isA( DBN_CONSTRAINT ))
		if (!((DB_Constraint*)e)->satisfied())
		    ((DB_List*)l)->add((DB_Constraint*)e);
	}
    } func;

    while (TRUE) {
	v->constraints.doWithElements( &func, list );
	DB_Constraint *nextC = v->nextDownstreamConstraint(db_todo2);
	if (!nextC) break; else {
	    nextC->recalculate();
	    v = DBM_OUT_VAR(nextC);
	}
    }
}

void DB_Variable::free() {
    DB_Constraint *c = (DB_Constraint*)constraints.removeFirst();
    while (c) {
	for (int i = c->varCount; i > 0; i--) 
	    c->variables[i-1]->constraints.remove(c);
	delete c;
	c = (DB_Constraint*)this->constraints.removeFirst();
    }
    delete this;
}

DB_Constraint *DB_Variable::nextDownstreamConstraint(DB_List *todo) {
    DB_Constraint *determiningC = determinedBy;
    DB_Constraint *first = NULL;

    RT_GeneralListElem* nextPtr = constraints.root;
    if (nextPtr) {
	do {
	    DB_Constraint *c = (DB_Constraint*)nextPtr->elem;
	    if ( (c != determiningC) && c->satisfied()) {
		if (!first) first = c ;
		else todo->add( c );
	    }
	}
	while( nextPtr = nextPtr->next);
    }

    if (!first) first = (DB_Constraint*) todo->removeFirst();
    return first;
}

void db_Error(const char *s) {
    // this function will be used in the following constructor
    // the compiler CC doesn't allow to use it inside the constructor
    rt_Output->error( s );
}

DB_Constraint::DB_Constraint(int variableCount, DB_Strength _strength) {
    if (variableCount > DBM_MAX_VAR) db_Error( "To much variables for constraint!" );
    inputFlag = FALSE;
    strength = _strength;
    whichMethod = DBM_NO_METHOD;
    methodCount = 0;
    for (int i = 0; i < DBM_MAX_VAR; i++) methodOuts[i] = 0;
    varCount = variableCount;
}

void DB_Constraint::print(FILE *f) const {
    int i, outIndex;
    fprintf( f, "%s: ", DBN_CONSTRAINT );
    if (!satisfied()) {
	fprintf( f, "Unsatisfied\n");
	for (i = 0; i < varCount; i++) variables[i]->print( f );
    } else {
	outIndex = methodOuts[whichMethod];
	fprintf( f, "Satisfied\n");
	for (i = 0; i < varCount; i++) 
	    if (i != outIndex) variables[i]->print( f );
	fprintf( f, "\n->\n");
	variables[outIndex]->print( f );
    }
}

void DB_Constraint::add() {
    for (int i = varCount; i > 0; i--) variables[i-1]->constraints.add(this);
    whichMethod = DBM_NO_METHOD;
    incrementalAdd();
}

int DB_Constraint::chooseMethod() {
    int bestOutStrength = strength;
    int best = DBM_NO_METHOD;
    for (int m = methodCount; m > 0; m--) {
	DB_Variable *mOut = variables[methodOuts[m-1]];
	if ((mOut->mark != db_currentMark) &&
	    (DBM_WEAKER(mOut->walkStrength, bestOutStrength))) {
	    best = m - 1;
	    bestOutStrength = mOut->walkStrength;
	}
    }
    return best;
}

DB_Constraint *DB_Constraint::satisfy() {
    whichMethod = chooseMethod();
    if (satisfied()) {
	// mark inputs to allow cycle detection in addPropagate 
	int outIndex = methodOuts[whichMethod];
	for (int i = varCount; i > 0; i--) 
	    if ((i-1) != outIndex) variables[i-1]->mark = db_currentMark;
	DB_Variable *out = variables[outIndex];
	DB_Constraint *overridden = out->determinedBy;
	if (overridden ) overridden->whichMethod = DBM_NO_METHOD;
	out->determinedBy = this;
	if (!addPropagate()) {
	    rt_Output->error( "Cycle encountered!" );
	    return NULL;
	}
	out->mark = db_currentMark;
	return overridden;
    } else {
	if (strength == DBS_REQUIRED) rt_Output->error( "Could not satisfy a required constraint!" );
	return NULL;
    }
}

DB_Boolean DB_Constraint::addPropagate() {
    delete db_todo1;
    db_todo1 = new DB_List;
    DB_Constraint *nextC = this;
    while (nextC) {
	DB_Variable *out = DBM_OUT_VAR(nextC);
	if (out->mark == db_currentMark) { 
	    // remove the cycle-causing constraint 
	    incrementalRemove();
	    return FALSE;
	}
	nextC->recalculate();
	nextC = out->nextDownstreamConstraint(db_todo1);
    }
    return TRUE;
}

void DB_Constraint::incrementalRemove() {
    DB_Variable *out = DBM_OUT_VAR(this);
    whichMethod = DBM_NO_METHOD;
    for (int i = varCount; i > 0; i--)  
	variables[i-1]->constraints.remove( this);
    DB_List *unsatisfied = new DB_List;
    out->removePropagateFrom(unsatisfied);

    class LFunctoid: public RT_GeneralListFunctoid {
	void exec( RT_GeneralListEntry *e,void* ) {
	    if ( e->isA( DBN_CONSTRAINT ))
		((DB_Constraint*)e)->incrementalAdd();
	}
    } func;

    i = 0;
    for (db_strength = db_Strengths[0]; db_strength <= DBS_WEAKEST; db_strength = db_Strengths[++i])
	unsatisfied->doWithElements( &func );
    delete unsatisfied;
}

DB_Constraint::~DB_Constraint() {
    if (satisfied()) incrementalRemove();
    for (int i = varCount; i > 0; i--) 
	variables[i-1]->constraints.remove(this);
}

void DB_Constraint::recalculate() {
    DB_Variable *out = DBM_OUT_VAR(this);
    out->walkStrength = outputWalkStrength();
    out->stay = constantOutput();
    if (out->stay) this->execute();
}

DB_Strength DB_Constraint::outputWalkStrength() {
    int mOutIndex;
    DB_Strength minStrength = strength;
    int outIndex = methodOuts[whichMethod];
    for (int m = methodCount; m > 0; m--) {
    	mOutIndex = methodOuts[m-1];
	if ((mOutIndex != outIndex) &&
	    (DBM_WEAKER(variables[mOutIndex]->walkStrength, minStrength))) {
	    minStrength = variables[mOutIndex]->walkStrength;
	}
    }
    return minStrength;
}

DB_Boolean DB_Constraint::constantOutput() {
    if (inputFlag) return FALSE;
    int outIndex = methodOuts[whichMethod];
    for (int i = varCount; i > 0; i--) {
	if ((i-1) != outIndex) {
	    if (!variables[i-1]->stay) return FALSE;
	}
    }
    return TRUE;
}

void DB_Constraint::incrementalAdd() {
    db_currentMark++; 
    DB_Constraint *overridden = satisfy();
    while (overridden) overridden = overridden->satisfy();
}

DB_List *DB_Constraint::extractPlanFromConstraint() {
    delete db_hot;
    db_hot = new DB_List;
    if (inputFlag && satisfied()) db_hot->add( this );
    return DB_List::makePlan();
}

DB_Boolean DB_Constraint::inputsKnown() {
    int outIndex = methodOuts[whichMethod];
    for (int i = varCount; i > 0; i--) {
	if ((i-1) != outIndex) {
	    DB_Variable *in = variables[i-1];
	    if ((in->mark != db_currentMark) && (!in->stay) && in->determinedBy )
		return FALSE;
	}
    }
    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////

char *DB_STRENGTH_NAMES[] = {
   "required", 
   "strongpreferred", 
   "preferred",
   "strongdefault",
   "default",
   "weakdefault",
   "weakdefault",
   "weakest",
   0
};

char *DB_strength2string(DB_Strength strength) {
    if (strength <= DBS_WEAKEST) return DB_STRENGTH_NAMES[strength];
    rt_Output->error( "Bad strength!" );
    return 0;
}

DB_Strength DB_string2strength(char *s) {
    int i = 0;
    DB_Strength st = db_Strengths[i];
    char *ss = s;
    while (*ss) {
	*ss = tolower(*ss);
	ss++;
    }
    char **tmp = DB_STRENGTH_NAMES;
    while (*tmp) {
	if (!strcmp(s, *tmp)) return st; 
	st = db_Strengths[++i];
	tmp++;
    }
    return (DB_Strength)-1;
}

