//  LAST EDIT: Mon Feb 14 01:12:32 1994 by ekki(@prakinf.tu-ilmenau.de)
#ifndef _Point_h_
#define _Point_h_

/*
 * Point.h - definition of class Point
 *
 * -----------------------------------------------------------------------------
 * Copyright 1993 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  Allan
 * Brighton make no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 * -----------------------------------------------------------------------------
 */

#include <iostream.h>

struct Point {
    short x, y;
    
    Point() : x(0), y(0) {}
    Point(int x_, int y_) : x(x_), y(y_) {}
    
    Point operator+(const Point &p) const { return Point(x+p.x, y+p.y); }
    Point operator-(const Point &p) const { return Point(x-p.x, y-p.y); }
    int operator==(const Point &p) const { return (x==p.x && y==p.y); }
    int operator!=(const Point &p) const { return (x!=p.x || y!=p.y); }
};

inline ostream& operator<<(ostream& os, const Point& p) { os << p.x << " " << p.y; return os;}

#endif 
