#ifndef __UTILS_H__
#define __UTILS_H__

////////////////////////////////////////////////////////////////////////////////
//  General utility functions like string conversions into non-object types,  //
//  transformations in fixed coordinate systems, etc.                         //  
//  LAST EDIT: Fri Aug  5 08:55:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifndef RTD_CPP_INCLUDES
}
#endif

#if defined(IRIX_5) || !defined(HAVE_SYS_SELECT_H)
extern "C" int select(int, fd_set*, fd_set*, fd_set*, struct timeval*);
#endif

#include "vector.h"
#include "color.h"
#include "facet.h"
#include "defines.h"

typedef enum { RTP_END, RTP_NONE, RTP_INTEGER, RTP_FLOAT, RTP_DOUBLE, RTP_STRING, RTP_SPECIAL, RTP_VECTOR, RTP_MATRIX, RTP_COLOR } RT_ParseType;

#define RTPS_NONE ""
#define RTPS_INTEGER "Integer"
#define RTPS_FLOAT "Float"
#define RTPS_DOUBLE "Double"
#define RTPS_STRING "String"
#define RTPS_VECTOR "Vector"
#define RTPS_MATRIX "Matrix"
#define RTPS_COLOR "Color" 
#define RTPS_SURFACE "Surface" 
#define RTPS_CLASS "Class"
#define RTPS_FILE "File"
#define RTPS_FACET "Facet"
#define RTPS_FONT "Font"

typedef struct {
    char *name;
    RT_ParseType type;
    char *ptr;
    int *flag;
    char *info;
    char *tcltypes;
} RT_ParseEntry;

int RT_findString(char **, const char *);

void RT_clearArgv( char**, int A, int N);
// remove N strings from A position (inclusive the A position)

void RT_parseTable(char **, RT_ParseEntry *);

// all utilities are returning 1 if successful:

int RT_getInt(char**, int&, int&);
int RT_getFloat(char**, float&, int&);
int RT_getDouble(char**, double&, int&);
int RT_getString(char**, char*&, int&);
int RT_getVector(char**, RT_Vector&, int&);
int RT_getSurface(char**, RT_Surface&, int&);
int RT_getColor(char**, RT_Color&, int&);
int RT_getMatrix(char**, RT_Matrix&, int&);
int RT_getFacet(char **, RT_Facet &, int&);

// S must be allocated before!
void RT_surface2string(const RT_Surface&, char *S);
void RT_color2string(const RT_Color&, char *S);
void RT_int2string(int, char *S);
void RT_double2string(double, char *S);
void RT_long2string(long, char *S);
void RT_float2string(float, char *S);
void RT_vector2string(const RT_Vector&, char *S);
void RT_bounds2string(const RT_Bounds&, char *S);
void RT_matrix2string(const RT_Matrix&, char *S);

int RT_string2float(const char*, float&);
int RT_string2double(const char*, double&);
int RT_string2int(const char*, int&);
int RT_strings2vector(const char**, RT_Vector&);

void RT_calcNorm( int, RT_Vector *points, RT_Vector &norm );

// transformations in fixed coordinates:

class RT_Primitive;
class RT_LookatCamera;

// rotate a primitiv around the axis in the initial coord system:
int RT_fixedCoordRot(RT_Primitive *, double, char );
int RT_fixedCoordRotCMD(ClientData, Tcl_Interp *, int, char *[]);

// translate a primitiv in the initial coord system:
int RT_fixedCoordTrans(RT_Primitive *, const RT_Vector&);
int RT_fixedCoordTransCMD(ClientData, Tcl_Interp *, int, char *[]);

// scale a primitiv in the initial coord system:
int RT_fixedCoordScale(RT_Primitive *, const RT_Vector&);
int RT_fixedCoordScaleCMD(ClientData, Tcl_Interp *, int, char *[]);

// rotate a primitiv around a point in the initial coord system:
int RT_fixedPointRot(RT_Primitive *, const RT_Vector&, const RT_Vector&, RT_LookatCamera *);
int RT_fixedPointRotCMD(ClientData, Tcl_Interp *, int, char *[]);

// some low-level intersection routines:
typedef int (*RT_ifunc_ptr)(const RT_Vector &, const RT_Vector &, const RT_Vector &);

int RT_intersect_xy(const RT_Vector &p, const RT_Vector &s, const RT_Vector &r);
int RT_intersect_xz(const RT_Vector &p, const RT_Vector &s, const RT_Vector &r);
int RT_intersect_yz(const RT_Vector &p, const RT_Vector &s, const RT_Vector &r);

#endif
