////////////////////////////////////////////////////////////////////////////////
//  A robot with a camera in its helmet.                                      //
//  LAST EDIT: Fri Aug  5 09:09:23 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

// robot utility classes:

class RT_RobotArm: public RT_Primitive {
    const char *get_class() const { return "<intern>"; }
    const char *get_description() const { return "!#$&"; }
    int left;
    // 0 means left arm - 1 means right arm
  public:
    RT_RobotArm(char *_name, int _l): RT_Primitive( _name), left( _l ) {
	RT_Primitive *p;
	(p = new RT_Sphere(0, 0.5))->father( this );
	(p =  new RT_Sphere(0, 0.45))->father( this );
	p->translate( RT_Vector( left ? -0.3 : 0.3, -0.4, 0.3 ));
	(p =  new RT_Sphere(0, 0.4))->father( this );
	p->translate( RT_Vector( left ? -0.4 : 0.4, -0.75, 0.7 ));
    }
};

class RT_RobotHead: public RT_Primitive {
    const char *get_class() const { return "<intern>"; }
    const char *get_description() const { return "!#$&"; }
  public:
    RT_RobotHead(char *_name): RT_Primitive( _name) {
	RT_Primitive *p;
	(p = new RT_Cylinder( 0, .99, 1 ))->father( this );
	p->translate( RT_Vector(0, 1.5, 0 ));
	p->rotate( RT_Vector(-1.583, 0, 0));
	
	(p = new RT_Quader( 0, 1.2, 0.5, 0.5))->father( this );
	p->translate( RT_Vector(0, 1.9, 0.8 ));
	p->diffuse( RT_Color( 0,0,0));

	(p = new RT_Quader( 0, 1, 0.3, 0.3))->father( this );
	p->translate( RT_Vector(0, 1.9, 1 ));
	p->diffuse( RT_Color( 0,0,0));
	p->specular( RT_Color( 1,1,1));

	(p = new RT_Sphere( 0, 1))->father( this );
	p->translate( RT_Vector(0, 2, 0 ));
    }
};

const char *RTN_ROBOT = "Robot";

class RT_Robot: public RT_Primitive {
    static RT_Vector ref, view;
    RT_LookatCamera *cam;
    RT_PixmapDisplay *dpy;
    int upd;
  public:
    RT_Robot(char *_name, RT_Scene *sc): RT_Primitive( _name) {
	upd = 0;
	diffuse( RT_Color(0.2, 0.5, 1));

	RT_Primitive *p;
	( p = new RT_Quader( 0, 2, 1, 2 ) )->father( this );
	p->translate( RT_Vector(0, 1, 0 ));

	( p = new RT_RobotHead( 0 ) )->father( this );
	
	(p = new RT_RobotArm(0, 1))->father( this );
	p->translate( RT_Vector(-1.1, 1, 0));

	(p = new RT_RobotArm(0, 0))->father( this );
	p->translate( RT_Vector(1.1, 1, 0));
	
	(p = new RT_Sphere(0, 1))->father( this );
	p->translate( RT_Vector(0.5, 0, 0.5));
	p->rotate( RT_Vector( 0.15, 0, 0));
	p->scale( RT_Vector(0.5,0.2,1.5));

	(p = new RT_Sphere(0, 1))->father( this );
	p->translate( RT_Vector(-0.5, 0, 0.5));
	p->rotate( RT_Vector( -0.15, 0, 0));
	p->scale( RT_Vector(0.5,0.2,1.5));

	dpy = new RT_PixmapDisplay( 0, 300, 100 );
	dpy->doublebuffer();

	cam = new RT_LookatCamera( 0, ref, view );
	cam->scene( sc ); cam->pixmap( dpy ); cam->znear( 1.5 ); cam->angle( 30 );
	this->matrixChanged(); // force an update

	sc->insert( this );
    }
    ~RT_Robot() { delete dpy; delete cam; }
    const char *get_class() const { return RTN_ROBOT; }
    const char *get_description() const { return "An implementation of a robot."; }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA( RTN_ROBOT, _c ); }
    void newMatrix() {
	if (!upd) {
	    upd = 1;
	    cam->refpoint( mc2wc( ref ));
	    cam->viewpoint( mc2wc( view ));
	    cam->rendering(); 
	    upd = 0;
	}
    }
};

RT_Vector RT_Robot::ref( 0, 0, 10), RT_Robot::view( 0, 1.5, 0 );

int main() {
    RT_init();
    rt_AttributeObject->fillstyle( 1 );

    RT_PixmapDisplay *display = new RT_PixmapDisplay( "display", 300, 300 );
    display->doublebuffer();

    RT_LookatCamera *cam = new RT_LookatCamera( "cam", RT_Vector( 5,5,10), RT_Vector( 0,0,0));
    cam->angle( 30 );
    
    RT_Scene *sc = new RT_Scene( "sc" );
    
    cam->pixmap( display ); cam->scene( sc );

    new RT_Robot( "robot", sc );
    
    RT_Primitive *cyl = new RT_Cylinder( "cyl", 0.1, 14);
    cyl->diffuse ( RT_Color(1,0,0));
    cyl->translate( RT_Vector(0,0, 2.5 ));
    cyl->rotate( RT_Vector(-1.57, 0, 0));
    sc->insert( cyl );

    RT_Quader *ground = new RT_Quader( "ground", 50, 0.1, 50 );
    ground->translate( RT_Vector( 0, -0.05, 0 ) );
    ground->specular( RT_Color( 1,1,1));
    sc->insert( ground );
    
    RT_Light *l1 = new RT_PointLight( "l1" );
    l1->color(RT_Color( 0.3,0.3,0.3 ));
    l1->origin( RT_Vector( 10, 0, 10 ));
    sc->insert( l1 );

    RT_Light *l2 = new RT_PointLight( "l2" );
    l2->color(RT_Color( 0.7,0.7,0.7));
    l2->origin( RT_Vector( -10, 0, 0 ));
    sc->insert( l2 );

    RT_Light *al = new RT_AmbientLight( "al" );
    al->color(RT_Color( 0.6,0.8,0.3 ));
    sc->insert( al );

    cam->rendering();

    RT_FileDevice *console = (RT_FileDevice *)RT_Object::getObject( "console" );
    console = new RT_FileDevice( "console", 0, 1 ); 
    console->addCB( new RT_ConsoleInputCB );
    
    rt_InputServer->loop();
}

