////////////////////////////////////////////////////////////////////////////////
//  YART interface to Tk and X11/VOGL.                                        //  
//  LAST EDIT: Mon Feb 20 17:59:05 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#define RTD_TK

#include "yart.h"
#include "fdither.h"
#include "vogl.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <tk.h>
#include <vodevice.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
    
#ifndef RTD_CPP_INCLUDES
}
#endif

extern "C" {
    int vo_xt_window(Display*, Window, int, int);
    void vo_xt_win_size(int, int);
}

Tk_Window rt_TkWin;

class RT_PixmapDisplayData {
  public:
    RT_PixmapDisplayData(RT_PixmapDisplay *, char *);
    ~RT_PixmapDisplayData();
    void putPixel(int, int, const RT_Color &);
    RT_Color getPixel(int, int);
    void eventProc(XEvent *);
    void configure();
    void reconfigure();
    static void staticEventProc(ClientData, XEvent *);
    
    RT_PixmapDisplay *px;
    Tk_Window tkwin;
    Window window;
    Display *display;

    int del; 
    // is 1 if the pixmap was already deleted (e.g. via Tcl command)

    int enter;
    int result;
    int mapped;
    GC gc;
    int depth;
    int resol;
    Pixmap pixmap;
};

RT_PixmapDisplayData::RT_PixmapDisplayData(RT_PixmapDisplay *_px, char *_name) {
    pixmap = None;
    gc = None;
    window = None;
    display = NULL;
    enter = 0;
    result = 0;
    mapped = 0;
    resol = 0;
    depth = 0;
    del = 0;
    
    px = _px;
    
    tkwin = Tk_CreateWindowFromPath(rt_Ip, rt_TkWin, _name, NULL);
    if (tkwin == NULL) {
	result = TCL_ERROR;
	return;
    }
    
    Tk_SetClass(tkwin, "TkPixmap");
    display = Tk_Display( tkwin );
    
    // support for common colormap - Don Libes, NIST
    if (!rt_Cmap) {
	int rIncr = 65536/rt_rMax;
	int gIncr = 65536/rt_gMax;
	int bIncr = 65536/rt_bMax;
	
	XColor color;
	int r, g, b;
	
	rt_Cmap = new int[ (rt_rMax+1) * (rt_gMax+1) * (rt_bMax+1)];

	for (r = 0, color.red = 0; r <= rt_rMax; r++, color.red += rIncr) {
	    // on last iteration, max it
	    if (r == rt_bMax) color.red = 65535;
	    for (g = 0, color.green = 0; g <= rt_gMax; g++, color.green += gIncr) {
		if (g == rt_gMax) color.green = 65535;
		for (b = 0, color.blue  = 0; b <= rt_bMax; b++, color.blue += bIncr) {
		    if (b == rt_bMax) color.blue = 65535;
		    
		    XAllocColor( display, DefaultColormap(display,DefaultScreen(display)),&color);
		    rt_Cmap[r * rt_rMult + g * rt_gMult + b * rt_bMult] = (int)color.pixel;
		}
	    }
	}
	
	// for efficient, precompute dither multiplier.
	// 64 is just the size of the dither table.
	rt_rDitherMultiplier = rt_rMax * 64;
	rt_gDitherMultiplier = rt_gMax * 64;
	rt_bDitherMultiplier = rt_bMax * 64;
    }
    
    Tk_CreateEventHandler(tkwin, ButtonPressMask | ButtonReleaseMask |
			  PointerMotionMask | ButtonMotionMask |
			  StructureNotifyMask | ExposureMask |
			  EnterWindowMask | LeaveWindowMask,
			  RT_PixmapDisplayData::staticEventProc,
			  (ClientData)this);
}

RT_PixmapDisplayData::~RT_PixmapDisplayData() {
    if (display != NULL) {
	if (pixmap != None)
	    XFreePixmap(display, pixmap);
	if (gc != None)
	    XFreeGC(display, gc);
    }
}

void RT_PixmapDisplayData::putPixel(int x, int y, const RT_Color &colr) {
    XSetForeground(display, gc, RT_ditherRGB(x, y, colr));
    if (mapped) XDrawPoint(display, window, gc, x, (px->h - 1 ) - y);
    XDrawPoint(display, pixmap, gc, x, (px->h - 1) - y);
    XFlush(display);
}

RT_Color RT_PixmapDisplayData::getPixel(int x, int y) {
    XColor col;
    XImage *img;
    
    img = XGetImage(display, window, x, (px->h - 1) - y,
		    1, 1, AllPlanes, XYPixmap);
    col.pixel = XGetPixel(img, 0, 0);
    XDestroyImage(img);
    XQueryColor(display, DefaultColormap(display,DefaultScreen(display)), &col);
    return (RT_Color(col.red/65535.0, col.green/65535.0, col.blue/65535.0));
}

void RT_PixmapDisplayData::eventProc(XEvent *eventPtr) {
    switch (eventPtr->type) {
      case DestroyNotify:
	if (!del) delete px;			
	px = NULL;
	break;
      case Expose: 
	  if (px->xcamera) px->xcamera->event( *new RT_UpdateEvent );
      	break;
      case EnterNotify:
	enter = 1;
	break;
      case LeaveNotify:
	enter = 0;
	break;
      case ButtonPress: {
	  XButtonEvent *evb = (XButtonEvent *)eventPtr;
	  RT_ButtonEvent *pev = new RT_ButtonEvent;
	  if (evb->button == Button1) pev->left = 1;
	  if (evb->button == Button2) pev->middle = 1;
	  if (evb->button == Button3) pev->right = 1;
	  if (evb->state & ShiftMask) pev->shift = 1;
	  if (evb->state & ControlMask) pev->ctrl = 1;
	  if (evb->state & Mod1Mask) pev->alt = 1;
	  pev->w = px->w;
	  pev->h = px->h;
	  pev->x = evb->x;
	  pev->y = px->h - evb->y;
	  if (px->xcamera) px->xcamera->event(*pev);
	  delete pev;
	  break;
      }
      case MotionNotify: {
	  XPointerMovedEvent *evm = (XPointerMovedEvent *)eventPtr;
	  RT_MotionEvent *pev = new RT_MotionEvent;
	  if (evm->state & Button1Mask) pev->left = 1;
	  if (evm->state & Button2Mask) pev->middle = 1;
	  if (evm->state & Button3Mask) pev->right = 1;
	  if (evm->state & ShiftMask) pev->shift = 1;
	  if (evm->state & ControlMask) pev->ctrl = 1;
	  if (evm->state & Mod1Mask) pev->alt = 1;
	  pev->w = px->w;
	  pev->h = px->h;
	  pev->x = evm->x;
	  pev->y = px->h - evm->y;
	  if (px->xcamera) px->xcamera->event(*pev);
	  delete pev;
	  break;
      }
      case MapNotify:
	mapped = 1;
	break;
      case UnmapNotify:
	mapped = 0;
	break;
      case ConfigureNotify:
	if (window == None) configure(); 
	else reconfigure();
	break;
    }
}

void RT_PixmapDisplayData::configure() {
    XSetWindowAttributes attr;
    
    px->w = Tk_Width(tkwin);
    px->h = Tk_Height(tkwin);
    
    if ((window = Tk_WindowId(tkwin)) == None) return;
    depth = Tk_Depth(tkwin);
    resol = 1 << depth;
    assert(resol >= 256);

    // after resizing contents of pixmap is lost. Make sure that the
    // same is true for window. 
    attr.bit_gravity = ForgetGravity;
    XChangeWindowAttributes(display, window, CWBitGravity, &attr);

    pixmap = XCreatePixmap(display, window, px->w, px->h, depth);
    gc = XCreateGC(display, window, 0, NULL);
    
    vo_xt_window( display, window, px->w, px->h );

    static int first = 0;
    if (!first) {
	ginit(); 
	gconfig();
	concave(1);
	doublebuffer();
	backface( 1 );
	first = 1;
    }

    XSetForeground(display, gc, 0);
    if (mapped) XFillRectangle(display, window, gc, 0, 0, px->w, px->h);
    XFillRectangle(display, pixmap, gc, 0, 0, px->w, px->h);
    
    RT_Color rt_col(0, 0, 0);
    px->clear(rt_col);
}

void RT_PixmapDisplayData::reconfigure() {
    px->w = Tk_Width(tkwin);
    px->h = Tk_Height(tkwin);

    vo_xt_win_size( px->w, px->h );
    reshapeviewport();

    XFreePixmap(display, pixmap);
    pixmap = XCreatePixmap(display, window, px->w, px->h, depth);
    XSetForeground(display, gc, 0);
    XFillRectangle(display, pixmap, gc, 0, 0, px->w, px->h);
    
}

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h)
: RT_Pixmap(_name, _w, _h) {
    data = new RT_PixmapDisplayData(this, _name);
    if (data->result == TCL_ERROR) return;
    if (w > 0 && h > 0) Tk_GeometryRequest(data->tkwin, w, h);
    sglBuf = 1;
}

RT_PixmapDisplay::~RT_PixmapDisplay() { data->del = 1; delete data; }

void RT_PixmapDisplay::event() {}

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    data->putPixel(x, y, colr);
}

RT_Color RT_PixmapDisplay::getPixel(int x, int y) {
    return (data->getPixel(x, y));
}

void RT_PixmapDisplayData::staticEventProc(ClientData cd, XEvent *eventPtr) {
    ((RT_PixmapDisplayData *)cd)->eventProc(eventPtr);
}

#include "vogl.C"

 
