#ifndef __FISHER_H__
#define __FISHER_H__

////////////////////////////////////////////////////////////////////////////////
//  These are the prototypes, globals, etc. of the X11 shading library.       //
//  NOTE: this X11 interface is very slow. It will be replaced later by a VOGL//
//  interface or what ever. In the meantime most platforms can use the OpenGL //
//  interface.                                                                // 
//  LAST EDIT: Fri Aug  5 14:43:08 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>
#include <values.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

#include "fhard.h"
#include "fconst.h"
#include "ftype.h"

extern mat4 E;         
// identity matrix

extern vct3 e_z;       
// identity vector in +z

extern vct3 me_z;      
// identity vector in -z

extern boolean FlipAreaEnabled; 
// flipping on/off

extern boolean WireFrame;

extern boolean TriFillEnable;
// false -> draw non-filled triangles with Gouraud shaded bounds

extern TShadingMeth ShadingMethod;    
// flat -> flat shading

extern surfacePropertyTyp surfaceProperty;
// the values of surfaceProperty can be changed via ChangeSurfaceProperty 

extern TClipMode ClipMode;
extern long VolClipCode;  
// Flag: where to clip

extern boolean ambLSdefined;   
// at least one ambient light?

extern rgb  ambLsC;           
// blending of all ambient lights

extern LsEntry *LsListRoot,*LsListEnd;
// ptr to first and last light

extern LsEntry *firstInf,*lastInf;  
// ptr to first and last DIRECTED light

extern LsEntry *firstPos, *lastPos;   
// ptr to first and last POINT light

extern LsEntry *firstSpt, *lastSpt; 
// ptr to first and last SPOT light

extern _MeshPntTyp *_WrkArr[MaxMeshPoints];   
// array for mesh

extern mat4 MC_WC, WC_NPC, MC_NPC, MC_DC, WC_MC, NPC_MC, NPC_DC, WC_DC;
extern double xwinsize, ywinsize;
extern int xwinofs, ywinofs;
extern boolean MatsChanged;
extern vct3 eyePoint;
extern TrafStackTyp *TrafStack;
extern TzBuffer *zBuffer[MaxScrPixelsY];

// pixmap geometry:
extern double rt_Aspect;
extern int rt_XMaxGlobal, rt_YMaxGlobal;

extern vct3 _VRP, _NRP, _VUP;
extern double _VPD, _FPD, _BPD, _xMin, _yMin, _xSize, _ySize, _lux, _luy,
	       _rox, _roy;
extern int _YSubU, _YSubO, _SpanMemSize;
extern uchar *MemTest[MaxMemTest];
extern long MeshSpace;

// #### fgraph.C #### 

void GraphInit(RT_Pixmap *_bitmap);
void GraphClose(void);
void GraphError (char *s);

//  #### fshad.C #### 

void PutPnt(SHD_VTX *p);
// draw a point after z buffer comparism (only when visible)

void line2d(double x1r, double y1r, double x2r, double y2r);

void SLine(SHD_VTX &p1, SHD_VTX &p2);
// draw a line with color interpolation and z buffer check
// the line must be clipped already!

void Span(boolean LtoR, int y, int x1, int x2, float z, const rgb &c,
	  float dz, const rgb &dc);
// draw a shaded horicontal line between x1 and x2 with height y.
// if LtoR == True interpolate from right, else left.
// starting values at x1 are z and c; increments are dz and dc.

void FillTria(const SHD_VTX &p1, const SHD_VTX &p2, const SHD_VTX &p3);
// draw a Gouraud shaded z buffered triangle.
// The triangle must lie completely in the topical window. But this
// is the case if it was clipped in the NPC.

//  #### fview.C #### 

boolean DoNorm(vct3 *v);
// normalize a vector v and return True if |v| < epsilon. 

void MulMat(double (*a)[4], double (*b)[4], double (*c)[4]);
// multiply 4x4 matrices: c:=a*b

void InvMat(double (*a)[4], double (*am1)[4]);
// invert a 4x4 matrix

/* Inversion einer 4*4-Matrix a. Vorgehen : Bildung der transponierten
   Adjunkten durch Unterdeterminaten und anschliessende Division der
   Elemente durch det(a). det(a) ist Skalarprodukt aus einem Zeilenvektor
   von a dem entsprechendem Spaltenvektor von Adj(a).  */

void SetViewing(vct3 VRP_, vct3 NRP_, vct3 VUP_,
                double xMin_, double yMin_, double xMax_, double yMax_,
                double VPD_, double FPD_,double	BPD_);
/*   Parameter:
     VRP: view refrence point (Ursprung der Bildschirmebene)
     NRP: normal reference point (Punkt in Betrachterrichtung)
     VUP: view up vector (Richtung "Oben" fuer den Betrachter)
     xMin,yMin: linke untere Ecke der Bildschirmebene ( = (0,0,z) im NPC)
     xMax,yMax: dto. rechts oben ( = (1,1,z) im NPC)
     VPD : view plane distance (Abstand des Betr. zur Bildschirmebene)
     FPD : front plane distance (Anfang des aktiven Bereichs vor der
              Bildschirmebene). Punkte, die im Abstand FPD vor der
              Bildschirmebene liegen, werden im NPC auf (x,y,1)
              abgebildet.
     BPD : back plane distance (Ende des aktiven Bereichs vor
              (bzw. hinter) der Bildschirmeben.  Punkte, die im Abstand
              FPD vor (bzw. hinter) der Bildschirmebene liegen,
              werden im NPC auf (x,y,0) abgebildet.
    Ergebnis ist die Matrix WC_NPC, die Punkte von der Welt in das VRC
    transformiert. */

void SetViewGlobal(vct3 VRP, vct3 NRP, vct3 VUP,
                   double xMin, double yMin, double xSize,
                   double VPD, double FPD, double BPD);
/* Im Gegensatz zu SetViewing werden in SetViewGlobal nur die
   linke untere Ecke der Bildschirmebene und die Breite des Bildschirms
   uebergeben. Die Hoehe ergibt sich aus dem Seitenverhaeltnis des
   Windows auf dem Bildschirm und dem Seitenverhaeltnis eines Pixels!

   Die Variablen werden in dieser Prozedur nur zwischengespeichert und
   dann in "DoLocalInit" beim Aufruf von SetViewing eingesetzt.
   In einem spaeteren Artickel wird die zu zeichnende Grafik aus
   mehreren Stuecken zusammengebaut (Speichermangel bei z-Buffering).
   Dann wird SetViewing fuer jeden Teil neu aufgerufen, SetViewGlobal
   aber nur einmal fuer das ganze Bild. Das gleiche gilt fuer
   SetScreen u. SetScreenGlobal. */

void SetScreen(double lux, double luy, double rox, double roy, boolean frame);
/* SetScreen berechnet die Screentransformationsmatrix, die das VRC auf
   das Bildschirm"kasten" mit den Koordinaten
   (x=lux,rox; y=luy,roy; z=0,maxint;) abbildet.
   Ist Frame TRUE, wird um diese Fenster ein Rahmen gezeichnet.  */

void SetScreenGlobal(double lux, double luy, double rox, double roy);
/* Erlaeuterung siehe SetViewGlobal.
   Erst an dieser Stelle ist die Hoehe der Bildschirmebene
   bekannt (_ySize). Die Funktion von _YSubU und _YSubO geben in einem
   der naechsten Kapitel die y-Grenzen des "Unterwindows" an.  */

boolean DoLocalInit(void);
/* ruft SetViewing und SetScreen auf.
   DoLocalInit wir spaeter fuer jedes Teilbild aufgerufen */

void Rotate(int achse, double w);
/* RotObj rotiert ein Objekt um die x (achse=1), y (achse=2) oder
   z (achse=3) Achse gegen den Uhrzeigersinn um w Grad. */

void Translate(double xv, double yv, double zv);
/* TransObj verschiebt ein Objekt um den Vektor (xv,yv,zv) */

void Scale(double scx, double scy, double scz);
/* ScaleObj skallier die Koordinaten eines Objektes in x-Richtung um scx,
   in y-Richtung um scy und in z-Richtung um scy */

void updateMats(void);
/* Wenn sich irgendwelche Matrizen veraendert haben, so werden an
   dieser Stelle die Matrizen MC_NPC, MC_DC, WC_MC und NPC_MC
   berechnet. */

void MCtoDC(vct3 a, double *x, double *y);
/* transformiert einen Punkt des Objektes (Modell Coordinates) direkt auf
   Bildschirmkoordinaten (Device Coordinates). Da die z-Koordinate bei
   dieser Transformation nicht mehr benoetigt wird, wird sie
   erst gar nicht berechnet
   uebergang affin->homogen , dann Objekt->Screen, dann homogen->affin */

void NPCtoDC(vct4 a, double *x, double *y);
/* NPCtoDC transformiert den homogenen Vektor a vom NPC auf
   Devicekoordinaten.
   Da diese Routine nur von CLine aufgerufen wird, die wiederum nur
   weisse, "flache" Linien zeichnet, wird die z-Koordinate nicht berechnet. */

void MCtoNPC(vct3 a, vct4 *as);
/* wird fuer Modellkoordinaten aufgerufen um im NPC clippen zu koennen.  /
   uebergang affin->homogen , dann Transformation */

void MCtoWC_vertex(vertex aMC, vertex *aWC);
/* wird fuer Punkte nach dem Clippen aufgerufen, um in der Welt das Lighting
   zu berechnen. (Erleuterungen zum Lighting im naechsten Artikel)
   Der Normalenvektor in der Welt wird in dieser Routine normiert. */

void MCtoDC3(vct3 a, SHD_VTX *ps);
/* transformiert einen Punkt des Objektes (Modell Coordinates) direkt auf
   Bildschirmkoordinaten (Device Coordinates) icl. z-Koordinate.  /
   uebergang affin->homogen , dann Objekt->Screen, dann homogen->affin */

void WCtoDC(vct3 a, long *x, long *y, long *z);
/* Transformation von affinen Koordinaten (Welt) auf Devicekoordinaten.
   Diese Routine wird fuer Punkte in einem Mesh nach dem Lighting aufgerufen,
   um diese in das DC abzubilden. Bis jetzt wurde dies durch die Routinen
   MCtoDC bzw. MCtoDC3 erledigt. Da aber nach dem Lighting nur noch
   die Weltkoordinaten der Objektkoordinaten bekannt sind (sie ueberschreiben
   die MC-Koordinaten), wird diese Routine noetig.

   Berechnungsschema:
     1) homogene Erweiterung (1,ax,ay,az)
	   2) Matrixmultiplikation
     3) Division durch homogene Komponente
     Achtung! Die Devicekoordinaten sind Integerwerte. */

void MCtoDCi(vct3 a, long *x, long *y);
/* Berechnet aus Modellkoordinaten Devicekoordinaten in Integer.
   Die z-Koordinate wird nicht beruecksichtigt. MCtoDCi wird von der
   Prozedur Mesh fuer Wireframes aufgerufen. */

/*---*/
void PushTrafs(void);
/* Rettet die aktuellen Transformationsmatrizen auf einen Stack, der
   als doppelt verkettete Liste ausgelegt ist */

void PopTrafs(void);
/* holt Matrizen vom Transformationsstack */

void CopyTrafs(void);


boolean FlipNormal(vertex *a);
/* Flippt Normale, wenn erlaubt, und gibt TRUE zurueck,
   wenn sichtbar */

//  #### fclip.C #### 

void Cline(vct4 a, vct4 b);
/* Cline zeichnet eine Linie von a nach b (homogene Koordinaten).
   a und b muessen in das NPC transformiert sein.
   Es wird in x,y,z-Richtung geclippt */

void PolyClip(int *PointCnt_, vertex *aPoints_);
/* PolyClip clippt ein Polygon mit PointCnt Punkten. Dabei sind die
   Punkte vom Typ vertex in Modellkoordinaten (d.h. icl.
   Normale und Farbe) gegeben. Zum Clippen werden die Koordinaten
   ins NPC transformiert. */

// #### flight.C #### 

void DoLight(vertex p, rgbB *c);
/* Belichtet den Punkt p, der in Weltkkordinaten vorligen muss
   (Normale normiert) und liefert als Ergebnis die Farbe c
   auf ColRange normiert.                                                  */

boolean LsNrExists(int nr, LsEntry **LsP);
/* liefert TRUE und pointer auf Lichtquelle mit dieser Nr. zurueck,
   falls sie existiert, sonst FALSE */

void addLs(int LsNr, boolean LsActive, LSType LsTyp,
           rgb LsC, float C1, float C2, float Le, float As,
           vct3 Ld, vct3 Lp);
/* Traegt eine Lichtquelle mit der Nr. LsNr und dem Typ LsTyp in Lichtquellen-
   liste ein und berechnet die ntigen Zwischenergebnisse. Informationen, die
   nicht benoetigt werden (z.B. die Lichtrichtung Ld bei Punkt-Lichtquellen)
   muessen zwar uebergeben werden, brauchen aber keine sinvollen Werte haben.
   Diese Routine dient nur zum internen Gebarauch. Besser ist es,die Routinen
   AddAmbLs,AddInfLs,AddPosLs und AddSptLs (siehe weiter unten) aufzurufen */

void addAmbLs(int Nr, boolean active, rgb Lc);
/* Traegt eine ambiente Lichtquelle mit Nummer Nr und Farbe Lc in die
   Lichtquellenliste ein. Ist active=TRUE, wird die Lq. bei der Lighting-
   berechnung beruecksichtigt.                                             */

void addInfLs(int Nr, boolean active, rgb Lc, float LdX, float LdY, float LdZ);
/* wie addAmbLs fuer gerichtete Lichtquellen. Zusaetzlich (LdX,LdY,LdZ) als
   Lichtrichtung */

void addPosLs(int Nr, boolean active, rgb Lc, float LpX, float LpY,
              float LpZ, float C1,  float C2);
  /* wie addInfLs fuer Punktlichtquellen. Hier wird nicht die Lichtrichtung
     sonder die Position der Lichtquelle (LpX,LpY,LpZ) angegeben. C1 und C2
     dienen zur Lichtschwaechung. ( Fuer C1=1 und C2=0 nimmt das Licht bei
     wachsender Entfernung nicht ab! )                                      */

void addSptLs(int Nr, boolean active,
              rgb Lc, float LdX, float Ldy, float LdZ, float LpX,
              float LpY, float LpZ, float C1, float C2, float Le, float As);
/* Traegt einen Strahler mit der Nummer Nr in die Lichtquellenliste ein.
   Bei active=TRUE wird dieser Strahler bei der Lightingberechnung berueck-
   sichtigt. Parameter:
   Lc:            Lichtquellenfarbe
   (LdX,LdY,LdZ): Bevorzugte Lichtrichtung
   (LpX,LpY,LpZ): Position des Strhlers
   C1,C2:         Koeffizienten fuer Lichtschwaechung (siehe addPosLs)
   Le:            Abklingexponent des Strahlers (0..ca.30)
   As:            Oeffnungswinkel des Lichtkegels in Grad (0..180)          */

void ClearLs(int nr);
/* Loescht die Lichtquelle mit der angegebenen Nummer aus der Lichtquellen-
   liste. Danach steht die Nummer fuer neue Lichtquelle zur Verfuegung.      */

void SwitchLs(int nr, boolean on);
/* Schaltet Lichtquelle mit Nummer nr aus (on=FALSE) bzw. an. Im Gegensatz
   zu ClearLs loescht SwitchLs die Lichtquelle bei not on nicht, sondern
   kettet sie nur aus der Liste der aktiven Lichtquellen aus. Die Lq.
   existiert weiter und kann wieder eingeschaltet werden.                   */

void ChangeSurfaceProperty(float NewKa, float NewKd, float NewKs,
                           rgb NewOs, float NewOe);
/* Setzt die Oberflaecheneigenschaften der Objekte, die anschliessend
   gezeichnet werden.
   Parameter:
     NewKa: ambienter Anteil der Reflexion  (0..1)
     NewKd: diffuser Anteil der Reflexion   (0..1)
     NewKs: spekularer Anteil der Reflexion (0..1)
     ( Die Summe aus Ka,Kd u. Ks sollte in etwa 1 betragen )
     NewOs: Farbe bei spekularer Reflexion
     NewOe: Spekularer Exponent             (1..ca.50)                     */

// #### fmesh.C ####

void InitMesh(void);
/* Speicher fuer Mesh besorgen     */

void InitXYMesh(int xs , int ys);

void DeleteXYMesh(int xs, int ys); // xsize not used 

void PutInMesh(long x, long y, vertex *p);
/* Punkt p in Mesh[x,y] speichern */

void CLineP(vct4 a, vct4 b);
/* Funktion siehe Cline
   Unterschied: Wenn ein Begrenzungsvolumen definiert ist, wird nur an den
   noetigen Begrenzungsflaechen geclippt. Vorteil: schneller als Cline       */

void DefineClipVolume(float xm, float ym, float zm);
/* Eckpunkte des Wuerfels [(-xm,xm);(-ym,ym);(-zm,zm)] als Begrenzungswuerfel
   fuer Mesh definiern.
   DefineClipVolume berechnet anhand des Wuerfels den Modus des Meshes
   (inside,outside,toClip). Vorgehen: Transformation der Eckpunkte des
   Umgebungswuerfels ins NPC und setzen der entsprechenden Bits in
   VolClipCode, wenn Punkt auszerhalb der der Begrenzungsflaechen des
   Einheitswuerfels. Wenn in der Variablen out nach dem Durchlauf der
   Schleife eines der unteren sechs Bit nicht(!) gesetzt ist, so bedeutet
   dies, dasz keiner der acht Eckpunkte des Umgebungsvolumens innerhalb des
   Einheitswuerfels (NPC) ist. ClipMode ist dann outside.                   */

void UnDefClipVolume(void);
  /* Dient zum Zuruecksetzen der Parameter fuer Umgebungsklippen und sollte
     beim Verlassen von Routinen aufgerufen werden, die mit DefineClipVolume
     einen Umgebungswuerfel definieren */

void Mesh(long nx, long ny);
/* Zeichnet ein Mesh mit nx*ny Punkten. Die Punkte muessen vorher mit
   PutInMesh definiert werden                                              */

#endif 
