////////////////////////////////////////////////////////////////////////////////
//  implementation of string class.                                           //  
//  LAST EDIT: Thu Dec  1 13:47:23 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <ctype.h>
#include <stdlib.h>
#include <assert.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

#include "strings.h"

RT_String::RT_String(const char *str) {	
    assert( str );
    size = 1 + strlen(str);
    val = new char[size]; 
    strcpy( val, str );
}

RT_String::RT_String(const RT_String &str) {	
    assert(str.size > strlen( str.val ));
    size = str.size;
    val = new char[size]; 
    strcpy( val, str.val );
}

char *RT_String::setValue(const char *newval) {
    int newsize = strlen(newval) + 1;
    if (newsize > size)  {
	size = newsize + newsize % 16;
	char *tmpval = val;
	val = new char[size];
	strcpy( val, tmpval );
	delete tmpval;
    }
    strcpy( val, newval );
    assert( size > strlen(val) );
    return val;
}

void RT_String::operator+=(char c) {	
    int newsize = strlen( val ) + 2;
    if ( newsize > size)  {
	size = newsize + newsize % 16;
	char *tmpval = val;
	val = new char[size];
	strcpy( val, tmpval );
	delete tmpval;
    }
    val[ newsize - 2 ] = c;
    val[ newsize - 1 ] = '\0';
    assert( size > strlen( val ) );
}

void RT_String::operator+=(const char *str) {
    char *tmp = 0;
    if ( str == val) {
	tmp = new char[ strlen( str) + 1 ];
	strcpy( tmp, str );
	str = tmp;
    }
    int newsize = strlen( str ) + strlen( val ) + 1;
    if ( newsize > size)  {
	size = newsize + newsize % 16;
	char *tmpval = val;
	val = new char[size];
	strcpy( val, tmpval );
	delete tmpval;
    }
    strcat( val, str );
    if ( tmp != 0) delete tmp;
    assert( size > strlen( val ) );
}

void RT_String::insert(const char* str, int pos) {
    if ( pos < 0 ) return;
    if ( pos >= strlen(val) ) {
	operator+=( str );
	return;
    }
    int newsize = strlen( val ) + strlen( str ) + 1;
    char *newval = new char[newsize];
    *newval = '\0';
    strncat( newval, val, pos);
    strcat( newval, str );
    strcat( newval, val + pos);
    delete val;
    size = newsize;
    val = newval;
    assert( size > strlen( val ) );
}

int RT_String::pos(const char* str) {
    char *st = strstr( val, str );
    if (!st) return -1;
    return st-val;
}

int RT_String::lastpos(const char* str) {
    int ret = length();
    while (ret >= 0) 
	if ( strstr( val + --ret, str ) != 0 ) return ret;
    return -1;
}

void RT_String::delWhite() {
    int pos;
    char *cp = val;
    for ( pos = 0; pos < strlen( val ); pos++, cp++ )
	if ( isspace( *cp ) )
	    strcpy( cp, cp + 1);
    assert( size > strlen(val) );
}

void RT_String::del(const char* str, int times) {
    int posi;
    for ( int i = 0; i < times; i++) {
	if (( posi = pos( str )) == -1) break;
	strcpy( val + posi, val + posi + strlen( str ));
    }
    assert( size > strlen( val ));
}

void RT_String::del(int from, int to) {
    if (from >= length())
	return;
    if(to >= length())
	to = length() - 1;
    strcpy( val + from, val + to + 1);
    assert( size > strlen( val ));
}

void RT_String::dellast(const char* str, int times) {
    int posi;
    for( int i = 0; i < times; i++) {
	if (( posi = lastpos( str )) == -1) break;
	strcpy( val + posi, val + posi + strlen( str ));
    }
    assert( size > strlen( val ));
}

void RT_String::replace(const char *s1, const char *s2, int times) {
    int posi;
    for( int i = 0; i < times; i++) {
	if (( posi = pos(s1)) == -1) break;
	del( s1 );
	insert( s2, posi );
    }
}

RT_String RT_String::operator+(const char *str) {
    int si = size + strlen( str );
    char *ret = new char[ si ];
    strcpy( ret, val);
    return RT_String( strcat( ret, str ));
}

RT_String RT_String::operator+(char c) {
    int si = size + 1;
    char *ret = new char[ si ];
    strcpy( ret, val );
    ret[ si - 1] = c;
    ret[ si ] = '\0';
    return RT_String( ret );
}

int RT_String::operator==(const RT_String& str) const { return !strcmp( val, str.val ); }

int RT_String::operator==(const char *str) const { return !strcmp(val, str); }

char &RT_String::operator[](int at) {
    assert( at >= 0 && at <= length());
    return val[ at ];
}

int RT_String::identical(const RT_String& op) { return op.val == val;}

int RT_String::compare(const RT_String& op) { return strcmp(val, op.val);}

RT_String RT_String::cdr( ) {
    char buf[128];
    int posi, lengthLeft;
 
    // copy the first word into the buffer
    sscanf(val,"%s",buf);
    // get the position of the first word
    posi =  pos(buf);
    // the length of the remainder of the string
    lengthLeft = length() - posi - strlen(buf);
    char *cp = val + posi + strlen(buf);
    while ( isspace(*cp++)) lengthLeft--;
    return RT_String ( val + strlen(val) - lengthLeft );
}
 
RT_String RT_String::car( ) {
    char buf[128];

    // copy the first word into the buffer
    sscanf(val,"%s",buf);
    return RT_String( buf );
}    

RT_String RT_String::substr(int from, int to) {
    RT_String str(*this);
    if (from>0) str.del(0, from-1);
    str.del(to+1, str.length()-1);
    return str;
}
