#ifndef __RS_LMMAT_H__
#define __RS_LMMAT_H__

////////////////////////////////////////////////////////////////////////////////
//           A Special matrix class for storage of coefficients.              //
//  LAST EDIT: Fri Aug  5 08:55:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rs_mvgen.h"
#include "rs_io.h"

// special matrix object, stores spherical harmonics coefficients
class RT_RS_lmMatrix : public RT_RS_MVGeneral, public RT_RS_IO
{
protected:
  float *fm;  // pointer to the lm Vector
  void alloch(int n, float cf, char atemp); //allocate heap memory
  void freeh(); // free heap memory
public:
  char *get_class() { return "RS_lmMatrix"; }

  //constructors
  RT_RS_lmMatrix(char *filename, FILE *fp = NULL);
  RT_RS_lmMatrix(int n, const float cf = .0, char atemp = 'n')
    { alloch(n, cf, atemp); }
  RT_RS_lmMatrix(RT_RS_lmMatrix& a);
  //destructor
  ~RT_RS_lmMatrix() { freeh(); }

  void set(float f = .0);
  float& operator () (int i, int j);  // range checked element

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read ASCII file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

#endif 

