////////////////////////////////////////////////////////////////////////////////
//  Definition of the base primitive Polyhedron.                              //  
//  LAST EDIT: Wed Mar  8 16:13:00 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __POLYHEDRON_H__
#define __POLYHEDRON_H__

#include "primitiv.h"
#include "vertex.h"
#include "facet.h"
#include <limits.h>

extern const char *RTN_POLYHEDRON;

class RT_Polyhedron: public RT_Primitive, public RT_FillstyleAttrImpl {
    RT_FillstyleAttribute *xfillstyle;
    static RT_ParseEntry table[]; 
    //##### statics for parameter parsing:
    static int getXF, getYF, cnF;
    //##### private data:

  protected:
    // for ray-tracing:
    RT_Vector *fnormals;
    double *fdist;
    RT_ifunc_ptr *ifunc;
    int *fvalid;
    RT_Vector *intersections;
    void create();

    int npoints, nfacets;
    RT_Vertex *vertices;
    RT_Facet *facets;    

    void checkAttributes() { 
	RT_Primitive::checkAttributes();
	if (xfillstyle->isChanged()) geomChanged(); 
    }
    void createReferences(const RT_AttributeList &list) {
	RT_Primitive::createReferences( list );
	// create fillstyle reference:
	RT_FillstyleAttribute *tmp = xfillstyle;
	xfillstyle = (RT_FillstyleAttribute*)list.retraverse( RTN_FILLSTYLE_ATTR, this );
	if (( tmp != xfillstyle) || (*tmp != *xfillstyle)) geomChanged();
    }

  public:
    RT_Vertex *get( int ) const; 
    // get vertex number ...
    RT_Vertex *get( int fnr, int pnr) const; 
    // get the vertex pnr from facet number fnr
    void newGeometry(int npoints, int nfacets);
    // clears the old arrays of points, surfaces, normals
    // and creates a new empty array
    void computeNormals();

    const RT_Facet &get_facet(int);

    //##### Tcl/C++ methods:
    RT_Polyhedron( char *, int npoints, int nfacets, RT_Facet *, RT_Vector *, RT_Surface * = 0, RT_Vector * = 0);
    virtual ~RT_Polyhedron();

    void printCon(FILE *) const ;
    const char *get_description() const { return "A polyhedron contains a vertex list and a list of connections (facets)."; }
    const char *get_class() const { return RTN_POLYHEDRON; }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_POLYHEDRON ); }

    int copy(RT_Primitive*) const;

    RT_Bounds get_bounds();

    int get_npoints() const { return npoints; }
    // return number of points
    int get_nfacets() const { return nfacets; }
    // return number of facets

    void appendPoints( int number, const RT_Vector *, const RT_Surface * = 0, const RT_Vector * = 0);
    // append points to the end of list
    void appendFacets( int number, const RT_Facet*);
    // append facets to the end of list

    void vtPoint(int, int, const RT_Vector&);
    // set point for vertex
    const RT_Vector &get_vtPoint(int, int) const;
    // get point

    void vtSurface(int nf, int np, const RT_Surface &s);
    // set surface for specified vertex
    const RT_Surface &get_vtSurface(int , int) const;
    // return surface of vertex- if vertex hasnt one return global
    void vtDeleteSurface(int, int);
    // delete surface at specified vertex

    void vtNormal(int, int, const RT_Vector &);
    // set normal for vertex
    const RT_Vector &get_vtNormal(int, int) const;
    // get normal of specified vertex
    // if vertex has not a normal - return object global normal
    void vtDeleteNormal( int, int );
    // clear normal

    //#### shader interface:
    void render();

    //#### raytracer interface:
    int intersect(const RT_Ray &, RT_InterSectionList&);
    void normal(const RT_Vector &, RT_Vector &);

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *argv[]);

    //#### interface of FILLSTYLE-attribute:
    void fillstyle(int s) {
	xfillstyle = (RT_FillstyleAttribute*)attributes->get( RTN_FILLSTYLE_ATTR );
	if (!xfillstyle) 
	    attributes->insert( xfillstyle = new RT_FillstyleAttribute );
	xfillstyle->fillstyle( s );
    }
    int get_fillstyle() const { return xfillstyle->get_fillstyle(); }
};

#endif

