////////////////////////////////////////////////////////////////////////////////
//  Pixmap and PixmapDisplay functions.                                       //  
//  LAST EDIT: Fri Aug  5 08:55:26 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "pixmap.h"
#include "camera.h"

// class Pixmap:
const char *RTN_PIXMAP = "Pixmap";

int RT_Pixmap::camG;

RT_ParseEntry RT_Pixmap::table[] = {
    { "-get_camera", RTP_NONE, 0, &camG, "Return the related camera", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Pixmap::objectCMD(char *argv[]) { 
    RT_parseTable( argv, table );
    if (camG) RT_Object::result( xcamera ? xcamera->get_name() : "" );
    return camG;
}

// class PixmapDisplay:

const char *RTN_PIXMAP_DISPLAY = "PixmapDisplay";
const char *RTSN_PD = "PD";

int RT_PixmapDisplay::sglF, RT_PixmapDisplay::dblF;

RT_ParseEntry RT_PixmapDisplay::table[] = {
    { "-singlebuffer", RTP_NONE, 0, &sglF, "Switch into singlebuffer mode.", RTPS_NONE },
    { "-doublebuffer", RTP_NONE, 0, &dblF, "Switch into doublebuffer mode.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_PixmapDisplay::objectCMD(char *argv[]) { 
    int ret = RT_Pixmap::objectCMD( argv );
    RT_parseTable( argv, table );
    if (sglF) singlebuffer();
    if (dblF) doublebuffer();
    return ret + sglF + dblF;
}

int RT_PixmapDisplay::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res = _classCMD( cd, ip, argc, argv );
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String Integer Integer} { Creates a new pixmap. {ARG 1 Name} of the new object, {ARG 2 Width}, {ARG 3 Height}. The short name is ", RTSN_PD, ".}}", 0 ); 
	return TCL_OK;
    }
    
    if (res == TCL_OK) {
	if (argc != 4) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <width> <height>. ", NULL );
	    return TCL_ERROR;
	}
	int w, h;
	if ( !RT_string2int( argv[2], w ) || !RT_string2int( argv[3], h )) {
	    Tcl_AppendResult( ip, "Bad parameters. <width> <height> must be integers. ", NULL );
	    return TCL_ERROR;
	}
	
	new RT_PixmapDisplay( argv[1], w, h ); 
	RTM_classReturn;
    }
    return res; 
}

int RT_Pixmap::checkIndices(int _x, int _y ) {
    if ( _x < 0 || _x >= getW() || _y < 0 || _y >= getH() ) {
	rt_Output->errorVar( get_name(), ": Indices out of area!", 0 );
	return 0;
    }
    return 1;
}

void RT_Pixmap::objectKilled(RT_Object *a) {
    if (a == xcamera) xcamera = 0;
    RT_Object::objectKilled( a );
}
