#ifndef __MATRIX_H__
#define __MATRIX_H__

////////////////////////////////////////////////////////////////////////////////
// A matrix class with a lot of utility member methdos.                       //  
//  LAST EDIT: Fri Aug  5 08:55:18 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "vector.h"

class RT_Matrix {
    double val[4][4];
  public:
    int changed;
    // this is a flag for optimization
    // if 0 -> matrix is unity matrix 

    RT_Matrix() { UNITY(); };

    void set(int i,int j, double d) {val[i][j]=d; changed = 1;} 
    double get(int i,int j) const {return val[i][j];} 

    // matrix operators:
    RT_Matrix operator + (const RT_Matrix &) const; 
    RT_Matrix operator - (const RT_Matrix &) const; 
    RT_Matrix operator * (const RT_Matrix &) const; 
    RT_Vector operator * (const RT_Vector &) const; 
    RT_Matrix operator * (const double &) const; 

    RT_Matrix INVERS() const; 
    RT_Matrix TRANSPOSE() const; 

    // Transformations:

    RT_Matrix SCALE_S(const double &d) const {
	RT_Matrix m = *this * d; 
	m.changed = 1;
	return m;
    }

    RT_Matrix INV_SCALE_S(const double &d) {
	RT_Matrix m = *this * -d; m.changed = 1; return m;
    }

    RT_Matrix SCALE(const RT_Vector &v) const {
	RT_Matrix m1,m2;
	m1.set(0,0, v.x);
	m1.set(1,1,v.y);
	m1.set(2,2,v.z);
	m2 = *this * m1;
	m2.changed = 1;
	return m2;
    }

    RT_Matrix INV_SCALE(const RT_Vector &v) const {
	RT_Matrix m1,m2;
	m1.set(0,0,1/v.x);
	m1.set(1,1,1/v.y);
	m1.set(2,2,1/v.z);
	m2 = m1 * *this;
	m2.changed = 1;
	return m2;
    }
	
    RT_Matrix TRANSLATION(const RT_Vector  &) const;
    RT_Matrix INV_TRANSLATION(const RT_Vector  &) const;

    RT_Matrix ROTATION_X(const double) const;
    RT_Matrix INV_ROTATION_X(const double) const;

    RT_Matrix ROTATION_Y(const double) const;
    RT_Matrix INV_ROTATION_Y(const double) const;

    RT_Matrix ROTATION_Z(const double) const;
    RT_Matrix INV_ROTATION_Z(const double) const;

    RT_Matrix ROTATION( const RT_Vector &v) const {
	RT_Matrix m1,m2;
	double sinx=sin(-v.x);
	double siny=sin(-v.y);
	double sinz=sin(-v.z);

	double cosx=cos(v.x);
	double cosy=cos(v.y);
	double cosz=cos(v.z);

	m1.val[0][0]=cosy*cosz;
	m1.val[0][1]=cosy*sinz;
	m1.val[0][2]=-siny;

	m1.val[1][0]=cosz*sinx*siny - cosx*sinz;
	m1.val[1][1]=cosx*cosz + sinx*siny*sinz;
	m1.val[1][2]=cosy*sinx;

	m1.val[2][0]=cosx*cosz*siny + sinx*sinz;
	m1.val[2][1]=-(cosz*sinx) + cosx*siny*sinz;
	m1.val[2][2]=cosx*cosy;

	m2 = *this * m1;
	m2.changed = 1;
	return m2;
    }

    RT_Matrix INV_ROTATION( const RT_Vector &v) const {
	RT_Matrix m1,m2;
	double sinx=sin(v.x);
	double siny=sin(v.y);
	double sinz=sin(v.z);

	double cosx=cos(v.x);
	double cosy=cos(v.y);
	double cosz=cos(v.z);

	m1.val[0][0]=cosy*cosz;
	m1.val[0][1]=cosz*sinx*siny + cosx*sinz;
	m1.val[0][2]=-(cosx*cosz*siny) + sinx*sinz;

	m1.val[1][0]=-(cosy*sinz);
	m1.val[1][1]=cosx*cosz - sinx*siny*sinz;
	m1.val[1][2]=cosz*sinx + cosx*siny*sinz;

	m1.val[2][0]=siny;
	m1.val[2][1]=-(cosy*sinx);
	m1.val[2][2]=cosx*cosy;

	m2 = m1 * *this;
	m2.changed = 1;
	return m2;
    }

    void get(float f[4][4]) {
	for (int i = 0; i < 4; i++)
	    for (int j = 0; j < 4; j++)
		f[i][j] = val[i][j];
    }

    // print the matrix:
    void print(FILE *f, char *n = 0) const {
	fprintf( f, "%s{ %lf %f %lf %lf ", n ? n : "", val[0][0], val[0][1], val[0][2], val[0][3]); 
	fprintf( f, "%lf %lf %lf %lf ", val[1][0], val[1][1], val[1][2], val[1][3]); 
	fprintf( f, "%lf %lf %lf %lf ", val[2][0], val[2][1], val[2][2], val[2][3]); 
	fprintf( f, "%lf %lf %lf %lf } ", val[3][0], val[3][1], val[3][2], val[3][3]); 
    }

    void UNITY() {
	changed = 0;
	val[0][1] = val[0][2] = val[0][3] =
	    val[1][0] = val[1][2] = val[1][3] = 
		val[2][0] = val[2][1] = val[2][3] =
		    val[3][0] = val[3][1] = val[3][2] = 0;
	val[0][0] = val[1][1] = val[2][2] = val[3][3] = 1;
    }
};

// the modelling matrices for a primitive
// internally !six! instances of RT_Matrix will be used
// but this can be changed in a future version
// it is important that the interfaces will be constant

class RT_Modelling {
    RT_Matrix mat, imat; // the local matrizes
    RT_Matrix gmat, igmat; // the global matrizes
    RT_Matrix tmat, itmat; // the concatenation of local and global

    void update() {
	tmat = gmat * mat;
	itmat = tmat.INVERS();
    }
  public:
    // vertex transformations:
    RT_Vector mc2wc(const RT_Vector &a) const  { return tmat * a; }
    RT_Vector wc2mc(const RT_Vector &a) const { return itmat * a; }

    // acess to the matrices:
    const RT_Matrix &get_concatMatrix() const { return tmat; }
    const RT_Matrix &get_invConcatMatrix() const { return itmat; }
    const RT_Matrix &get_globalMatrix() const { return gmat; }
    const RT_Matrix &get_invGlobalMatrix() const { return igmat; }

    // modelling transformations:
    void matrix(const RT_Matrix &m) {
	mat = m;
	imat = m.INVERS();
	update();
    }
    const RT_Matrix &get_matrix() const { return mat; }
    void rotate( const RT_Vector &x) {
	mat = mat.ROTATION( x );
	imat = imat.INV_ROTATION( x );
	update();
    }
    void scale( const RT_Vector &x) {
	mat = mat.SCALE( x );
	imat = imat.INV_SCALE( x );
	update();
    }
    void translate( const RT_Vector &x) {
	mat = mat.TRANSLATION( x );
	imat = imat.INV_TRANSLATION( x );
	update();
    }

    // concat with a new father object
    
    // currently: overwriting the global matrices
    void concat(RT_Modelling *m) {
	gmat = m->tmat;
	igmat = m->itmat;
	update();
    }
};

extern const RT_Modelling rt_Modelling; 
// the default modelling for a primitive

#endif


