#ifndef __PICK_H__
#define __PICK_H__

////////////////////////////////////////////////////////////////////////////////
//  Sample Implementation of a pick device.                                   //  
//  LAST EDIT: Tue Aug  9 07:46:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////


#include "device.h"

extern const char *RTN_PICK;

class RT_Pick: public RT_InputDevice {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int primG;
    RT_Primitive *xprim;
  public:
    void event( RT_Event*);

    void objectKilled(RT_Object *o) {
	if ( o == xprim) xprim = 0;
	RT_InputDevice::objectKilled( o );
    }

    //#### Tcl/C++ methods:
    RT_Pick(char *_name): RT_InputDevice(_name) { xprim = 0; } 
    ~RT_Pick() { if (xprim)  xprim->removeRelatedObject( this ); }

    const char *get_description() const {  return "A pick object can be used for selecting objects via a mouse click."; }
    const char *get_class() const { return RTN_PICK; } 
    int isA(const char *c) const { return RT_InputDevice::isA( c ) || RTM_isA( RTN_PICK, c ); }
    RT_Primitive *get_pickedObject() {return xprim;}

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD(char *[]);
};

#endif





