////////////////////////////////////////////////////////////////////////////////
//  Implementation of file device class.                                      //  
//  LAST EDIT: Fri Aug  5 09:23:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "filedev.h"
#include "../camera.h"

const char *RTN_FILE_DEVICE = "FileDevice";

int RT_FileDevice::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String Integer Integer} {Creates a {ARG 1 Device} object. Other args are {ARG 2 Descriptor} and {ARG 3 Accessmask}. The access mask is created by union of three values: 1 for Readable File, 2 for Writable File and 4 for Exception.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 4) {
	    Tcl_AppendResult( ip, argv[0], ": need arguments: <name> <descriptor> <mask>.", 0 );
	    return TCL_ERROR;
	}
	int xfd, xmode;
	if (RT_string2int(argv[2], xfd ) && RT_string2int(argv[3], xmode )) {
	    new RT_FileDevice( argv[1], xfd, xmode ); 
	    RTM_classReturn;
	}
	Tcl_AppendResult( ip, argv[0], ": bad arguments!.", 0 );
	return TCL_ERROR;
    }
    return res; 
}

void RT_FileDevice::event(RT_Event *) {
    static fd_set rfds, wfds, efds;
    FD_ZERO( &rfds ); if (mode & 1) FD_SET( fd, &rfds );
    FD_ZERO( &wfds ); if (mode & 2) FD_SET( fd, &wfds );
    FD_ZERO( &efds ); if (mode & 4) FD_SET( fd, &efds );
    if ( select( FD_SETSIZE, &rfds, &wfds, &efds, &wait ) > 0 ) {
	xtime = (RT_Time)::time( 0 );
	callCBs();
    } 
}

int RT_FileDevice::objectCMD(char *argv[]) { 
    int ret = RT_InputDevice::objectCMD( argv );
    RT_parseTable( argv, table );
    if (usF) micro( usV );
    if (scF) second( scV );
    if (usG) {
	char tmp[20]; ret++;
	RT_int2string( get_micro(), tmp );
	RT_Object::result( tmp );
    }
    if (scG) {
	char tmp[20]; ret++;
	RT_int2string( get_second(), tmp );
	RT_Object::result( tmp );
    }
    return ret + usF + scF;
}

RT_ParseEntry RT_FileDevice::table[] = {
    {"-second", RTP_INTEGER, (char*)&scV, &scF, "Set the {ARG 1 Second} value of the time out.", "INTEGER"},
    {"-get_second", RTP_INTEGER, 0, &scG, "Get the seconds of the time out.", ""},
    {"-micro", RTP_INTEGER, (char*)&usV, &usF, "Set the {ARG 1 Micro} seconds of the time out.", "INTEGER"},
    {"-get_micro", RTP_INTEGER, 0, &usG, "Get the micro seconds of the time out.", ""},
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_FileDevice::usF, RT_FileDevice::usG, RT_FileDevice::usV;
int RT_FileDevice::scF, RT_FileDevice::scG, RT_FileDevice::scV;





