//////////////////////////////////////////////////////////////////////////////// 
//  Implementation of some mappings                                           //  
//  LAST EDIT: Tue Aug 16 14:11:42 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "surface.h"
#include "usefmapp.h"
#include "primitiv.h"

const char *RTN_MAPPING = "Mapping";

// texture global stuff:

void rt_initMappingCommands(Tcl_Interp *) {
    RTM_command( RTN_IMAGE_MAPPING, RT_ImageMapping::classCMD );
    RTM_command( RTN_TEXTURE_MAPPING, RT_TextureMapping::classCMD );
    RTM_command( RTN_COMPOSITE_TEXTURE_MAPPING, RT_CompositeTextureMapping::classCMD );
    RTM_command( RTSN_CTM, RT_CompositeTextureMapping::classCMD );
    RTM_command( RTN_WORLD_TEXTURE_MAPPING, RT_WorldTextureMapping::classCMD );
    RTM_command( RTSN_WTM, RT_WorldTextureMapping::classCMD );
}

//  ImageMapping:

const char *RTN_IMAGE_MAPPING = "ImageMapping";

int RT_ImageMapping::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a new mapping using an image object. The created object is named {ARG 1 Name}.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_ImageMapping( argv[1]);
	RTM_classReturn;
    } 
    return res;
}

void RT_ImageMapping::smapping( const RT_Primitive *p, const RT_Vector &wc, RT_Surface &s) {
    if (ximage ) {
	RT_Point po = p->inverse( p->wc2mc( wc ));
	if (( 0.0 <= po.x) && (po.x <= 1.0))
	    if (( 0.0 <= po.y) && (po.y <= 1.0)) {
		s.diff = ximage->get_icolor( po.x, po.y );
		s.ambi = s.diff; 
	    }
    }
}

int RT_ImageMapping::imF, RT_ImageMapping::imG; 
char *RT_ImageMapping::imV;

RT_ParseEntry RT_ImageMapping::table[] = {
    { "-image", RTP_STRING, (char*)&imV, &imF, "Specify the {ARG 1 Image} file.", "Image" },
    { "-get_image", RTP_NONE, 0, &imG, "Return the current image.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_ImageMapping::objectCMD(char *argv[]) {
    int ret = RT_Mapping::objectCMD( argv );
    RT_parseTable( argv, table );
    if (imF) {
	if (!strcmp(  imV, "" )) {
	    image( 0 ); ret++;
	}
	else {
	    RT_Object *obj = RT_Object::getObject( imV );
	    if (obj && obj->isA( RTN_IMAGE )) { image( (RT_Image*)obj ); ret++; }
	    else rt_Output->errorVar( get_name(), ": No such image object: ", imV, "! ", NULL );
	}
    }
    if (imG) RT_Object::result( get_image() ?  get_image()->get_name() : "" );
    return ret + imG;
}

//  TextureMapping:

const char *RTN_TEXTURE_MAPPING = "TextureMapping";

int RT_TextureMapping::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a new texture mapping {ARG 1 Object}. A concrete 3D texture must be assigned afterwards.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_TextureMapping( argv[1]);
	RTM_classReturn;
    } 
    return res;
}

void RT_TextureMapping::smapping( const RT_Primitive *p, const RT_Vector &wc, RT_Surface &s) {
    if (xtext && xtext->getSampleMode() != RTE_NO_SAMPLE ) { 
	RT_Color sc = xtext->getSample( p->wc2mc( wc ) );
	switch (xtext->getSampleMode()) {
	  case RTE_REPLACE_SAMPLE:
	    s.ambi = sc; s.diff = sc; 
	    break;
	  case RTE_ADD_SAMPLE:
	    s.ambi = s.ambi + sc; s.ambi.correct();
	    s.diff = s.diff + sc; s.diff.correct();
	    break;
	  case RTE_MUL_SAMPLE:
	    s.ambi = s.ambi * sc;
	    s.diff = s.diff * sc;
	    break;
	};
    }
}

void RT_TextureMapping::nmapping( const RT_Primitive *p, const RT_Vector &wc, RT_Vector &n) {
    if (xtext && xtext->getNormalMode() != RTE_NO_NORMAL) {
	RT_Vector no = xtext->getNormal( p->wc2mc( wc ) );
	switch (xtext->getNormalMode()) {
	  case RTE_REPLACE_NORMAL:
	    n = no.UNITIZE();
	    break;
	  case RTE_ADD_NORMAL:
	    n = (n + no).UNITIZE();
	    break;
	}
    }
}

int RT_TextureMapping::txF, RT_TextureMapping::txG; 
char *RT_TextureMapping::txV;

RT_ParseEntry RT_TextureMapping::table[] = {
    { "-texture", RTP_STRING, (char*)&txV, &txF, "Specify the {ARG 1 Texture} object.", "Texture" },
    { "-get_texture", RTP_NONE, 0, &txG, "Return the current texture.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_TextureMapping::objectCMD(char *argv[]) {
    int ret = RT_Mapping::objectCMD( argv );
    RT_parseTable( argv, table );
    if (txF) {
	if (!strcmp(  txV, "" )) { texture( 0 ); ret++; }
	else {
	    RT_Object *obj = RT_Object::getObject( txV );
	    if (obj && obj->isA( RTN_TEXTURE_3D )) {
		texture( (RT_Texture3D*)obj ); ret++;
	    }
	    else rt_Output->errorVar( get_name(), ": No such texture object: ", txV, "! ", 0 );
	}
    }
    if (txG) RT_Object::result( get_texture() ?  get_texture()->get_name() : "" );
    return ret + txG;
}

void RT_TextureMapping::texture( RT_Texture3D *txt) {
    if (xtext) {
	if ((long)txt == -1) txt = 0;
	else xtext->removeRelatedObject( this );
    }
    xtext = txt; 
    if (xtext) {
	addRelatedObject( xtext );
	xtext->addRelatedObject( this );
    }
} 

//  CompositeTextureMapping:

const char *RTN_COMPOSITE_TEXTURE_MAPPING = "CompositeTextureMapping";
const char *RTSN_CTM = "CTM";

int RT_CompositeTextureMapping::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a new texture mapping {ARG 1 Object}. A concrete 3D texture must be assigned afterwards. The short name is CTM.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_CompositeTextureMapping( argv[1]);
	RTM_classReturn;
    } 
    return res;
}

void RT_CompositeTextureMapping::smapping( const RT_Primitive *p, const RT_Vector &wc, RT_Surface &s) {
    if (xtext && xtext->getSampleMode() != RTE_NO_SAMPLE ) { 
	while (p->isPart && p->get_father()) p = p->get_father();
	RT_Color sc = xtext->getSample( p->wc2mc( wc ) );
	switch (xtext->getSampleMode()) {
	  case RTE_REPLACE_SAMPLE:
	    s.ambi = sc; s.diff = sc; 
	    break;
	  case RTE_ADD_SAMPLE:
	    s.ambi = s.ambi + sc; s.ambi.correct();
	    s.diff = s.diff + sc; s.diff.correct();
	    break;
	  case RTE_MUL_SAMPLE:
	    s.ambi = s.ambi * sc;
	    s.diff = s.diff * sc;
	    break;
	};
    }
}

void RT_CompositeTextureMapping::nmapping( const RT_Primitive *p, const RT_Vector &wc, RT_Vector &n) {
    if (xtext && xtext->getNormalMode() != RTE_NO_NORMAL) {
	while (p->isPart && p->get_father()) p = p->get_father();
	RT_Vector no = xtext->getNormal( p->wc2mc( wc ) );
	switch (xtext->getNormalMode()) {
	  case RTE_REPLACE_NORMAL:
	    n = no.UNITIZE();
	    break;
	  case RTE_ADD_NORMAL:
	    n = (n + no).UNITIZE();
	    break;
	}
    }
}

//  WorldTextureMapping:

const char *RTN_WORLD_TEXTURE_MAPPING = "WorldTextureMapping";
const char *RTSN_WTM = "WTM";

int RT_WorldTextureMapping::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a new texture mapping {ARG 1 Object}. A concrete 3D texture must be assigned afterwards. The short name is WTM.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_WorldTextureMapping( argv[1]);
	RTM_classReturn;
    } 
    return res;
}

void RT_WorldTextureMapping::smapping( const RT_Primitive *, const RT_Vector &wc, RT_Surface &s) {
    if (xtext && xtext->getSampleMode() != RTE_NO_SAMPLE ) { 
	RT_Color sc = xtext->getSample( wc );
	switch (xtext->getSampleMode()) {
	  case RTE_REPLACE_SAMPLE:
	    s.ambi = sc; s.diff = sc; 
	    break;
	  case RTE_ADD_SAMPLE:
	    s.ambi = s.ambi + sc; s.ambi.correct();
	    s.diff = s.diff + sc; s.diff.correct();
	    break;
	  case RTE_MUL_SAMPLE:
	    s.ambi = s.ambi * sc;
	    s.diff = s.diff * sc;
	    break;
	};
    }
}

void RT_WorldTextureMapping::nmapping( const RT_Primitive *, const RT_Vector &wc, RT_Vector &n) {
    if (xtext && xtext->getNormalMode() != RTE_NO_NORMAL) {
	RT_Vector no = xtext->getNormal( wc );
	switch (xtext->getNormalMode()) {
	  case RTE_REPLACE_NORMAL:
	    n = no.UNITIZE();
	    break;
	  case RTE_ADD_NORMAL:
	    n = (n + no).UNITIZE();
	    break;
	}
    }
}

