////////////////////////////////////////////////////////////////////////////////
//  definition of rotation surface                                            //  
//  LAST EDIT: Wed Mar  8 13:43:07 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __ROTFORMS_H__
#define __ROTFORMS_H__

#include "curves.h"
#include "forms.h"

extern const char *RTN_ROTATION_SURFACE;

class RT_RotationSurface: public RT_Polyvertex, public RT_ResolutionAttrImpl {
    RT_ResolutionAttribute *xsolution;

    // create a b-spline surface of revolution:
    void create();
    
    // parameter parsing:
    static int getOrdF, modeF, modeV, getModeF; 
    static RT_ParseEntry table[];
    
    RT_SplineSurface *xssurface;
  public:
    //#### the Tcl/C++ methods:
    RT_RotationSurface( char*, int, RT_Vector*, RT_Surface*, RT_Vector*);  
    int copy( RT_Primitive* ) const;
    
    RT_Bounds get_bounds() { return( RT_Primitive::get_bounds() ); }

    const char *get_description() const { return "An editable surface of revolution"; }
    const char *get_class() const { return RTN_ROTATION_SURFACE; }
    int isA(const char * _c) const { 
	return RT_Polyvertex::isA( _c ) || RTM_isA(_c, RTN_ROTATION_SURFACE ); 
    }

    //#### interface of Resolution:
    void resolution(double); 
    double get_resolution() const { return xsolution->get_resolution(); }

    //#### generic primitive methods:
    void checkAttributes() {
	RT_Polyvertex::checkAttributes();
	if (xsolution->isChanged()) geomChanged(); 
    }
    void createReferences(const RT_AttributeList &);
    
    //#### the Tcl commands:
    static int classCMD( ClientData, Tcl_Interp *, int, char *[] );
    int objectCMD( char *[] );
};

#endif
