////////////////////////////////////////////////////////////////////////////////
//  Definitions of classes for reading OFF data sets.                         //  
//  LAST EDIT: Wed Mar  8 14:38:39 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////
 
#ifndef __OFF_H__
#define __OFF_H__

#include "../primitiv.h"
#include "../quadmesh.h"

extern const char *RTN_OFF_POLYGON;

class RT_OFFPolygon: public RT_Primitive {
    RT_String file;
  public:
    //#### the Tcl/C++ methods:
    RT_OFFPolygon(char *, char *);
    const char *get_class() const { return RTN_OFF_POLYGON;}
    const char *get_description() const { return "A polygon set created from standard OFF files. OFF file archives are available on many ftp sites."; }
    void printCon(FILE *f) const { 
	RT_Primitive::printCon( f ); 
	fprintf( f, "%s ", (char*)file );
    }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_OFF_POLYGON ); }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_OFF_QUADMESH;

class RT_OFFQuadmesh: public RT_Quadmesh {
    RT_String file;
  public:
    //#### the Tcl/C++ methods:
    RT_OFFQuadmesh(char *, char *);
    const char *get_class() const { return  RTN_OFF_QUADMESH;}
    const char *get_description() const { return "A quadmesh created from a OFF-like file."; }
    void printCon(FILE *f) const { 
	RT_Quadmesh::printCon( f );
	fprintf( f, "%s ", (char*)file );
    }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_OFF_QUADMESH ); }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
};
                                                             
#endif
