#ifndef __FONT_H__
#define __FONT_H__

////////////////////////////////////////////////////////////////////////////////
//  A class for a text font in a YART specific formate.                       //  
//  LAST EDIT: Mon Nov 14 09:22:37 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rlist.h"
#include "vector.h"
#include "strings.h"

#define HERSH_FIRST_CHAR ((int)' ')
#define MAX_CHARS 256

#define RTD_DEFAULT_FONT "times.r"

// pathes relativ to GOOD_ROOT_DIR!
#define RTD_FONT_PATH "/fonts/"

#define	R_relativ(x)	((x) - (signed char)'R')


class RT_FontData {
    signed char l_off,r_off;
    short lines;
    short *ppline;
    signed char **px;
    signed char **py;
  public:
    RT_FontData(short n, signed char *buf);
    ~RT_FontData() {
	if (lines) {
	    if (ppline) delete ppline;
	    for(int t=0; t<lines;t++) {
		if (px[t]) delete px[t]; if (py[t]) delete py[t];
	    }
	    if (px) delete px; if (py) delete py;
	}
    }
    int get_lines() {return lines;}
    int get_width() {return r_off - l_off;}
    int get_numberOfPoints(int line) {return ppline[line];}
    RT_Vector get_point(int line, int point) {
	return RT_Vector(px[line][point], py[line][point], 0);
    }
};

extern const char *RTN_FONT;

class RT_Font: public RT_GeneralListEntry {
    RT_String fName; // the font name
    int nchars, maxPoints, maxLines, baseLineDist, capHeight;
    RT_FontData *fData[MAX_CHARS];
  public:
    RT_Font(char*, FILE*);
    ~RT_Font() { for(int t=0; t< 256; t++) if (fData[t]) delete fData[t]; }
    char *getName() const { return (char*)fName; }
    int isA(const char *_c) const { return RTM_isA( _c, RTN_FONT ); }
    void print(FILE *f) const {fprintf( f, "FONT %s\n", (char*)fName );  }
    int get_lines( int code ) {	return (code < MAX_CHARS && fData[code]) ? fData[code]->get_lines() : 0;}
    int get_numberOfPoints( int code, int line ) {return (code < MAX_CHARS && fData[code]) ? fData[code]->get_numberOfPoints(line) : 0;}
    double get_charWidth( int code ) {return (code < MAX_CHARS && fData[code]) ? (double)fData[code]->get_width() / (capHeight) : 0;}
    double get_spacing() { return 0; }
    RT_Vector get_point( int code, int line, int point ) {return (code < MAX_CHARS && fData[code]) ?fData[code]->get_point(line,point) * (1.0 /(capHeight)) : RT_Vector(0,0,0);}
    int get_maxPoints() { return maxPoints; }
    int get_totalLines() { return maxLines; }
    int get_type() {return 1;} // line font
    double get_baseLineDist() { return (double)(baseLineDist) / capHeight;}
    double get_capHeight() {return 1;}
    
};

extern RT_Font *rt_DefaultFont;

class RT_FontServer: public RT_GeneralList {
  public:
    RT_Font *getFont(char*); 
    // returns a Font structure
    // if the font doesn't exist -> load the font
    // if server cannot load the font -> return 0
};

#endif

	


